/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsActionEx;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestExecutionUtil;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunMode;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestElements;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLinker;
import com.jetbrains.cidr.execution.testing.google.GoogleTestLanguageSupport;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrTestCommandLineState<CONFIGURATION> {
    public static final Supplier<CidrTestScope> EMPTY_TEST_SCOPE_PRODUCER = () -> CidrTestScope.createEmptyTestScope((String)GoogleTestLanguageSupport.getInstance().getPatternSeparatorInCommandLine());

    public CidrGoogleTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        if (configuration == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(0);
        }
        if (launcher == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(3);
        }
        super(configuration, launcher, env, executor, failedTests, EMPTY_TEST_SCOPE_PRODUCER);
    }

    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView consoleView) {
        if (consoleView == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(4);
        }
        return new CidrRerunFailedTestsActionEx((ComponentContainer)consoleView, testContext -> {
            String url = ((AbstractTestProxy)testContext.first).getLocationUrl();
            if (url != null && url.startsWith("gtest://")) {
                return CidrGoogleTestLinker.create(url.substring("gtest://".length())).getPatternForCommandLine();
            }
            return null;
        }, (CidrTestCommandLineState)this);
    }

    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@Nullable String suiteName, @Nullable String testName) {
        CidrTestScopeElement cidrTestScopeElement = CidrGoogleTestElements.createTestScopeElementForSuiteAndTest(suiteName, testName);
        if (cidrTestScopeElement == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(5);
        }
        return cidrTestScopeElement;
    }

    public void prepareTestExecutionEnvironment(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(6);
        }
        CidrTestRunConfiguration configuration = this.getConfiguration();
        CidrTestRunConfigurationData data = configuration.getTestData();
        CidrTestLanguageSupport tls = GoogleTestLanguageSupport.getInstance();
        Project project = configuration.getProject();
        String pattern = CidrTestExecutionUtil.getAsPatternForCommandLine((Project)project, arg_0 -> ((CidrTestLanguageSupport)tls).getElementsInFile(arg_0), EMPTY_TEST_SCOPE_PRODUCER, () -> tls.areSymbolsLoaded(project), (CidrTestScope)this.testScope(), (ProgressIndicator)progress);
        data.setCommandLineTestPattern(pattern);
        super.prepareTestExecutionEnvironment(progress);
    }

    @Contract(pure=true)
    protected boolean needCloseBeforeTestRunTaskResults() {
        return false;
    }

    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        String commandLineTestPattern;
        if (cl == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(7);
        }
        if (this.myRunMode == CidrTestRunMode.GET_TEST_LIST) {
            cl.addParameter("--gtest_list_tests");
        }
        if (!StringUtil.isEmpty((String)(commandLineTestPattern = this.getConfiguration().getTestData().getCommandLineTestPattern()))) {
            if (CidrGoogleTestCommandLineState.isFilterFromEnvironment()) {
                cl.getEnvironment().put("GTEST_FILTER", commandLineTestPattern);
            } else {
                cl.addParameter("--gtest_filter=" + commandLineTestPattern);
            }
        }
        if (this.myRunMode == CidrTestRunMode.RUN_TEST) {
            cl.addParameter("--gtest_color=no");
        }
        return cl;
    }

    private static boolean isFilterFromEnvironment() {
        return SystemInfo.isWindows && Registry.is((String)"cidr.test.framework.windows.filter.env");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestCommandLineState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestCommandLineState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestScopeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRerunFailedTestsAction";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestExecutionEnvironment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

