/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacadeUtil;", "", "()V", "myLanguageKindForH", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "detectMostFrequentSourcesKind", "project", "Lcom/intellij/openapi/project/Project;", "getResolveInfoForFile", "Lcom/jetbrains/cidr/lang/daemon/clang/ClangUtils$ResolveInfo;", "ocFile", "Lcom/jetbrains/cidr/lang/psi/OCPsiFile;", "vf", "Lcom/intellij/openapi/vfs/VirtualFile;", "isCSource", "", "name", "", "isCppSource", "Companion", "intellij.c.clangdBridge"})
public final class ClangIdeFacadeUtil {
    private volatile OCLanguageKind myLanguageKindForH;
    @NotNull
    private static final ClangIdeFacadeUtil instance;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final ClangUtils.ResolveInfo getResolveInfoForFile(@NotNull Project project, @NotNull OCPsiFile ocFile, @NotNull VirtualFile vf) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ocFile, (String)"ocFile");
        Intrinsics.checkNotNullParameter((Object)vf, (String)"vf");
        OCResolveConfiguration configuration = null;
        VirtualFile rootVirtualFile = null;
        OCLanguageKind languageKind = null;
        if (FileSymbolTablesCache.areSymbolsLoaded((Project)project)) {
            try {
                OCResolveRootAndConfiguration oCResolveRootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration((VirtualFile)vf, (Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)oCResolveRootAndConfiguration, (String)"OCInclusionContextUtil.g\u2026onfiguration(vf, project)");
                OCResolveRootAndConfiguration rrAndConfig = oCResolveRootAndConfiguration;
                configuration = rrAndConfig.getConfiguration();
                rootVirtualFile = rrAndConfig.getRootFile();
                languageKind = ocFile.getKind();
            }
            catch (ProcessCanceledException ex) {
                throw (Throwable)ex;
            }
            catch (Throwable thr) {
                configuration = null;
                rootVirtualFile = null;
                languageKind = null;
            }
        }
        if (configuration == null || rootVirtualFile == null || languageKind == null) {
            Collection collection = OCImportGraph.getInstance((Project)project).findAllRootsThatInclude(vf, false);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"OCImportGraph.getInstanc\u2026otsThatInclude(vf, false)");
            Collection roots = collection;
            for (VirtualFile root : roots) {
                String extension;
                String string;
                OCResolveConfiguration conf = OCResolveConfigurations.doGetPreselectedConfiguration((VirtualFile)root, (Project)project);
                if (conf == null) continue;
                configuration = conf;
                rootVirtualFile = root;
                VirtualFile virtualFile = root;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"root");
                languageKind = OCLanguageKindCalculator.calculateMinimalKindByExtension((Project)project, (String)virtualFile.getName());
                if (root.getExtension() != null) {
                    String string2 = root.getExtension();
                    Intrinsics.checkNotNull((Object)string2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"root.extension!!");
                    String string3 = string2;
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
                    Locale locale2 = locale;
                    boolean bl = false;
                    String string4 = string3;
                    boolean bl2 = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.toLowerCase(locale2);
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
                } else {
                    string = extension = null;
                }
                if (!Intrinsics.areEqual((Object)"h", extension)) break;
                OCLanguageKind defaultKind = this.myLanguageKindForH;
                if (defaultKind == null && (defaultKind = this.detectMostFrequentSourcesKind(project)) != null && this.myLanguageKindForH == null) {
                    this.myLanguageKindForH = defaultKind;
                }
                if (defaultKind == null) break;
                languageKind = defaultKind;
                break;
            }
        }
        if (configuration != null && rootVirtualFile != null && languageKind != null) {
            boolean guessed = !configuration.hasSourceFile(rootVirtualFile);
            return new ClangUtils.ResolveInfo(configuration, rootVirtualFile, languageKind, guessed);
        }
        return null;
    }

    private final OCLanguageKind detectMostFrequentSourcesKind(Project project) {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile projectDir = virtualFile;
        long timestamp = System.currentTimeMillis();
        AtomicInteger cppCounter = new AtomicInteger(0);
        AtomicInteger cCounter = new AtomicInteger(0);
        FileUtil.visitFiles((File)projectDir.toNioPath().toFile(), (Processor)new Processor(this, cppCounter, cCounter, timestamp){
            final /* synthetic */ ClangIdeFacadeUtil this$0;
            final /* synthetic */ AtomicInteger $cppCounter;
            final /* synthetic */ AtomicInteger $cCounter;
            final /* synthetic */ long $timestamp;

            public final boolean process(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ProgressManager.checkCanceled();
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                String string2 = string;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
                Locale locale2 = locale;
                boolean bl = false;
                String string3 = string2;
                boolean bl2 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                String name = string5;
                if (!StringsKt.startsWith$default((String)name, (String)"cmakecxxcompilerid", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"cmakeccompilerid", (boolean)false, (int)2, null)) {
                    if (ClangIdeFacadeUtil.access$isCppSource(this.this$0, name)) {
                        this.$cppCounter.incrementAndGet();
                    } else if (ClangIdeFacadeUtil.access$isCSource(this.this$0, name)) {
                        this.$cCounter.incrementAndGet();
                    }
                }
                return System.currentTimeMillis() - this.$timestamp < (long)3000;
            }
            {
                this.this$0 = clangIdeFacadeUtil;
                this.$cppCounter = atomicInteger;
                this.$cCounter = atomicInteger2;
                this.$timestamp = l;
            }
        });
        if (cppCounter.get() == 0 && cCounter.get() == 0) {
            return null;
        }
        return cppCounter.get() > cCounter.get() ? (OCLanguageKind)CLanguageKind.CPP : (OCLanguageKind)CLanguageKind.C;
    }

    private final boolean isCppSource(String name) {
        return StringUtils.endsWith((CharSequence)name, (CharSequence)".c++") || StringUtils.endsWith((CharSequence)name, (CharSequence)".cc") || StringUtils.endsWith((CharSequence)name, (CharSequence)".cpp") || StringUtils.endsWith((CharSequence)name, (CharSequence)".cxx");
    }

    private final boolean isCSource(String name) {
        return StringUtils.endsWith((CharSequence)name, (CharSequence)".c");
    }

    static {
        Companion = new Companion(null);
        instance = new ClangIdeFacadeUtil();
    }

    public static final /* synthetic */ boolean access$isCppSource(ClangIdeFacadeUtil $this, String name) {
        return $this.isCppSource(name);
    }

    public static final /* synthetic */ boolean access$isCSource(ClangIdeFacadeUtil $this, String name) {
        return $this.isCSource(name);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacadeUtil$Companion;", "", "()V", "instance", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacadeUtil;", "getInstance", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangIdeFacadeUtil;", "intellij.c.clangdBridge"})
    public static final class Companion {
        @NotNull
        public final ClangIdeFacadeUtil getInstance() {
            return instance;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

