/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ClangTidyStartupActivity
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(ClangTidyStartupActivity.class);
    private QueueProcessor<ScanEvent> queueProcessor = null;

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.doRunActivity(project);
    }

    public void doRunActivity(final @NotNull Project project) {
        if (project == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(1);
        }
        if (project.isDefault() || project.isDisposed()) {
            return;
        }
        this.queueProcessor = new QueueProcessor(e -> ClangTidyStartupActivity.doScan(e));
        this.queueProcessor.add((Object)new ScanEvent(null, project));
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    ClangTidyStartupActivity.this.queueProcessor.add((Object)new ScanEvent(vFileEvent, project));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyStartupActivity$1", "after"));
            }
        });
    }

    @TestOnly
    public void waitForQueueProcessor() {
        this.queueProcessor.waitFor();
    }

    private static void doScan(@NotNull ScanEvent scanEvent) {
        if (scanEvent == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(2);
        }
        VFileEvent fileEvent = scanEvent.myEvent;
        Project project = scanEvent.myProject;
        if (((Boolean)ReadAction.compute(() -> project.isDisposed())).booleanValue()) {
            return;
        }
        ClangTidyFilesState state = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class);
        if (fileEvent == null) {
            String basePath = project.getBasePath();
            if (StringUtil.isEmpty((String)basePath)) {
                LOG.info("Cannot run ClangTidyStartupActivity since basePath is empty");
                return;
            }
            List<File> clangTidyFiles = ClangTidyStartupActivity.findClangTidyFiles(new File(basePath));
            state.setClangTidyFiles(clangTidyFiles);
            ClangTidyStartupActivity.dumpClangTidyFiles(state);
            return;
        }
        VirtualFile file = fileEvent.getFile();
        if (file == null) {
            LOG.debug("Cannot process VFileEvent: VirtualFile is null");
            return;
        }
        boolean hasChanges = false;
        if (fileEvent instanceof VFileDeleteEvent) {
            hasChanges = ClangTidyStartupActivity.removeFileOrDirectory(file.getPath(), file.isDirectory(), state);
        } else if (fileEvent instanceof VFileMoveEvent) {
            hasChanges = ClangTidyStartupActivity.removeFileOrDirectory(((VFileMoveEvent)fileEvent).getOldPath(), file.isDirectory(), state);
            hasChanges |= ClangTidyStartupActivity.addFileOrDirectory(file, state);
        } else if (fileEvent instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent propertyChangeEvent = (VFilePropertyChangeEvent)fileEvent;
            if (propertyChangeEvent.getPropertyName().equals("name")) {
                hasChanges = ClangTidyStartupActivity.removeFileOrDirectory(propertyChangeEvent.getOldPath(), file.isDirectory(), state);
                hasChanges |= ClangTidyStartupActivity.addFileOrDirectory(file, state);
            }
        } else if (fileEvent instanceof VFileCreateEvent) {
            hasChanges = ClangTidyStartupActivity.addFileOrDirectory(file, state);
        } else if (fileEvent instanceof VFileCopyEvent) {
            VFileCopyEvent copyEvent = (VFileCopyEvent)fileEvent;
            VirtualFile createdFile = copyEvent.findCreatedFile();
            if (createdFile == null) {
                LOG.debug("Cannot process VFileEvent: created file is null");
                return;
            }
            hasChanges = ClangTidyStartupActivity.addFileOrDirectory(createdFile, state);
        }
        if (hasChanges) {
            ClangTidyStartupActivity.dumpClangTidyFiles(state);
        }
    }

    private static boolean addFileOrDirectory(@NotNull VirtualFile file, @NotNull ClangTidyFilesState state) {
        if (file == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(3);
        }
        if (state == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(4);
        }
        if (!file.isValid()) {
            LOG.debug("Cannot process VFileEvent: VirtualFile is not valid");
            return false;
        }
        if (file.isDirectory()) {
            List<VirtualFile> childFiles = ClangTidyStartupActivity.findClangTidyFiles(file);
            if (!childFiles.isEmpty()) {
                for (VirtualFile childFile : childFiles) {
                    state.addClangTidyFile(new File(childFile.getPath()));
                }
                return true;
            }
        } else if (ClangTidyStartupActivity.isClangTidyFile(file)) {
            state.addClangTidyFile(new File(file.getPath()));
            return true;
        }
        return false;
    }

    private static boolean removeFileOrDirectory(@NotNull String filePath, boolean isDirectory, @NotNull ClangTidyFilesState state) {
        if (filePath == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(5);
        }
        if (state == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(6);
        }
        File file = new File(filePath);
        if (!isDirectory && ClangTidyStartupActivity.isClangTidyFile(file)) {
            state.removeClangTidyFile(file);
            return true;
        }
        boolean hasChanges = false;
        List<File> clangTidyFiles = state.getClangTidyFiles();
        for (File clangTidyFile : clangTidyFiles) {
            if (!FileUtil.isAncestor((File)file, (File)clangTidyFile, (boolean)true)) continue;
            state.removeClangTidyFile(clangTidyFile);
            hasChanges = true;
        }
        return hasChanges;
    }

    @NotNull
    private static List<VirtualFile> findClangTidyFiles(@NotNull VirtualFile rootFile) {
        if (rootFile == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(7);
        }
        final ArrayList<VirtualFile> clangTidyFiles = new ArrayList<VirtualFile>();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)rootFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (ClangTidyStartupActivity.isClangTidyFile(file)) {
                    clangTidyFiles.add(file);
                }
                VirtualFileVisitor.Result result2 = CONTINUE;
                if (result2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyStartupActivity$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyStartupActivity$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        ArrayList<VirtualFile> arrayList = clangTidyFiles;
        if (arrayList == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static List<File> findClangTidyFiles(@NotNull File baseDir) {
        if (baseDir == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(9);
        }
        ArrayList<File> clangTidyFiles = new ArrayList<File>();
        ClangTidyStartupActivity.visitFilesIgnoringSymlinks(baseDir, (Processor<? super File>)((Processor)file -> {
            if (ClangTidyStartupActivity.isClangTidyFile(file)) {
                clangTidyFiles.add((File)file);
            }
            return true;
        }));
        ArrayList<File> arrayList = clangTidyFiles;
        if (arrayList == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static boolean visitFilesIgnoringSymlinks(@NotNull File root, @NotNull Processor<? super File> processor) {
        if (root == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(12);
        }
        if (!processor.process((Object)root)) {
            return false;
        }
        File[] children = root.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory() && Files.isSymbolicLink(child.toPath()) || ClangTidyStartupActivity.visitFilesIgnoringSymlinks(child, processor)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isClangTidyFile(@NotNull VirtualFile file) {
        if (file == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(13);
        }
        return file.getName().equals(".clang-tidy");
    }

    private static boolean isClangTidyFile(@NotNull File file) {
        if (file == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(14);
        }
        return file.getName().equals(".clang-tidy");
    }

    private static void dumpClangTidyFiles(@NotNull ClangTidyFilesState state) {
        if (state == null) {
            ClangTidyStartupActivity.$$$reportNull$$$0(15);
        }
        LOG.debug("Clang-Tidy files in project: [" + StringUtil.join(state.getClangTidyFiles(), (String)",") + "]");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanEvent";
                break;
            }
            case 3: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyStartupActivity";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyStartupActivity";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findClangTidyFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doRunActivity";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doScan";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFileOrDirectory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeFileOrDirectory";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findClangTidyFiles";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitFilesIgnoringSymlinks";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isClangTidyFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "dumpClangTidyFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ScanEvent {
        VFileEvent myEvent;
        Project myProject;

        ScanEvent(@Nullable VFileEvent event, @NotNull Project project) {
            if (project == null) {
                ScanEvent.$$$reportNull$$$0(0);
            }
            this.myEvent = event;
            this.myProject = project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyStartupActivity$ScanEvent", "<init>"));
        }
    }
}

