/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.VersionUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUpdatedChecksDialog;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyUpdateStartupActivity
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(ClangTidyUpdateStartupActivity.class);
    private static final int TIMEOUT_IN_MS = 30000;

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(0);
        }
        if (!ClangTidyAnnotator.getBuiltinClangTidyPath().exists()) {
            return;
        }
        Task.Backgroundable task2 = new Task.Backgroundable(project, OCInspectionsBundle.message((String)"clang.tidy.check.for.update.task", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ClangTidySettings settings = ClangTidySettings.getInstance();
                Version actualClangTidyVersion = ClangTidyUpdateStartupActivity.getActualClangTidyVersion(indicator);
                if (actualClangTidyVersion == null) {
                    return;
                }
                Version previousClangTidyVersion = VersionUtil.parseVersion((String)StringUtil.notNullize((String)settings.getPreviousClangTidyVersion()), (Pattern[])new Pattern[]{ClangTidyUtil.CLANG_TIDY_VERSION_PATTERN});
                Set<String> actualClangTidyChecks = ClangTidyUpdateStartupActivity.getActualClangTidyChecks(indicator);
                if (actualClangTidyChecks == null) {
                    return;
                }
                Set<String> previousClangTidyChecks = settings.getPreviousClangTidyChecks();
                ClangTidyUpdateStartupActivity.showNotificationOnUpdate(actualClangTidyVersion, previousClangTidyVersion, actualClangTidyChecks, previousClangTidyChecks, project);
                settings.setPreviousClangTidyVersion(actualClangTidyVersion.toString());
                settings.setPreviousClangTidyChecks(actualClangTidyChecks);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyUpdateStartupActivity$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task2);
    }

    private static void showNotificationOnUpdate(@NotNull Version actualClangTidyVersion, @Nullable Version previousClangTidyVersion, @NotNull Set<String> actualClangTidyChecks, @Nullable Set<String> previousClangTidyChecks, final @NotNull Project project) {
        if (actualClangTidyVersion == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(1);
        }
        if (actualClangTidyChecks == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(3);
        }
        if (previousClangTidyVersion == null || previousClangTidyChecks == null) {
            return;
        }
        if (!ClangTidyUpdateStartupActivity.isVersionUpdated(actualClangTidyVersion, previousClangTidyVersion)) {
            return;
        }
        final HashSet<String> newChecks = new HashSet<String>(actualClangTidyChecks);
        newChecks.removeAll(previousClangTidyChecks);
        if (newChecks.isEmpty()) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Clang-Tidy Updated");
        Notification notification = notificationGroup.createNotification(OCInspectionsBundle.message((String)"clang.tidy.update.notification.title", (Object[])new Object[0]), ClangTidyUpdateStartupActivity.getNotificationMessage(newChecks), NotificationType.INFORMATION);
        notification.addAction((AnAction)new DumbAwareAction(OCInspectionsBundle.message((String)"clang.tidy.update.review.new.checks.link", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ClangTidyUpdatedChecksDialog dialog = new ClangTidyUpdatedChecksDialog(newChecks, project);
                dialog.showAndGet();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyUpdateStartupActivity$2", "actionPerformed"));
            }
        });
        notification.notify(project);
    }

    @NotNull
    @NlsContexts.NotificationContent
    private static String getNotificationMessage(@NotNull Collection<String> newChecks) {
        if (newChecks == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(4);
        }
        int howManyChecks = newChecks.size() == 1 ? 1 : 2;
        String string = OCInspectionsBundle.message((String)"clang.tidy.update.notification.message", (Object[])new Object[]{newChecks.size(), howManyChecks});
        if (string == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean isVersionUpdated(@NotNull Version actualClangTidyVersion, @NotNull Version previousClangTidyVersion) {
        if (actualClangTidyVersion == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(6);
        }
        if (previousClangTidyVersion == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(7);
        }
        return previousClangTidyVersion.compareTo(actualClangTidyVersion) <= 0;
    }

    @Nullable
    private static Version getActualClangTidyVersion(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(8);
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{ClangTidyAnnotator.getBuiltinClangTidyPath().getPath(), "--version"});
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = handler.runProcessWithProgressIndicator(indicator, 30000);
            return VersionUtil.parseVersion((String)output.getStdout().trim(), (Pattern[])new Pattern[]{ClangTidyUtil.CLANG_TIDY_VERSION_PATTERN});
        }
        catch (Exception e) {
            LOG.warn("Cannot get Clang-Tidy version", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Set<String> getActualClangTidyChecks(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ClangTidyUpdateStartupActivity.$$$reportNull$$$0(9);
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{ClangTidyAnnotator.getBuiltinClangTidyPath().getPath(), "--checks=*", "--list-checks"});
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
            ProcessOutput output = handler.runProcessWithProgressIndicator(indicator, 30000);
            String[] outputLines = StringUtil.splitByLines((String)output.getStdout());
            HashSet<String> checks = new HashSet<String>();
            for (String line : outputLines) {
                String trimmedLine = line.trim();
                if (StringUtil.isEmpty((String)trimmedLine) || StringUtil.startsWithIgnoreCase((String)trimmedLine, (String)"clion-") || StringUtil.startsWithIgnoreCase((String)trimmedLine, (String)"Enabled checks:")) continue;
                checks.add(trimmedLine);
            }
            return checks;
        }
        catch (Exception e) {
            LOG.warn("Cannot get Clang-Tidy checks", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualClangTidyVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualClangTidyChecks";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChecks";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyUpdateStartupActivity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousClangTidyVersion";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/startup/ClangTidyUpdateStartupActivity";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showNotificationOnUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationMessage";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVersionUpdated";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActualClangTidyVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getActualClangTidyChecks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

