/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.namehint;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.namehint.ClangAdvancedInlayParameterHintsProvider;
import com.jetbrains.cidr.lang.daemon.clang.namehint.ClangBasicInlayParameterHintsProvider;
import com.jetbrains.cidr.lang.daemon.clang.namehint.InlayHintsProvider;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eH\u0016J\u0006\u0010\"\u001a\u00020\u0011J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/namehint/ClangInlayParameterHintsProvider;", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "()V", "defaultBlacklist", "", "", "isShowHintsForConstructorExpressions", "Lcom/intellij/codeInsight/hints/Option;", "()Lcom/intellij/codeInsight/hints/Option;", "isShowHintsForEnumConstants", "isShowHintsForMacroExpressions", "isShowHintsForNonConstReferences", "provider", "Lcom/jetbrains/cidr/lang/daemon/clang/namehint/InlayHintsProvider;", "getProvider", "()Lcom/jetbrains/cidr/lang/daemon/clang/namehint/InlayHintsProvider;", "canShowHintsWhenDisabled", "", "createTraversal", "Lcom/intellij/psi/SyntaxTraverser;", "Lcom/intellij/psi/PsiElement;", "root", "getBlacklistExplanationHTML", "getDefaultBlackList", "getHintInfo", "Lcom/intellij/codeInsight/hints/HintInfo;", "_element", "_file", "Lcom/intellij/psi/PsiFile;", "getParameterHints", "", "Lcom/intellij/codeInsight/hints/InlayInfo;", "element", "getSupportedOptions", "isEnabled", "isLeafElem", "elem", "Companion", "intellij.c.clangdBridge"})
public final class ClangInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    @NotNull
    private final Option isShowHintsForEnumConstants;
    @NotNull
    private final Option isShowHintsForConstructorExpressions;
    @NotNull
    private final Option isShowHintsForMacroExpressions;
    @NotNull
    private final Option isShowHintsForNonConstReferences;
    private final Set<String> defaultBlacklist;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final InlayHintsProvider getProvider() {
        InlayHintsProvider inlayHintsProvider;
        boolean bl = Registry.is((String)"clang.default.inlay.hints");
        if (bl) {
            inlayHintsProvider = new ClangBasicInlayParameterHintsProvider();
        } else if (!bl) {
            inlayHintsProvider = new ClangAdvancedInlayParameterHintsProvider();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return inlayHintsProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEnabled() {
        Language language = OCLanguageUtils.getConfigLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"OCLanguageUtils.getConfigLanguage()");
        if (HintUtilsKt.isParameterHintsEnabledForLanguage((Language)language)) return true;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) return false;
        return true;
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element, @NotNull PsiFile _file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)_file, (String)"_file");
        if (!this.isEnabled() || !this.isLeafElem(element)) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile = _file;
        if (!(psiFile instanceof OCPsiFile)) {
            psiFile = null;
        }
        OCPsiFile oCPsiFile = (OCPsiFile)psiFile;
        if (oCPsiFile == null) {
            return CollectionsKt.emptyList();
        }
        OCPsiFile file = oCPsiFile;
        return this.getProvider().getParameterHints(element, file);
    }

    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement _element, @NotNull PsiFile _file) {
        Intrinsics.checkNotNullParameter((Object)_element, (String)"_element");
        Intrinsics.checkNotNullParameter((Object)_file, (String)"_file");
        PsiFile psiFile = _file;
        if (!(psiFile instanceof OCPsiFile)) {
            psiFile = null;
        }
        OCPsiFile oCPsiFile = (OCPsiFile)psiFile;
        if (oCPsiFile == null) {
            return null;
        }
        OCPsiFile file = oCPsiFile;
        PsiElement psiElement = file.asElementFromOCFile(_element);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"file.asElementFromOCFile(_element)");
        PsiElement element = psiElement;
        if (!this.isEnabled() || !this.isLeafElem(element)) {
            return null;
        }
        return this.getProvider().getHintInfo(element, file);
    }

    @NotNull
    public final Option isShowHintsForEnumConstants() {
        return this.isShowHintsForEnumConstants;
    }

    @NotNull
    public final Option isShowHintsForConstructorExpressions() {
        return this.isShowHintsForConstructorExpressions;
    }

    @NotNull
    public final Option isShowHintsForMacroExpressions() {
        return this.isShowHintsForMacroExpressions;
    }

    @NotNull
    public final Option isShowHintsForNonConstReferences() {
        return this.isShowHintsForNonConstReferences;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        return CollectionsKt.listOf((Object[])new Option[]{this.isShowHintsForEnumConstants, this.isShowHintsForConstructorExpressions, this.isShowHintsForMacroExpressions, this.isShowHintsForNonConstReferences});
    }

    public boolean canShowHintsWhenDisabled() {
        return false;
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        return this.defaultBlacklist;
    }

    @NotNull
    public SyntaxTraverser<PsiElement> createTraversal(@NotNull PsiElement root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        SyntaxTraverser syntaxTraverser = super.createTraversal(OCPsiFile.tryGetElementFromOCFile((PsiElement)root));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"super.createTraversal(OC\u2026tElementFromOCFile(root))");
        return syntaxTraverser;
    }

    @NotNull
    public String getBlacklistExplanationHTML() {
        String string = OCBundle.message((String)"oc.inlay.hints.blacklist.pattern.explanation", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OCBundle.message(\"oc.inl\u2026ist.pattern.explanation\")");
        return string;
    }

    private final boolean isLeafElem(PsiElement elem) {
        return elem instanceof LeafElement;
    }

    public ClangInlayParameterHintsProvider() {
        Supplier supplier = OCBundle.messagePointer((String)"oc.inlay.hints.show.hints.for.enum.constants", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"OCBundle.messagePointer(\u2026ints.for.enum.constants\")");
        this.isShowHintsForEnumConstants = new Option("oc.clangd.namehints.enums", supplier, true);
        Supplier supplier2 = OCBundle.messagePointer((String)"oc.inlay.hints.show.hints.for.constructors", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"OCBundle.messagePointer(\u2026.hints.for.constructors\")");
        this.isShowHintsForConstructorExpressions = new Option("oc.clangd.namehints.construct.expr", supplier2, true);
        Supplier supplier3 = OCBundle.messagePointer((String)"oc.inlay.hints.show.hints.for.macros", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier3, (String)"OCBundle.messagePointer(\u2026s.show.hints.for.macros\")");
        this.isShowHintsForMacroExpressions = new Option("oc.clangd.namehints.macro.expr", supplier3, true);
        Supplier supplier4 = OCBundle.messagePointer((String)"oc.inlay.hints.show.amp.nonconst.references", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier4, (String)"OCBundle.messagePointer(\u2026amp.nonconst.references\")");
        this.isShowHintsForNonConstReferences = new Option("oc.clangd.namehints.non.const.references", supplier4, true);
        this.defaultBlacklist = SetsKt.setOf((Object[])new String[]{"assert(*)", "std::forward(*)", "std::min(*, *)", "std::max(*, *)", "*strcmp(*, *)", "*strncmp(*, *, *)", "*wcscmp(*, *)", "std::vector::push_back(*)", "std::array::array(*)"});
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/namehint/ClangInlayParameterHintsProvider$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/lang/daemon/clang/namehint/ClangInlayParameterHintsProvider;", "intellij.c.clangdBridge"})
    public static final class Companion {
        @NotNull
        public final ClangInlayParameterHintsProvider getInstance() {
            Object object = InlayParameterHintsExtension.INSTANCE.forLanguage(OCLanguageUtils.getConfigLanguage());
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.lang.daemon.clang.namehint.ClangInlayParameterHintsProvider");
            }
            return (ClangInlayParameterHintsProvider)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

