/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClangTidySuppressIntentionAction
extends SuppressIntentionAction {
    @NotNull
    private final String myCheckName;
    @NotNull
    private static final Pattern NOLINT_ARGS_PATTERN = Pattern.compile(".*NOLINT\\s*\\((.*)\\).*");

    public ClangTidySuppressIntentionAction(@NotNull String checkName) {
        if (checkName == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(0);
        }
        this.myCheckName = checkName;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(1);
        }
        if (element == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            return;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        PsiFile file = element.getContainingFile();
        int offset = element.getTextOffset();
        int lineEndOffset = DocumentUtil.getLineEndOffset((int)offset, (Document)document);
        PsiElement elementAtEnd = file.findElementAt(lineEndOffset - 1);
        if (elementAtEnd instanceof PsiComment) {
            PsiComment commentElement = (PsiComment)elementAtEnd;
            String commentText = elementAtEnd.getText();
            Matcher matcher = NOLINT_ARGS_PATTERN.matcher(commentText);
            if (matcher.find()) {
                String checkNameList = matcher.group(1);
                ClangTidySuppressIntentionAction.insertNoLintComment((String)(checkNameList.trim().isEmpty() ? this.myCheckName : "," + this.myCheckName), commentElement.getTextOffset() + matcher.start(1) + checkNameList.length(), file, project);
                return;
            }
            if (commentElement.getTokenType() == OCTokenTypes.EOL_COMMENT) {
                ClangTidySuppressIntentionAction.insertNoLintComment(" NOLINT(" + this.myCheckName + ")", lineEndOffset, file, project);
                return;
            }
        }
        ClangTidySuppressIntentionAction.insertNoLintComment(" // NOLINT(" + this.myCheckName + ")", lineEndOffset, file, project);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        int offset;
        int lineNumber;
        TextRange lineTextRange;
        if (project == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(4);
        }
        if (editor == null || !element.isValid()) {
            return false;
        }
        Document document = editor.getDocument();
        String lineText = document.getText(lineTextRange = DocumentUtil.getLineTextRange((Document)document, (int)(lineNumber = document.getLineNumber(offset = element.getTextOffset()))));
        return !lineText.endsWith("\\");
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"inspection.clangTidy.suppress.for.line", (Object[])new Object[0]);
        if (string == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message((String)"inspection.clangTidy.suppress.check.for.line", (Object[])new Object[]{StringUtil.wrapWithDoubleQuote((String)this.myCheckName)});
        if (string == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void insertNoLintComment(@NotNull String comment, int offset, @NotNull PsiFile file, @NotNull Project project) {
        if (comment == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(8);
        }
        if (project == null) {
            ClangTidySuppressIntentionAction.$$$reportNull$$$0(9);
        }
        boolean commitDocument = ApplicationManager.getApplication().isUnitTestMode();
        OCChangeUtil.changeText((Project)project, (PsiFile)file, (int)offset, (int)0, (String)comment, (boolean)commitDocument);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidySuppressIntentionAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidySuppressIntentionAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "insertNoLintComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

