/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyConfigurable;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOptionsButton;
import com.jetbrains.cidr.lang.inspections.ClangTidyChecksOptionsDialog;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyInspection
extends ClangTidyInspectionBase
implements ExternalAnnotatorBatchInspection {
    @NotNull
    private String myClangTidyChecks = ClangTidyInspection.getDefaultChecks();
    private boolean myPreferClangTidyFilesOverIDESettings = true;
    @NotNull
    private static final List<String> DEFAULT_CHECKS_CONFIGURATION = ClangTidyInspection.getDefaultChecksConfiguration();

    public boolean isEnabledByDefault() {
        return ClangTidyAnnotator.isAvailable();
    }

    @NotNull
    public static String getInspectionShortName() {
        String string = new ClangTidyInspection().getShortName();
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.static.analysis", (Object[])new Object[0]);
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.clangTidy.name", (Object[])new Object[0]);
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        JPanel childPanel = new JPanel(new GridBagLayout());
        ClangTidyInspection.addComponent((Component)this.createClangTidyFilesCheckbox(), childPanel, 0, 2, 0, 1, 0, (Insets)JBUI.insetsBottom((int)10));
        ClangTidyInspection.addComponent(this.createChecksField(), childPanel, 0, 2, 1, 1, 0, (Insets)JBUI.emptyInsets());
        ClangTidyInspection.addComponent((Component)new JBLabel(OCInspectionsBundle.message((String)"configurable.clangTidy.checks.hint", (Object[])new Object[0]), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), childPanel, 0, 1, 2, 0, 0, (Insets)JBUI.emptyInsets());
        ClangTidyInspection.addComponent((Component)ClangTidyInspection.createChecksExampleLink(), childPanel, 1, 1, 2, 0, 0, (Insets)JBUI.emptyInsets());
        ClangTidyInspection.addComponent(this.createOptionsButton(childPanel), childPanel, 0, 2, 3, 1, 1, (Insets)JBUI.emptyInsets());
        builder.addComponent((JComponent)childPanel);
        builder.addComponent((JComponent)CidrLangUtil.createLinkToConfigurable((String)OCInspectionsBundle.message((String)"configurable.clangTidy.executable", (Object[])new Object[0]), ClangTidyConfigurable.class, null, null), 10);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)builder.getPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel;
    }

    @NotNull
    private JBCheckBox createClangTidyFilesCheckbox() {
        final JBCheckBox checkBox = new JBCheckBox(OCInspectionsBundle.message((String)"configurable.clangTidy.prefer.files.over.ide.settings", (Object[])new Object[0]), this.myPreferClangTidyFilesOverIDESettings);
        checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ClangTidyInspection.this.myPreferClangTidyFilesOverIDESettings = checkBox.isSelected();
            }
        });
        JBCheckBox jBCheckBox = checkBox;
        if (jBCheckBox == null) {
            ClangTidyInspection.$$$reportNull$$$0(3);
        }
        return jBCheckBox;
    }

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        if (clangTidyMessage == null) {
            ClangTidyInspection.$$$reportNull$$$0(4);
        }
        String string = isBatchMode ? clangTidyMessage : OCInspectionsBundle.message((String)"inspection.clangTidy.message", (Object[])new Object[]{clangTidyMessage});
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            ClangTidyInspection.$$$reportNull$$$0(6);
        }
        if (project == null) {
            ClangTidyInspection.$$$reportNull$$$0(7);
        }
        ClangTidyFilesState clangTidyFilesState = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class);
        return !this.myPreferClangTidyFilesOverIDESettings || !clangTidyFilesState.hasClangTidyFilesInPath(new File(file.getPath()));
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        if (clangTidyCheckName == null) {
            ClangTidyInspection.$$$reportNull$$$0(8);
        }
        String string = clangTidyCheckName;
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static void addComponent(@NotNull Component component, @NotNull JPanel panel, int gridX, int gridWidth, int gridY, int weightX, int weightY, @NotNull Insets insets) {
        if (component == null) {
            ClangTidyInspection.$$$reportNull$$$0(10);
        }
        if (panel == null) {
            ClangTidyInspection.$$$reportNull$$$0(11);
        }
        if (insets == null) {
            ClangTidyInspection.$$$reportNull$$$0(12);
        }
        panel.add(component, new GridBagConstraints(gridX, gridY, gridWidth, 1, weightX, weightY, 18, 2, insets, 0, 0));
    }

    @NotNull
    private JComponent createOptionsButton(final @NotNull Component component) {
        if (component == null) {
            ClangTidyInspection.$$$reportNull$$$0(13);
        }
        final ClangTidyCheckOptionsButton checkOptionsButton = new ClangTidyCheckOptionsButton(OCInspectionsBundle.message((String)"configurable.clangTidy.checks.options.button", (Object[])new Object[0]));
        checkOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List checkOptions = ClangTidyInspection.this.myClangTidyCheckOptions;
                ClangTidyChecksOptionsDialog optionsDialog = new ClangTidyChecksOptionsDialog(component, checkOptions);
                optionsDialog.showAndGet();
                if (!ClangTidyInspection.this.myClangTidyCheckOptions.equals(checkOptions)) {
                    ClangTidyInspection.this.myClangTidyCheckOptions = checkOptions;
                    checkOptionsButton.fireStateChanged();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)checkOptionsButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            ClangTidyInspection.$$$reportNull$$$0(14);
        }
        return jPanel;
    }

    @NotNull
    private JComponent createChecksField() {
        final RawCommandLineEditor checksEditor = new RawCommandLineEditor(text -> StringUtil.split((String)text, (String)","), checks -> StringUtil.join((Collection)checks, (String)","));
        checksEditor.setText(this.myClangTidyChecks);
        checksEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ClangTidyInspection.this.myClangTidyChecks = checksEditor.getText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/inspections/ClangTidyInspection$3", "textChanged"));
            }
        });
        RawCommandLineEditor rawCommandLineEditor = checksEditor;
        if (rawCommandLineEditor == null) {
            ClangTidyInspection.$$$reportNull$$$0(15);
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private static HyperlinkLabel createChecksExampleLink() {
        HyperlinkLabel hint = new HyperlinkLabel(OCInspectionsBundle.message((String)"configurable.clangTidy.example.link", (Object[])new Object[0]));
        hint.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://clang.llvm.org/extra/clang-tidy/#using-clang-tidy"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        HyperlinkLabel hyperlinkLabel = hint;
        if (hyperlinkLabel == null) {
            ClangTidyInspection.$$$reportNull$$$0(16);
        }
        return hyperlinkLabel;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ClangTidyInspection.$$$reportNull$$$0(17);
        }
        if (manager == null) {
            ClangTidyInspection.$$$reportNull$$$0(18);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    public ProblemDescriptor @NotNull [] checkFile(@NotNull PsiFile file, @NotNull GlobalInspectionContext context, @NotNull InspectionManager manager) {
        if (file == null) {
            ClangTidyInspection.$$$reportNull$$$0(19);
        }
        if (context == null) {
            ClangTidyInspection.$$$reportNull$$$0(20);
        }
        if (manager == null) {
            ClangTidyInspection.$$$reportNull$$$0(21);
        }
        ClangTidyAnnotator annotator = new ClangTidyAnnotator(this);
        ProblemDescriptor[] problemDescriptorArray = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator((PsiFile)file, (InspectionManager)manager, (boolean)false, (ExternalAnnotator)annotator);
        if (problemDescriptorArray == null) {
            ClangTidyInspection.$$$reportNull$$$0(22);
        }
        return problemDescriptorArray;
    }

    @Override
    public boolean isPreferClangTidyFilesOverIDESettings() {
        return this.myPreferClangTidyFilesOverIDESettings;
    }

    public void setPreferClangTidyFilesOverIDESettings(boolean preferClangTidyFilesOverIDESettings) {
        this.myPreferClangTidyFilesOverIDESettings = preferClangTidyFilesOverIDESettings;
    }

    @NotNull
    public String getClangTidyChecks() {
        return !this.myClangTidyChecks.isEmpty() ? this.myClangTidyChecks : ClangTidyInspection.getAllDisabledChecks();
    }

    public void setClangTidyChecks(@NotNull String clangTidyChecks) {
        if (clangTidyChecks == null) {
            ClangTidyInspection.$$$reportNull$$$0(23);
        }
        this.myClangTidyChecks = clangTidyChecks;
    }

    @NotNull
    public static String getDefaultChecks() {
        String string = StringUtil.join(DEFAULT_CHECKS_CONFIGURATION, (String)",");
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public static String getAllEnabledChecks() {
        return "*";
    }

    @NotNull
    public static String getAllEnabledChecksExceptClangAnalyzer() {
        return "*,-clang-analyzer-*";
    }

    @NotNull
    public static String getAllDisabledChecks() {
        return "-*";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static List<String> getDefaultChecksConfiguration() {
        @NonNls ArrayList enabledChecks = ContainerUtil.newArrayList((Object[])new String[]{"bugprone-argument-comment", "bugprone-assert-side-effect", "bugprone-bad-signal-to-kill-thread", "bugprone-branch-clone", "bugprone-copy-constructor-init", "bugprone-dangling-handle", "bugprone-dynamic-static-initializers", "bugprone-fold-init-type", "bugprone-forward-declaration-namespace", "bugprone-forwarding-reference-overload", "bugprone-inaccurate-erase", "bugprone-incorrect-roundings", "bugprone-integer-division", "bugprone-lambda-function-name", "bugprone-macro-parentheses", "bugprone-macro-repeated-side-effects", "bugprone-misplaced-operator-in-strlen-in-alloc", "bugprone-misplaced-pointer-arithmetic-in-alloc", "bugprone-misplaced-widening-cast", "bugprone-move-forwarding-reference", "bugprone-multiple-statement-macro", "bugprone-no-escape", "bugprone-not-null-terminated-result", "bugprone-parent-virtual-call", "bugprone-posix-return", "bugprone-reserved-identifier", "bugprone-sizeof-container", "bugprone-sizeof-expression", "bugprone-spuriously-wake-up-functions", "bugprone-string-constructor", "bugprone-string-integer-assignment", "bugprone-string-literal-with-embedded-nul", "bugprone-suspicious-enum-usage", "bugprone-suspicious-include", "bugprone-suspicious-memset-usage", "bugprone-suspicious-missing-comma", "bugprone-suspicious-semicolon", "bugprone-suspicious-string-compare", "bugprone-swapped-arguments", "bugprone-terminating-continue", "bugprone-throw-keyword-missing", "bugprone-too-small-loop-variable", "bugprone-undefined-memory-manipulation", "bugprone-undelegated-constructor", "bugprone-unhandled-self-assignment", "bugprone-unused-raii", "bugprone-unused-return-value", "bugprone-use-after-move", "bugprone-virtual-near-miss", "cert-dcl21-cpp", "cert-dcl58-cpp", "cert-err34-c", "cert-err52-cpp", "cert-err58-cpp", "cert-err60-cpp", "cert-flp30-c", "cert-msc50-cpp", "cert-msc51-cpp", "cert-str34-c", "cppcoreguidelines-interfaces-global-init", "cppcoreguidelines-narrowing-conversions", "cppcoreguidelines-pro-type-member-init", "cppcoreguidelines-pro-type-static-cast-downcast", "cppcoreguidelines-slicing", "google-default-arguments", "google-explicit-constructor", "google-runtime-operator", "hicpp-exception-baseclass", "hicpp-multiway-paths-covered", "misc-misplaced-const", "misc-new-delete-overloads", "misc-no-recursion", "misc-non-copyable-objects", "misc-throw-by-value-catch-by-reference", "misc-unconventional-assign-operator", "misc-uniqueptr-reset-release", "modernize-avoid-bind", "modernize-concat-nested-namespaces", "modernize-deprecated-headers", "modernize-deprecated-ios-base-aliases", "modernize-loop-convert", "modernize-make-shared", "modernize-make-unique", "modernize-pass-by-value", "modernize-raw-string-literal", "modernize-redundant-void-arg", "modernize-replace-auto-ptr", "modernize-replace-disallow-copy-and-assign-macro", "modernize-replace-random-shuffle", "modernize-return-braced-init-list", "modernize-shrink-to-fit", "modernize-unary-static-assert", "modernize-use-auto", "modernize-use-bool-literals", "modernize-use-emplace", "modernize-use-equals-default", "modernize-use-equals-delete", "modernize-use-nodiscard", "modernize-use-noexcept", "modernize-use-nullptr", "modernize-use-override", "modernize-use-transparent-functors", "modernize-use-uncaught-exceptions", "mpi-buffer-deref", "mpi-type-mismatch", "openmp-use-default-none", "performance-faster-string-find", "performance-for-range-copy", "performance-implicit-conversion-in-loop", "performance-inefficient-algorithm", "performance-inefficient-string-concatenation", "performance-inefficient-vector-operation", "performance-move-const-arg", "performance-move-constructor-init", "performance-no-automatic-move", "performance-noexcept-move-constructor", "performance-trivially-destructible", "performance-type-promotion-in-math-fn", "performance-unnecessary-copy-initialization", "performance-unnecessary-value-param", "portability-simd-intrinsics", "readability-avoid-const-params-in-decls", "readability-const-return-type", "readability-container-size-empty", "readability-convert-member-functions-to-static", "readability-delete-null-pointer", "readability-deleted-default", "readability-inconsistent-declaration-parameter-name", "readability-make-member-function-const", "readability-misleading-indentation", "readability-misplaced-array-index", "readability-non-const-parameter", "readability-redundant-control-flow", "readability-redundant-declaration", "readability-redundant-function-ptr-dereference", "readability-redundant-smartptr-get", "readability-redundant-string-cstr", "readability-redundant-string-init", "readability-simplify-subscript-expr", "readability-static-accessed-through-instance", "readability-static-definition-in-anonymous-namespace", "readability-string-compare", "readability-uniqueptr-delete-release", "readability-use-anyofallof"});
        enabledChecks.sort(String::compareTo);
        ArrayList<String> configuration = new ArrayList<String>();
        configuration.add("-*");
        configuration.addAll(enabledChecks);
        return ContainerUtil.newUnmodifiableList(configuration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/ClangTidyInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyMessage";
                break;
            }
            case 6: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyCheckName";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyChecks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionShortName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createClangTidyFilesCheckbox";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/ClangTidyInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsButton";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createChecksField";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createChecksExampleLink";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultChecks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeDisabledByClangTidyCheckName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsButton";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setClangTidyChecks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

