/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssApiBaseInspection;
import com.intellij.psi.css.inspections.CssBrowserCompatibilityForPropertiesInspection;
import com.intellij.psi.css.inspections.CssInspectionFilter;
import com.intellij.psi.css.inspections.CssOverwrittenPropertiesInspection;
import com.intellij.psi.css.inspections.CssReplaceWithShorthandSafelyInspection;
import com.intellij.psi.css.inspections.CssReplaceWithShorthandUnsafelyInspection;
import com.intellij.psi.css.inspections.CssUnknownPropertyInspection;
import com.intellij.psi.css.inspections.bugs.CssMissingCommaInspection;
import com.intellij.psi.css.inspections.bugs.CssNoGenericFontNameInspection;
import com.intellij.psi.css.inspections.invalid.CssInvalidAtRuleInspection;
import com.intellij.psi.css.inspections.invalid.CssInvalidCharsetRuleInspection;
import com.intellij.psi.css.inspections.invalid.CssInvalidHtmlTagReferenceInspection;
import com.intellij.psi.css.inspections.invalid.CssInvalidMediaFeatureInspection;
import com.intellij.psi.css.inspections.invalid.CssInvalidPropertyValueInspection;
import com.intellij.psi.css.inspections.invalid.CssInvalidPseudoSelectorInspection;
import com.intellij.psi.css.inspections.invalid.CssUnknownTargetInspection;
import com.intellij.psi.css.inspections.style.CssRedundantUnitInspection;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.psi.impl.LESSOperationImpl;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;

public class LessCssInspectionFilter
extends CssInspectionFilter {
    private static final Set<String> KNOWN_FUNCTIONS = ContainerUtil.newHashSet((Object[])new String[]{"fade", "alpha", "saturate", "contrast"});

    public boolean isSupported(@NotNull Class<? extends CssApiBaseInspection> clazz, @NotNull PsiElement context) {
        if (clazz == null) {
            LessCssInspectionFilter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            LessCssInspectionFilter.$$$reportNull$$$0(1);
        }
        return clazz == CssInvalidAtRuleInspection.class || clazz == CssMissingCommaInspection.class || clazz == CssInvalidCharsetRuleInspection.class || clazz == CssUnknownPropertyInspection.class || clazz == CssInvalidHtmlTagReferenceInspection.class || clazz == CssOverwrittenPropertiesInspection.class || clazz == CssUnknownTargetInspection.class || clazz == CssReplaceWithShorthandSafelyInspection.class || clazz == CssReplaceWithShorthandUnsafelyInspection.class || clazz == CssInvalidMediaFeatureInspection.class || clazz == CssInvalidPropertyValueInspection.class || clazz == CssNoGenericFontNameInspection.class || clazz == CssRedundantUnitInspection.class || clazz == CssInvalidPseudoSelectorInspection.class || clazz == CssBrowserCompatibilityForPropertiesInspection.class;
    }

    public boolean isValueShouldBeValidatedWithCssScheme(@Nullable CssTermList value) {
        Collection functions = PsiTreeUtil.findChildrenOfType((PsiElement)value, CssFunction.class);
        for (CssFunction function : functions) {
            if (!CssDescriptorsUtil.getFunctionDescriptors((String)function.getName(), (PsiElement)value).isEmpty() && !KNOWN_FUNCTIONS.contains(function.getName())) continue;
            return false;
        }
        for (CssString string : PsiTreeUtil.findChildrenOfType((PsiElement)value, CssString.class)) {
            PsiElement child = string.getFirstChild();
            if (child == null || child.getNode().getElementType() != CssElementTypes.CSS_TILDA) continue;
            return false;
        }
        return PsiTreeUtil.findChildOfAnyType((PsiElement)value, (Class[])new Class[]{LESSOperationImpl.class, LESSVariableImpl.class}) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "clazz";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/less/inspections/LessCssInspectionFilter";
        objectArray[2] = "isSupported";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

