/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.bsh;

import java.util.Hashtable;
import org.gradle.internal.impldep.bsh.UtilEvalError;

public class Capabilities {
    private static boolean accessibility = false;
    private static Hashtable classes = new Hashtable();

    public static boolean haveSwing() {
        return Capabilities.classExists("javax.swing.JButton");
    }

    public static boolean canGenerateInterfaces() {
        return Capabilities.classExists("java.lang.reflect.Proxy");
    }

    public static boolean haveAccessibility() {
        return accessibility;
    }

    public static void setAccessibility(boolean b) throws Unavailable {
        if (!b) {
            accessibility = false;
            return;
        }
        if (!Capabilities.classExists("java.lang.reflect.AccessibleObject") || !Capabilities.classExists("org/gradle/internal/impldep/bsh.reflect.ReflectManagerImpl")) {
            throw new Unavailable("Accessibility unavailable");
        }
        try {
            String.class.getDeclaredMethods();
        }
        catch (SecurityException e) {
            throw new Unavailable("Accessibility unavailable: " + e);
        }
        accessibility = true;
    }

    public static boolean classExists(String name) {
        Object c = classes.get(name);
        if (c == null) {
            try {
                c = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c != null) {
                classes.put(c, "unused");
            }
        }
        return c != null;
    }

    public static class Unavailable
    extends UtilEvalError {
        public Unavailable(String s) {
            super(s);
        }
    }
}

