/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.org.junit.platform.commons.util.CollectionUtils;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.CompositeLock;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.NopLock;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.ResourceLock;
import org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.SingleLock;

class LockManager {
    private static final Comparator<ExclusiveResource> COMPARATOR = Comparator.comparing(ExclusiveResource::getKey, LockManager.globalKeyFirst().thenComparing(Comparator.naturalOrder())).thenComparing(ExclusiveResource::getLockMode);
    private final Map<String, ReadWriteLock> locksByKey = new ConcurrentHashMap<String, ReadWriteLock>();

    LockManager() {
    }

    private static Comparator<String> globalKeyFirst() {
        return Comparator.comparing(key -> !"org.gradle.internal.impldep.org.junit.platform.engine.support.hierarchical.ExclusiveResource.GLOBAL_KEY".equals(key));
    }

    ResourceLock getLockForResources(Collection<ExclusiveResource> resources) {
        if (resources.size() == 1) {
            return this.getLockForResource(CollectionUtils.getOnlyElement(resources));
        }
        List<Lock> locks = this.getDistinctSortedLocks(resources);
        return this.toResourceLock(locks);
    }

    ResourceLock getLockForResource(ExclusiveResource resource) {
        return new SingleLock(this.toLock(resource));
    }

    private List<Lock> getDistinctSortedLocks(Collection<ExclusiveResource> resources) {
        Map resourcesByKey = resources.stream().sorted(COMPARATOR).distinct().collect(Collectors.groupingBy(ExclusiveResource::getKey, LinkedHashMap::new, Collectors.toList()));
        return resourcesByKey.values().stream().map(resourcesWithSameKey -> (ExclusiveResource)resourcesWithSameKey.get(0)).map(this::toLock).collect(Collectors.toList());
    }

    private Lock toLock(ExclusiveResource resource) {
        ReadWriteLock lock = this.locksByKey.computeIfAbsent(resource.getKey(), key -> new ReentrantReadWriteLock());
        return resource.getLockMode() == ExclusiveResource.LockMode.READ ? lock.readLock() : lock.writeLock();
    }

    private ResourceLock toResourceLock(List<Lock> locks) {
        switch (locks.size()) {
            case 0: {
                return NopLock.INSTANCE;
            }
            case 1: {
                return new SingleLock(locks.get(0));
            }
        }
        return new CompositeLock(locks);
    }
}

