/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;
import org.jetbrains.jps.model.serialization.JpsPathVariablesConfiguration;
import org.jetbrains.jps.model.serialization.JpsProjectSerializationDataExtension;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.jps.model.serialization.impl.JpsModuleSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.JpsPathVariablesConfigurationImpl;
import org.jetbrains.jps.model.serialization.impl.JpsProjectSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.module.JpsModuleSerializationDataExtension;

public final class JpsModelSerializationDataService {
    public static Map<String, String> computeAllPathVariables(JpsGlobal global) {
        HashMap<String, String> pathVariables = new HashMap<String, String>(PathMacroUtil.getGlobalSystemMacros(false));
        JpsPathVariablesConfiguration configuration = JpsModelSerializationDataService.getPathVariablesConfiguration(global);
        if (configuration != null) {
            pathVariables.putAll(configuration.getAllUserVariables());
        }
        return pathVariables;
    }

    @Nullable
    public static JpsPathVariablesConfiguration getPathVariablesConfiguration(JpsGlobal global) {
        return (JpsPathVariablesConfiguration)global.getContainer().getChild(JpsGlobalLoader.PATH_VARIABLES_ROLE);
    }

    @NotNull
    public static JpsPathVariablesConfiguration getOrCreatePathVariablesConfiguration(JpsGlobal global) {
        JpsPathVariablesConfiguration child = (JpsPathVariablesConfiguration)global.getContainer().getChild(JpsGlobalLoader.PATH_VARIABLES_ROLE);
        if (child == null) {
            JpsPathVariablesConfiguration jpsPathVariablesConfiguration = (JpsPathVariablesConfiguration)global.getContainer().setChild(JpsGlobalLoader.PATH_VARIABLES_ROLE, (JpsElement)new JpsPathVariablesConfigurationImpl());
            if (jpsPathVariablesConfiguration == null) {
                JpsModelSerializationDataService.$$$reportNull$$$0(0);
            }
            return jpsPathVariablesConfiguration;
        }
        JpsPathVariablesConfiguration jpsPathVariablesConfiguration = child;
        if (jpsPathVariablesConfiguration == null) {
            JpsModelSerializationDataService.$$$reportNull$$$0(1);
        }
        return jpsPathVariablesConfiguration;
    }

    @Nullable
    public static JpsProjectSerializationDataExtension getProjectExtension(@NotNull JpsProject project) {
        if (project == null) {
            JpsModelSerializationDataService.$$$reportNull$$$0(2);
        }
        return (JpsProjectSerializationDataExtension)project.getContainer().getChild(JpsProjectSerializationDataExtensionImpl.ROLE);
    }

    @Nullable
    public static File getBaseDirectory(@NotNull JpsProject project) {
        JpsProjectSerializationDataExtension extension;
        if (project == null) {
            JpsModelSerializationDataService.$$$reportNull$$$0(3);
        }
        return (extension = JpsModelSerializationDataService.getProjectExtension(project)) != null ? extension.getBaseDirectory() : null;
    }

    @Nullable
    public static JpsModuleSerializationDataExtension getModuleExtension(@NotNull JpsModule project) {
        if (project == null) {
            JpsModelSerializationDataService.$$$reportNull$$$0(4);
        }
        return (JpsModuleSerializationDataExtension)project.getContainer().getChild(JpsModuleSerializationDataExtensionImpl.ROLE);
    }

    @Nullable
    public static File getBaseDirectory(@NotNull JpsModule module) {
        JpsModuleSerializationDataExtension extension;
        if (module == null) {
            JpsModelSerializationDataService.$$$reportNull$$$0(5);
        }
        return (extension = JpsModelSerializationDataService.getModuleExtension(module)) != null ? extension.getBaseDirectory() : null;
    }

    @Nullable
    public static String getPathVariableValue(@NotNull JpsGlobal global, @NotNull String name) {
        String value;
        if (global == null) {
            JpsModelSerializationDataService.$$$reportNull$$$0(6);
        }
        if (name == null) {
            JpsModelSerializationDataService.$$$reportNull$$$0(7);
        }
        if ((value = PathMacroUtil.getGlobalSystemMacroValue(name, false)) != null) {
            return value;
        }
        JpsPathVariablesConfiguration configuration = JpsModelSerializationDataService.getPathVariablesConfiguration(global);
        return configuration != null ? configuration.getUserVariableValue(name) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JpsModelSerializationDataService";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "global";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreatePathVariablesConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsModelSerializationDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectExtension";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExtension";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPathVariableValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

