/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.BritishEnglish;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class BritishReplaceRule
extends AbstractSimpleReplaceRule2 {
    public static final String BRITISH_SIMPLE_REPLACE_RULE = "EN_GB_SIMPLE_REPLACE";
    private static final Locale EN_GB_LOCALE = new Locale("en-GB");
    private final String PATH;

    public List<String> getFileNames() {
        return Collections.singletonList(this.PATH);
    }

    public BritishReplaceRule(ResourceBundle messages, String path) {
        super(messages, (Language)new BritishEnglish());
        this.PATH = Objects.requireNonNull(path);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong((String)"We can produce <marker>drapes</marker> of any size or shape from a choice of over 500 different fabrics."), Example.fixed((String)"We can produce <marker>curtains</marker> of any size or shape from a choice of over 500 different fabrics."));
    }

    public String getId() {
        return BRITISH_SIMPLE_REPLACE_RULE;
    }

    public String getDescription() {
        return "American words easily confused in British English";
    }

    public String getShort() {
        return "American word";
    }

    public String getMessage() {
        return "'$match' is a common American expression. Consider using expressions more common to British English.";
    }

    public Locale getLocale() {
        return EN_GB_LOCALE;
    }
}

