/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.google.common.base.MoreObjects;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessOptions;
import com.pty4j.WinSize;
import com.pty4j.unix.Pty;
import com.pty4j.unix.PtyHelpers;
import com.pty4j.unix.UnixPtyException;
import com.pty4j.util.PtyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnixPtyProcess
extends PtyProcess {
    private static final int NOOP = 0;
    private static final int SIGHUP = 1;
    private static final int SIGKILL = 9;
    private static final int SIGTERM = 15;
    private static final int ENOTTY = 25;
    private int pid = 0;
    private int myExitCode;
    private boolean isDone;
    private OutputStream out;
    private InputStream in;
    private InputStream err;
    private final Pty myPty;
    private final Pty myErrPty;

    @Deprecated
    public UnixPtyProcess(String[] cmdarray, String[] envp, String dir, Pty pty, Pty errPty) throws IOException {
        if (dir == null) {
            dir = ".";
        }
        if (pty == null) {
            throw new IOException("pty cannot be null");
        }
        this.myPty = pty;
        this.myErrPty = errPty;
        this.execInPty(cmdarray, envp, dir, pty, errPty, null, null);
    }

    public UnixPtyProcess(@NotNull PtyProcessOptions options, boolean consoleMode) throws IOException {
        this.myPty = new Pty(consoleMode, options.isUnixOpenTtyToPreserveOutputAfterTermination());
        this.myErrPty = options.isRedirectErrorStream() ? null : (consoleMode ? new Pty() : null);
        String dir = (String)MoreObjects.firstNonNull((Object)options.getDirectory(), (Object)".");
        this.execInPty(options.getCommand(), PtyUtil.toStringArray(options.getEnvironment()), dir, this.myPty, this.myErrPty, options.getInitialColumns(), options.getInitialRows());
    }

    public Pty getPty() {
        return this.myPty;
    }

    protected void finalize() throws Throwable {
        this.closeUnusedStreams();
        super.finalize();
    }

    @Override
    public synchronized InputStream getInputStream() {
        if (null == this.in) {
            this.in = this.myPty.getInputStream();
        }
        return this.in;
    }

    @Override
    public synchronized OutputStream getOutputStream() {
        if (null == this.out) {
            this.out = this.myPty.getOutputStream();
        }
        return this.out;
    }

    @Override
    public synchronized InputStream getErrorStream() {
        if (null == this.err) {
            this.err = this.myErrPty == null || !this.myPty.isConsole() ? new InputStream(){

                @Override
                public int read() {
                    return -1;
                }
            } : this.myErrPty.getInputStream();
        }
        return this.err;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        while (!this.isDone) {
            this.wait();
        }
        return this.myExitCode;
    }

    @Override
    public synchronized int exitValue() {
        if (!this.isDone) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.myExitCode;
    }

    @Override
    public synchronized void destroy() {
        Pty.raise(this.pid, 15);
        this.closeUnusedStreams();
    }

    @Override
    public synchronized Process destroyForcibly() {
        Pty.raise(this.pid, 9);
        this.closeUnusedStreams();
        return this;
    }

    @Override
    public boolean isRunning() {
        return Pty.raise(this.pid, 0) == 0;
    }

    public int hangup() {
        return Pty.raise(this.pid, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execInPty(String[] command, String[] environment, String workingDirectory, Pty pty, Pty errPty, @Nullable Integer initialColumns, @Nullable Integer initialRows) throws IOException {
        String cmd = command[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(cmd);
        }
        if (environment == null) {
            environment = new String[]{};
        }
        String slaveName = pty.getSlaveName();
        int masterFD = pty.getMasterFD();
        String errSlaveName = errPty == null ? null : errPty.getSlaveName();
        int errMasterFD = errPty == null ? -1 : errPty.getMasterFD();
        boolean console = pty.isConsole();
        Reaper reaper = new Reaper(command, environment, workingDirectory, slaveName, masterFD, errSlaveName, errMasterFD, console);
        reaper.setDaemon(true);
        reaper.start();
        UnixPtyProcess unixPtyProcess = this;
        synchronized (unixPtyProcess) {
            boolean init;
            while (this.pid == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            boolean bl = init = Boolean.getBoolean("unix.pty.init") || initialColumns != null || initialRows != null;
            if (init) {
                int cols = initialColumns != null ? initialColumns : Integer.getInteger("unix.pty.cols", 80);
                int rows = initialRows != null ? initialRows : Integer.getInteger("unix.pty.rows", 25);
                WinSize size = new WinSize(cols, rows);
                for (int attempt = 0; attempt < 1000; ++attempt) {
                    try {
                        this.myPty.setWindowSize(size, this);
                        break;
                    }
                    catch (UnixPtyException e) {
                        if (e.getErrno() != 25) break;
                        continue;
                    }
                }
            }
        }
        if (this.pid == -1) {
            throw new IOException("Exec_tty error:" + reaper.getErrorMessage(), reaper.getException());
        }
    }

    private synchronized void closeUnusedStreams() {
        try {
            if (null == this.err) {
                this.getErrorStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (null == this.in) {
                this.getInputStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (null == this.out) {
                this.getOutputStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    int exec(String[] cmd, String[] envp, String dirname, String slaveName, int masterFD, String errSlaveName, int errMasterFD, boolean console) throws IOException {
        int pid = -1;
        if (cmd == null) {
            return pid;
        }
        if (envp == null) {
            return pid;
        }
        return PtyHelpers.execPty(cmd[0], cmd, envp, dirname, slaveName, masterFD, errSlaveName, errMasterFD, console);
    }

    @Override
    public void setWinSize(WinSize winSize) {
        try {
            this.myPty.setWindowSize(winSize, this);
        }
        catch (UnixPtyException e) {
            throw new IllegalStateException(e);
        }
        if (this.myErrPty != null) {
            try {
                this.myErrPty.setWindowSize(winSize, this);
            }
            catch (UnixPtyException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    @NotNull
    public WinSize getWinSize() throws IOException {
        return this.myPty.getWinSize(this);
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    class Reaper
    extends Thread {
        private String[] myCommand;
        private String[] myEnv;
        private String myDir;
        private String mySlaveName;
        private int myMasterFD;
        private String myErrSlaveName;
        private int myErrMasterFD;
        private boolean myConsole;
        volatile Throwable myException;

        public Reaper(String[] command, String[] environment, String workingDirectory, String slaveName, int masterFD, String errSlaveName, int errMasterFD, boolean console) {
            super("PtyProcess Reaper for " + Arrays.toString(command));
            this.myCommand = command;
            this.myEnv = environment;
            this.myDir = workingDirectory;
            this.mySlaveName = slaveName;
            this.myMasterFD = masterFD;
            this.myErrSlaveName = errSlaveName;
            this.myErrMasterFD = errMasterFD;
            this.myConsole = console;
            this.myException = null;
        }

        int execute(String[] cmd, String[] env, String dir) throws IOException {
            return UnixPtyProcess.this.exec(cmd, env, dir, this.mySlaveName, this.myMasterFD, this.myErrSlaveName, this.myErrMasterFD, this.myConsole);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                UnixPtyProcess.this.pid = this.execute(this.myCommand, this.myEnv, this.myDir);
            }
            catch (Exception e) {
                UnixPtyProcess.this.pid = -1;
                this.myException = e;
            }
            UnixPtyProcess unixPtyProcess = UnixPtyProcess.this;
            synchronized (unixPtyProcess) {
                UnixPtyProcess.this.notifyAll();
            }
            if (UnixPtyProcess.this.pid != -1) {
                UnixPtyProcess.this.myExitCode = PtyHelpers.getPtyExecutor().waitForProcessExitAndGetExitCode(UnixPtyProcess.this.pid);
                unixPtyProcess = UnixPtyProcess.this;
                synchronized (unixPtyProcess) {
                    UnixPtyProcess.this.isDone = true;
                    UnixPtyProcess.this.notifyAll();
                }
                UnixPtyProcess.this.myPty.breakRead();
                if (UnixPtyProcess.this.myErrPty != null) {
                    UnixPtyProcess.this.myErrPty.breakRead();
                }
            }
        }

        public String getErrorMessage() {
            return this.myException != null ? this.myException.getMessage() : "Unknown reason";
        }

        @Nullable
        public Throwable getException() {
            return this.myException;
        }
    }
}

