/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.util.ProcessingContext;
import com.intellij.vcsUtil.ActionWithTempFile;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.ClientVersion;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.ServerVersion;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.operations.P4AddOperation;
import org.jetbrains.idea.perforce.operations.P4EditOperation;
import org.jetbrains.idea.perforce.operations.RefreshForVcs;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.P4WhereResult;
import org.jetbrains.idea.perforce.perforce.PerforceCachingContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.ResolvedFile;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class P4MoveRenameOperation
extends VcsOperation {
    private static final Logger LOG = Logger.getInstance(P4MoveRenameOperation.class);
    private static final int CYCLE = 3;
    private static final int DOUBLE_RENAME = 2;
    private static final int SIMPLE = 1;
    public String oldPath;
    public String newPath;

    public P4MoveRenameOperation() {
    }

    public P4MoveRenameOperation(String changeList, String oldPath, String newPath) {
        super(changeList);
        this.oldPath = oldPath;
        this.newPath = newPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug("P4MoveRenameOperation.P4MoveRenameOperation " + Thread.currentThread());
            LOG.debug("changeList = [" + changeList + "], oldPath = [" + oldPath + "], newPath = [" + newPath + "]");
        }
    }

    @Override
    public void execute(Project project, ProcessingContext context) throws VcsException {
        PerforceRunner runner = PerforceRunner.getInstance(project);
        if (this.useMove(project, runner, context)) {
            return;
        }
        this.useIntegrate(project, this.oldPath, this.newPath, runner, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean useMove(Project project, PerforceRunner runner, ProcessingContext context) throws VcsException {
        P4Connection newConnection;
        P4File oldP4File = P4File.createInefficientFromLocalPath(this.oldPath);
        P4File newP4File = P4File.createInefficientFromLocalPath(this.newPath);
        P4Connection oldConnection = PerforceConnectionManager.getInstance(project).getConnectionForFile(oldP4File);
        if (!P4MoveRenameOperation.isCompatibleConnection(oldConnection, newConnection = PerforceConnectionManager.getInstance(project).getConnectionForFile(newP4File)) || runner.getClient(newConnection) == null) {
            return false;
        }
        FStat oldFStat = oldP4File.getFstat(project, false);
        if (oldFStat.status == FStat.STATUS_NOT_ADDED) {
            return false;
        }
        ClientVersion clientVersion = PerforceManager.getInstance(project).getClientVersion();
        ServerVersion serverVersion = PerforceManager.getInstance(project).getServerVersion(newConnection);
        if (clientVersion != null && clientVersion.supportsMove() && serverVersion != null && serverVersion.supportsMove()) {
            try {
                long changeList = this.getPerforceChangeList(project, oldP4File, context);
                if (!oldFStat.isOpenedOrAdded()) {
                    runner.edit(oldP4File, changeList, true);
                }
                runner.move(oldP4File, newP4File, oldConnection, true, changeList);
                File oldFile = oldP4File.getLocalFile();
                if (oldFile.exists() && !P4MoveRenameOperation.isCaseChange(oldP4File, newP4File) && !oldFile.delete()) {
                    throw new VcsException(PerforceBundle.message("exception.text.cannot.delete.local.file", oldFile));
                }
                boolean bl = true;
                return bl;
            }
            finally {
                P4MoveRenameOperation.clearCachesAfterMove(project, oldP4File, newP4File, new RefreshForVcs());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void useIntegrate(Project project, String oldPath, String newPath, PerforceRunner runner, ProcessingContext context) throws VcsException {
        P4File oldP4File = P4File.createInefficientFromLocalPath(oldPath);
        P4File newP4File = P4File.createInefficientFromLocalPath(newPath);
        P4Connection oldConnection = PerforceConnectionManager.getInstance(project).getConnectionForFile(oldP4File);
        P4Connection newConnection = PerforceConnectionManager.getInstance(project).getConnectionForFile(newP4File);
        if (runner.getClient(newConnection) == null || oldConnection == null || newConnection == null) {
            return;
        }
        RefreshForVcs refreshWorker = new RefreshForVcs();
        try {
            boolean moveWasUsed;
            FStat oldfstat = oldP4File.getFstat(project, false);
            if (oldfstat.status == FStat.STATUS_NOT_ADDED) {
                return;
            }
            boolean bl = moveWasUsed = oldfstat.local == FStat.LOCAL_MOVE_ADDING;
            if (moveWasUsed) {
                if (oldfstat.movedFile == null) {
                    throw new VcsException(PerforceBundle.message("error.can.not.find.moved.deleted.file", oldPath));
                }
                long changeList = this.getPerforceChangeList(project, oldP4File, context);
                runner.revert(oldP4File, true);
                refreshWorker.addDeletedFile(new File(oldPath));
                oldP4File.clearCache();
                oldP4File.invalidateFstat();
                P4WhereResult p4WhereResult = runner.where(oldfstat.movedFile, oldConnection);
                oldPath = p4WhereResult.getLocal();
                oldP4File = P4File.createInefficientFromLocalPath(oldPath);
                runner.edit(oldP4File, changeList);
                oldfstat = oldP4File.getFstat(project, false);
                if (new File(oldPath).equals(new File(newPath))) {
                    return;
                }
            }
            this.moveUsingBranchCommand(project, oldP4File, newP4File, oldConnection, newConnection, runner, oldfstat, context);
        }
        finally {
            P4MoveRenameOperation.clearCachesAfterMove(project, oldP4File, newP4File, refreshWorker);
        }
    }

    private static void clearCachesAfterMove(Project project, P4File oldP4File, P4File newP4File, RefreshForVcs refreshWorker) {
        oldP4File.clearCache();
        newP4File.clearCache();
        refreshWorker.addDeletedFile(oldP4File.getLocalFile());
        refreshWorker.refreshFile(newP4File.getLocalFile());
        refreshWorker.run(project);
    }

    private void moveUsingBranchCommand(Project project, P4File oldP4File, P4File newP4File, P4Connection oldConnection, P4Connection newConnection, PerforceRunner runner, FStat oldfstat, ProcessingContext context) throws VcsException {
        if (oldfstat.local == FStat.LOCAL_DELETING || oldfstat.local == FStat.LOCAL_MOVE_DELETING) {
            return;
        }
        boolean fileWasLocallyAdded = oldfstat.local == FStat.LOCAL_ADDING;
        boolean processedDoubleRename = false;
        if (fileWasLocallyAdded) {
            List<ResolvedFile> resolvedFiles = runner.getResolvedFiles(oldConnection, Collections.emptyList());
            for (ResolvedFile resolvedFile : resolvedFiles) {
                String resolvedFilePath = FileUtil.toSystemIndependentName((String)resolvedFile.getLocalFile().toString());
                if (!resolvedFilePath.equals(this.oldPath)) continue;
                PerforceClient perforceClient = PerforceManager.getInstance(project).getClient(oldConnection);
                File realOldFile = PerforceManager.getFileByDepotName(resolvedFile.getDepotPath(), perforceClient);
                assert (realOldFile != null);
                P4File realOldP4File = P4File.create(realOldFile);
                FStat realOldFStat = realOldP4File.getFstat(project, true);
                if (realOldFStat.local != FStat.LOCAL_DELETING) break;
                if (new File(this.newPath).equals(realOldFile)) {
                    P4MoveRenameOperation.processCycle(project, newP4File, oldP4File);
                } else {
                    P4MoveRenameOperation.processDoubleRename(project, realOldP4File, newP4File, oldP4File);
                }
                processedDoubleRename = true;
                break;
            }
        }
        if (!processedDoubleRename) {
            boolean fileWasUnderPerforce;
            boolean bl = fileWasUnderPerforce = oldfstat.status != FStat.STATUS_NOT_ADDED;
            if (fileWasLocallyAdded || !fileWasUnderPerforce || !P4MoveRenameOperation.isCompatibleConnection(oldConnection, newConnection)) {
                if (fileWasLocallyAdded) {
                    P4MoveRenameOperation.assureNoFile(project, oldP4File, true);
                } else {
                    runner.assureDel(oldP4File, null);
                }
                P4MoveRenameOperation.createNewFile(project, newP4File);
            } else {
                int type = P4MoveRenameOperation.detectType(oldfstat, oldP4File, this.newPath);
                switch (type) {
                    case 3: {
                        P4MoveRenameOperation.processCycle(project, newP4File, oldP4File);
                        break;
                    }
                    case 2: {
                        P4MoveRenameOperation.processDoubleRename(project, oldfstat.fromFile, newP4File, oldP4File);
                        break;
                    }
                    case 1: {
                        this.processRename(project, newP4File, oldP4File, context);
                    }
                }
            }
        }
    }

    private static int detectType(FStat oldfstat, P4File oldP4File, String newPath) {
        boolean doubleRename = false;
        P4File realOldP4File = null;
        if (oldfstat.local == FStat.LOCAL_BRANCHING) {
            realOldP4File = oldfstat.fromFile;
            doubleRename = true;
        }
        if (realOldP4File == null) {
            realOldP4File = oldP4File;
            doubleRename = false;
        }
        if (doubleRename) {
            if (FileUtil.filesEqual((File)new File(newPath), (File)realOldP4File.getLocalFile())) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    private static void createNewFile(Project project, final P4File p4File) throws VcsException {
        final PerforceRunner runner = PerforceRunner.getInstance(project);
        FStat fstat = p4File.getFstat(project, false);
        if (fstat.status == FStat.STATUS_NOT_IN_CLIENTSPEC) {
            throw new VcsException(PerforceBundle.message("exception.text.cannot.add.file.not.under.any.spec", p4File));
        }
        if (fstat.status == FStat.STATUS_NOT_ADDED || fstat.status == FStat.STATUS_DELETED) {
            runner.add(p4File);
        } else if (fstat.status != FStat.STATUS_ONLY_LOCAL) {
            if (fstat.local == FStat.LOCAL_DELETING) {
                new ActionWithTempFile(p4File.getLocalFile()){

                    protected void executeInternal() throws VcsException {
                        runner.revert(p4File, false);
                        runner.edit(p4File);
                    }
                }.execute();
            } else if (fstat.local == FStat.LOCAL_CHECKED_IN) {
                new ActionWithTempFile(p4File.getLocalFile()){

                    protected void executeInternal() throws VcsException {
                        runner.sync(p4File, false);
                        runner.edit(p4File);
                    }
                }.execute();
            }
        }
    }

    private void processRename(final Project project, final P4File newP4File, final P4File oldP4File, ProcessingContext context) throws VcsException {
        final PerforceRunner runner = PerforceRunner.getInstance(project);
        final long changeList = this.getPerforceChangeList(project, newP4File, context);
        new ActionWithTempFile(newP4File.getLocalFile()){

            protected void executeInternal() throws VcsException {
                P4MoveRenameOperation.assureNoFile(project, newP4File, false);
                runner.integrate(oldP4File, newP4File, changeList);
                runner.edit(newP4File, changeList);
                if (!P4MoveRenameOperation.isCaseChange(oldP4File, newP4File)) {
                    runner.assureDel(oldP4File, changeList);
                }
            }
        }.execute();
    }

    private static boolean isCaseChange(P4File oldP4File, P4File newP4File) {
        return Comparing.equal((String)oldP4File.getLocalPath(), (String)newP4File.getLocalPath(), (boolean)oldP4File.isCaseSensitive());
    }

    private static void processDoubleRename(final Project project, final P4File realOldP4File, final P4File newP4File, final P4File oldP4File) throws VcsException {
        final PerforceRunner runner = PerforceRunner.getInstance(project);
        FStat realOldfstat = realOldP4File.getFstat(project, false);
        if (realOldfstat.status == FStat.STATUS_DELETED) {
            throw new VcsException(PerforceBundle.message("exception.text.cannot.move.original.deleted", new Object[0]));
        }
        new ActionWithTempFile(newP4File.getLocalFile()){

            protected void executeInternal() throws VcsException {
                P4MoveRenameOperation.assureNoFile(project, newP4File, false);
                runner.revert(oldP4File, true);
                runner.revert(realOldP4File, true);
                runner.integrate(realOldP4File, newP4File);
                runner.edit(newP4File);
            }
        }.execute();
        runner.assureDel(oldP4File, null);
        runner.assureDel(realOldP4File, null);
    }

    private static void processCycle(Project project, final P4File newP4File, P4File oldP4File) throws VcsException {
        final PerforceRunner runner = PerforceRunner.getInstance(project);
        FStat newfstat = newP4File.getFstat(project, true);
        if (newfstat.local == FStat.LOCAL_DELETING) {
            new ActionWithTempFile(newP4File.getLocalFile()){

                protected void executeInternal() throws VcsException {
                    runner.revert(newP4File, false);
                    runner.edit(newP4File);
                }
            }.execute();
        } else if (newfstat.status == FStat.STATUS_NOT_ADDED || newfstat.status == FStat.STATUS_ONLY_LOCAL) {
            P4MoveRenameOperation.createNewFile(project, newP4File);
        } else {
            throw new VcsException(PerforceBundle.message("exception.text.cannot.rename", new Object[0]));
        }
        runner.assureDel(oldP4File, null);
    }

    private static void assureNoFile(Project project, P4File p4File, boolean canBeEdit) throws VcsException {
        PerforceRunner runner = PerforceRunner.getInstance(project);
        FStat fstat = p4File.getFstat(project, false);
        if (fstat.status != FStat.STATUS_NOT_ADDED && fstat.status != FStat.STATUS_NOT_IN_CLIENTSPEC && fstat.status != FStat.STATUS_DELETED) {
            if (fstat.status == FStat.STATUS_ONLY_LOCAL) {
                runner.revert(p4File, false);
            } else if (canBeEdit) {
                runner.revert(p4File, true);
                runner.edit(p4File);
            } else {
                throw new VcsException(PerforceBundle.message("exception.text.cannot.assure.no.file.being.on.server", p4File.getLocalPath()));
            }
        }
    }

    @Override
    public Change getChange(Project project, ChangeListManagerGate addGate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getChange");
            LOG.debug("oldPath = " + this.oldPath);
            LOG.debug("newPath = " + this.newPath);
        }
        VcsContextFactory factory = VcsContextFactory.SERVICE.getInstance();
        FilePath beforePath = factory.createFilePathOn(new File(this.oldPath), false);
        FilePath afterPath = factory.createFilePathOn(new File(this.newPath), false);
        ContentRevision beforeRevision = PerforceCachingContentRevision.createOffline(project, beforePath, afterPath);
        ContentRevision afterRevision = CurrentContentRevision.create((FilePath)afterPath);
        return new Change(beforeRevision, afterRevision);
    }

    @Override
    @NotNull
    String getInputPath() {
        String string = this.oldPath;
        if (string == null) {
            P4MoveRenameOperation.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    String getOutputPath() {
        String string = this.newPath;
        if (string == null) {
            P4MoveRenameOperation.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public VcsOperation checkMerge(VcsOperation oldOp) {
        String oldPath;
        if (oldOp instanceof P4AddOperation) {
            String oldPath2 = ((P4AddOperation)oldOp).getPath();
            if (FileUtil.pathsEqual((String)oldPath2, (String)this.oldPath)) {
                return new P4AddOperation(this.myChangeList, this.newPath);
            }
        } else if (oldOp instanceof P4MoveRenameOperation) {
            P4MoveRenameOperation moveOp = (P4MoveRenameOperation)oldOp;
            if (FileUtil.pathsEqual((String)moveOp.newPath, (String)this.oldPath)) {
                if (FileUtil.pathsEqual((String)moveOp.oldPath, (String)this.newPath)) {
                    return new P4EditOperation(this.myChangeList, this.newPath);
                }
                return new P4MoveRenameOperation(this.myChangeList, moveOp.oldPath, this.newPath);
            }
        } else if (oldOp instanceof P4EditOperation && FileUtil.pathsEqual((String)(oldPath = ((P4EditOperation)oldOp).getPath()), (String)this.oldPath)) {
            return this;
        }
        return super.checkMerge(oldOp);
    }

    static boolean isCompatibleConnection(P4Connection oldConnection, P4Connection newConnection) throws VcsException {
        return oldConnection != null && newConnection != null && oldConnection.getConnectionKey().equals(newConnection.getConnectionKey());
    }

    @Override
    public List<String> getAffectedPaths() {
        return Arrays.asList(this.oldPath, this.newPath);
    }

    public String toString() {
        return "P4MoveRenameOperation{oldPath='" + this.oldPath + "', newPath='" + this.newPath + "'}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/perforce/operations/P4MoveRenameOperation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputPath";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

