/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ModuleVersionSelectorStrictSpec;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Strings;

public class DefaultDependencyConstraint
implements DependencyConstraintInternal {
    private static final Logger LOG = Logging.getLogger(DefaultDependencyConstraint.class);
    private final ModuleIdentifier moduleIdentifier;
    private final MutableVersionConstraint versionConstraint;
    private String reason;
    private ImmutableAttributesFactory attributesFactory;
    private AttributeContainerInternal attributes;
    private boolean force;

    public DefaultDependencyConstraint(String group, String name, String version) {
        this.moduleIdentifier = DefaultModuleIdentifier.newId(group, name);
        this.versionConstraint = new DefaultMutableVersionConstraint(version);
    }

    public static DefaultDependencyConstraint strictly(String group, String name, String strictVersion) {
        DefaultMutableVersionConstraint versionConstraint = new DefaultMutableVersionConstraint((String)null);
        versionConstraint.strictly(strictVersion);
        return new DefaultDependencyConstraint(DefaultModuleIdentifier.newId(group, name), versionConstraint);
    }

    public DefaultDependencyConstraint(ModuleIdentifier module, VersionConstraint versionConstraint) {
        this(module, new DefaultMutableVersionConstraint(versionConstraint));
    }

    private DefaultDependencyConstraint(ModuleIdentifier module, MutableVersionConstraint versionConstraint) {
        this.moduleIdentifier = module;
        this.versionConstraint = versionConstraint;
    }

    @Override
    @Nullable
    public String getGroup() {
        return this.moduleIdentifier.getGroup();
    }

    @Override
    public String getName() {
        return this.moduleIdentifier.getName();
    }

    @Override
    public String getVersion() {
        return Strings.emptyToNull((String)this.versionConstraint.getRequiredVersion());
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.attributes == null ? ImmutableAttributes.EMPTY : this.attributes.asImmutable();
    }

    @Override
    public DependencyConstraint attributes(Action<? super AttributeContainer> configureAction) {
        if (this.attributesFactory == null) {
            this.warnAboutInternalApiUse();
            return this;
        }
        if (this.attributes == null) {
            this.attributes = this.attributesFactory.mutable();
        }
        configureAction.execute(this.attributes);
        return this;
    }

    private void warnAboutInternalApiUse() {
        LOG.warn("Cannot set attributes for constraint \"" + this.getGroup() + ":" + this.getName() + ":" + this.getVersion() + "\": it was probably created by a plugin using internal APIs");
    }

    public void setAttributesFactory(ImmutableAttributesFactory attributesFactory) {
        this.attributesFactory = attributesFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDependencyConstraint that = (DefaultDependencyConstraint)o;
        return Objects.equal((Object)this.moduleIdentifier, (Object)that.moduleIdentifier) && Objects.equal((Object)this.versionConstraint, (Object)that.versionConstraint) && Objects.equal((Object)this.attributes, (Object)that.attributes) && this.force == that.force;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.moduleIdentifier, this.versionConstraint, this.attributes});
    }

    @Override
    public void version(Action<? super MutableVersionConstraint> configureAction) {
        configureAction.execute(this.versionConstraint);
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return new ModuleVersionSelectorStrictSpec(this).isSatisfiedBy(identifier);
    }

    @Override
    public ModuleIdentifier getModule() {
        return this.moduleIdentifier;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void because(String reason) {
        this.reason = reason;
    }

    public DependencyConstraint copy() {
        DefaultDependencyConstraint constraint = new DefaultDependencyConstraint(this.moduleIdentifier, this.versionConstraint);
        constraint.reason = this.reason;
        constraint.attributes = this.attributes;
        constraint.attributesFactory = this.attributesFactory;
        constraint.force = this.force;
        return constraint;
    }

    public String toString() {
        return "constraint " + this.moduleIdentifier + ":" + this.versionConstraint + ", attributes=" + this.attributes;
    }

    @Override
    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }
}

