/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.catalog.BundleModel;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DependencyModel;
import org.gradle.api.internal.catalog.VersionModel;
import org.gradle.api.internal.catalog.parser.DependenciesModelHelper;
import org.gradle.api.internal.catalog.parser.StrictVersionParser;
import org.gradle.api.internal.catalog.parser.TomlCatalogFileParser;
import org.gradle.api.internal.catalog.problems.DefaultCatalogProblemBuilder;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblem;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblemBuilder;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblemId;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.management.VersionCatalogBuilderInternal;
import org.gradle.problems.internal.RenderingUtils;

public class DefaultVersionCatalogBuilder
implements VersionCatalogBuilderInternal {
    private static final Logger LOGGER = Logging.getLogger(DefaultVersionCatalogBuilder.class);
    private static final List<String> FORBIDDEN_ALIAS_SUFFIX = ImmutableList.of((Object)"bundles", (Object)"versions", (Object)"version", (Object)"bundle");
    private static final Set<String> RESERVED_ALIAS_NAMES = ImmutableSet.of((Object)"extensions", (Object)"class", (Object)"convention");
    private final Interner<String> strings;
    private final Interner<ImmutableVersionConstraint> versionConstraintInterner;
    private final ObjectFactory objects;
    private final ProviderFactory providers;
    private final String name;
    private final Map<String, VersionModel> versionConstraints = Maps.newLinkedHashMap();
    private final Map<String, Supplier<DependencyModel>> dependencies = Maps.newLinkedHashMap();
    private final Map<String, BundleModel> bundles = Maps.newLinkedHashMap();
    private final Lazy<DefaultVersionCatalog> model = Lazy.unsafe().of(this::doBuild);
    private final Supplier<DependencyResolutionServices> dependencyResolutionServicesSupplier;
    private final List<Import> imports = Lists.newArrayList();
    private final StrictVersionParser strictVersionParser;
    private final Property<String> description;
    private String currentContext;

    @Inject
    public DefaultVersionCatalogBuilder(String name, Interner<String> strings, Interner<ImmutableVersionConstraint> versionConstraintInterner, ObjectFactory objects, ProviderFactory providers, Supplier<DependencyResolutionServices> dependencyResolutionServicesSupplier) {
        this.name = name;
        this.strings = strings;
        this.versionConstraintInterner = versionConstraintInterner;
        this.objects = objects;
        this.providers = providers;
        this.dependencyResolutionServicesSupplier = dependencyResolutionServicesSupplier;
        this.strictVersionParser = new StrictVersionParser(strings);
        this.description = objects.property(String.class).convention("A catalog of dependencies accessible via the `" + name + "` extension.");
    }

    @Override
    public String getLibrariesExtensionName() {
        return this.name;
    }

    @Override
    public Property<String> getDescription() {
        return this.description;
    }

    @Override
    public DefaultVersionCatalog build() {
        return this.model.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withContext(String context, Runnable action) {
        String oldContext = this.currentContext;
        this.currentContext = this.intern(context);
        try {
            action.run();
        }
        finally {
            this.currentContext = oldContext;
        }
    }

    private DefaultVersionCatalog doBuild() {
        this.maybeImportCatalogs();
        for (Map.Entry<String, BundleModel> entry : this.bundles.entrySet()) {
            String bundleName = entry.getKey();
            List<String> aliases = entry.getValue().getComponents();
            for (String alias : aliases) {
                if (this.dependencies.containsKey(alias)) continue;
                return (DefaultVersionCatalog)this.throwVersionCatalogProblem(VersionCatalogProblemId.UNDEFINED_ALIAS_REFERENCE, spec -> spec.withShortDescription(() -> "A bundle with name '" + bundleName + "' declares a dependency on '" + alias + "' which doesn't exist").happensBecause("Bundles can only contain references to existing library aliases").addSolution(() -> "Make sure that the library alias '" + alias + "' is declared").addSolution(() -> "Remove '" + alias + "' from bundle '" + bundleName + "'").documented());
            }
        }
        ImmutableMap.Builder realizedDeps = ImmutableMap.builderWithExpectedSize((int)this.dependencies.size());
        for (Map.Entry<String, Supplier<DependencyModel>> entry : this.dependencies.entrySet()) {
            realizedDeps.put((Object)entry.getKey(), (Object)entry.getValue().get());
        }
        return new DefaultVersionCatalog(this.name, this.description.getOrElse(""), (Map<String, DependencyModel>)realizedDeps.build(), (Map<String, BundleModel>)ImmutableMap.copyOf(this.bundles), (Map<String, VersionModel>)ImmutableMap.copyOf(this.versionConstraints));
    }

    private void maybeImportCatalogs() {
        if (this.imports.isEmpty()) {
            return;
        }
        DependencyResolutionServices drs = this.dependencyResolutionServicesSupplier.get();
        int importsSize = this.imports.size();
        for (int i = 0; i < importsSize; ++i) {
            Import importConfiguration = this.imports.get(i);
            Configuration cnf = this.createResolvableConfiguration(drs, i);
            this.addImportsToResolvableConfiguration(drs, cnf, importConfiguration);
            cnf.getIncoming().getArtifacts().getArtifacts().forEach(ar -> {
                File file = ar.getFile();
                this.withContext("catalog " + ar.getVariant().getOwner(), () -> this.importCatalogFromFile(file));
            });
        }
    }

    private void addImportsToResolvableConfiguration(DependencyResolutionServices drs, Configuration cnf, Import imported) {
        int importsSize = this.imports.size();
        for (int i = 0; i < importsSize; ++i) {
            Object notation = imported.notation;
            Dependency dependency = drs.getDependencyHandler().create(notation);
            cnf.getDependencies().add(dependency);
        }
    }

    private Configuration createResolvableConfiguration(DependencyResolutionServices drs, int i) {
        Configuration cnf = (Configuration)drs.getConfigurationContainer().create("incomingCatalogFor" + StringUtils.capitalize((String)this.name) + i);
        cnf.getResolutionStrategy().activateDependencyLocking();
        cnf.attributes(attrs -> {
            attrs.attribute(Category.CATEGORY_ATTRIBUTE, this.objects.named(Category.class, "platform"));
            attrs.attribute(Usage.USAGE_ATTRIBUTE, this.objects.named(Usage.class, "version-catalog"));
        });
        cnf.setCanBeResolved(true);
        cnf.setCanBeConsumed(false);
        return cnf;
    }

    @Override
    public void from(Object dependencyNotation) {
        if (!this.imports.isEmpty()) {
            this.throwVersionCatalogProblem(VersionCatalogProblemId.MULTIPLE_IMPORTS, spec -> spec.withShortDescription("You can only import a single external catalog in a given catalog definition").happensBecause("Multiple catalog imports are not yet supported").addSolution("Create a separate catalog for each import you want to use").documentedAt("platforms", "sec:sharing-catalogs"));
        }
        this.imports.add(new Import(dependencyNotation));
    }

    private void importCatalogFromFile(File modelFile) {
        if (!FileUtils.hasExtensionIgnoresCase(modelFile.getName(), "toml")) {
            this.throwVersionCatalogProblem(VersionCatalogProblemId.UNSUPPORTED_FILE_FORMAT, spec -> spec.withShortDescription(() -> "File " + modelFile.getName() + " isn't a supported").happensBecause("Only .toml files are allowed when importing catalogs").addSolution("Use a TOML file instead, with the .toml extension").documented());
        }
        if (!modelFile.exists()) {
            this.throwVersionCatalogProblem(VersionCatalogProblemId.CATALOG_FILE_DOES_NOT_EXIST, spec -> spec.withShortDescription(() -> "Import of external catalog file failed").happensBecause(() -> "File '" + modelFile + "' doesn't exist").addSolution(() -> "Make sure that the catalog file '" + modelFile.getName() + "' exists before importing it").documented());
        }
        RegularFileProperty srcProp = this.objects.fileProperty();
        srcProp.set(modelFile);
        Provider<byte[]> dataSource = this.providers.fileContents(srcProp).getAsBytes().forUseAtConfigurationTime();
        try {
            TomlCatalogFileParser.parse(new ByteArrayInputStream(dataSource.get()), this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String version(String name, Action<? super MutableVersionConstraint> versionSpec) {
        this.validateName("name", name);
        if (this.versionConstraints.containsKey(name)) {
            return name;
        }
        DefaultMutableVersionConstraint versionBuilder = new DefaultMutableVersionConstraint("");
        versionSpec.execute(versionBuilder);
        ImmutableVersionConstraint version = (ImmutableVersionConstraint)this.versionConstraintInterner.intern((Object)DefaultImmutableVersionConstraint.of(versionBuilder));
        this.versionConstraints.put(name, new VersionModel(version, this.currentContext));
        return name;
    }

    @Override
    public String version(String name, String version) {
        StrictVersionParser.RichVersion richVersion = this.strictVersionParser.parse(version);
        this.version(name, (? super MutableVersionConstraint vc) -> {
            if (richVersion.require != null) {
                vc.require(richVersion.require);
            }
            if (richVersion.prefer != null) {
                vc.prefer(richVersion.prefer);
            }
            if (richVersion.strictly != null) {
                vc.strictly(richVersion.strictly);
            }
        });
        return name;
    }

    @Override
    public VersionCatalogBuilder.AliasBuilder alias(String alias) {
        this.validateName("alias", alias);
        return new DefaultAliasBuilder(alias);
    }

    private void validateName(String type, String value) {
        if (!DependenciesModelHelper.ALIAS_PATTERN.matcher(value).matches()) {
            this.throwVersionCatalogProblem(VersionCatalogProblemId.INVALID_ALIAS_NOTATION, spec -> spec.withShortDescription(() -> "Invalid " + type + " '" + value + "' name").happensBecause(() -> type + " names must match the following regular expression: " + "[a-z]([a-zA-Z0-9_.\\-])+").addSolution(() -> "Make sure the name matches the [a-z]([a-zA-Z0-9_.\\-])+ regular expression").documented());
        }
        if ("alias".equals(type)) {
            this.validateAlias(value);
        }
    }

    private void validateAlias(String alias) {
        for (String suffix : FORBIDDEN_ALIAS_SUFFIX) {
            String sl = alias.toLowerCase();
            if (!sl.endsWith(suffix)) continue;
            this.throwVersionCatalogProblem(VersionCatalogProblemId.RESERVED_ALIAS_NAME, spec -> spec.withShortDescription(() -> "Alias '" + alias + "' is not a valid alias").happensBecause(() -> "It shouldn't end with '" + suffix + "'").addSolution(() -> "Use a different alias which doesn't end with " + RenderingUtils.oxfordListOf(FORBIDDEN_ALIAS_SUFFIX, "or")).documented());
        }
        if (RESERVED_ALIAS_NAMES.contains(alias)) {
            this.throwVersionCatalogProblem(VersionCatalogProblemId.RESERVED_ALIAS_NAME, spec -> spec.withShortDescription(() -> "Alias '" + alias + "' is not a valid alias").happensBecause(() -> "Alias '" + alias + "' is a reserved name in Gradle which prevents generation of accessors").addSolution(() -> "Use a different alias which isn't in the reserved names " + RenderingUtils.oxfordListOf(RESERVED_ALIAS_NAMES, "or")).documented());
        }
    }

    private <T> T throwVersionCatalogProblem(VersionCatalogProblemId id, Consumer<? super VersionCatalogProblemBuilder.ProblemWithId> spec) {
        DefaultCatalogProblemBuilder.maybeThrowError("Invalid catalog definition", (List<VersionCatalogProblem>)ImmutableList.of((Object)DefaultCatalogProblemBuilder.buildProblem(id, pb -> spec.accept(pb.inContext(() -> "version catalog " + this.name)))));
        return null;
    }

    @Override
    public void bundle(String name, List<String> aliases) {
        this.validateName("bundle", name);
        ImmutableList components = ImmutableList.copyOf((Collection)aliases.stream().map(this::intern).collect(Collectors.toList()));
        BundleModel previous = this.bundles.put(this.intern(name), new BundleModel((List<String>)components, this.currentContext));
        if (previous != null) {
            LOGGER.warn("Duplicate entry for bundle '{}': {} is replaced with {}", new Object[]{name, previous.getComponents(), components});
        }
    }

    @Nullable
    private String intern(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return (String)this.strings.intern((Object)value);
    }

    public boolean containsDependencyAlias(String name) {
        return this.dependencies.containsKey(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void createAliasWithVersionRef(String alias, String group, String name, String versionRef) {
        Supplier<DependencyModel> previous = this.dependencies.put(this.intern(alias), new VersionReferencingDependencyModel(group, name, versionRef));
        if (previous != null) {
            LOGGER.warn("Duplicate entry for alias '{}': {} is replaced with {}", new Object[]{alias, previous.get(), this.model});
        }
    }

    private static class Import {
        private final Object notation;

        private Import(Object notation) {
            this.notation = notation;
        }
    }

    public static class DefaultLibraryAliasBuilder
    implements VersionCatalogBuilder.LibraryAliasBuilder {
        private final DefaultVersionCatalogBuilder owner;
        private final String alias;
        private final String group;
        private final String name;

        @Inject
        public DefaultLibraryAliasBuilder(DefaultVersionCatalogBuilder owner, String alias, String group, String name) {
            this.owner = owner;
            this.alias = alias;
            this.group = group;
            this.name = name;
        }

        @Override
        public void version(Action<? super MutableVersionConstraint> versionSpec) {
            DefaultMutableVersionConstraint versionBuilder = new DefaultMutableVersionConstraint("");
            versionSpec.execute(versionBuilder);
            ImmutableVersionConstraint version = (ImmutableVersionConstraint)this.owner.versionConstraintInterner.intern((Object)DefaultImmutableVersionConstraint.of(versionBuilder));
            DependencyModel model = new DependencyModel(this.owner.intern(this.group), this.owner.intern(this.name), null, version, this.owner.currentContext);
            Supplier<DependencyModel> previous = this.owner.dependencies.put(this.owner.intern(this.alias), () -> model);
            if (previous != null) {
                LOGGER.warn("Duplicate entry for alias '{}': {} is replaced with {}", new Object[]{this.alias, previous.get(), model});
            }
        }

        @Override
        public void version(String version) {
            StrictVersionParser.RichVersion richVersion = this.owner.strictVersionParser.parse(version);
            this.version((? super MutableVersionConstraint vc) -> {
                if (richVersion.require != null) {
                    vc.require(richVersion.require);
                }
                if (richVersion.prefer != null) {
                    vc.prefer(richVersion.prefer);
                }
                if (richVersion.strictly != null) {
                    vc.strictly(richVersion.strictly);
                }
            });
        }

        @Override
        public void versionRef(String versionRef) {
            this.owner.createAliasWithVersionRef(this.alias, this.group, this.name, versionRef);
        }

        @Override
        public void withoutVersion() {
            this.version("");
        }
    }

    private class DefaultAliasBuilder
    implements VersionCatalogBuilder.AliasBuilder {
        private final String alias;

        public DefaultAliasBuilder(String alias) {
            this.alias = alias;
        }

        @Override
        public void to(String gavCoordinates) {
            String[] coordinates = gavCoordinates.split(":");
            if (coordinates.length == 3) {
                this.to(coordinates[0], coordinates[1]).version(coordinates[2]);
            } else {
                DefaultVersionCatalogBuilder.this.throwVersionCatalogProblem(VersionCatalogProblemId.INVALID_DEPENDENCY_NOTATION, spec -> spec.withShortDescription(() -> "On alias '" + this.alias + "' notation '" + gavCoordinates + "' is not a valid dependency notation").happensBecause(() -> "The 'to(String)' method only supports 'group:artifact:version' coordinates").addSolution("Make sure that the coordinates consist of 3 parts separated by colons, eg: my.group:artifact:1.2").addSolution("Use the to(group, name) method instead").documented());
            }
        }

        @Override
        public VersionCatalogBuilder.LibraryAliasBuilder to(String group, String name) {
            return DefaultVersionCatalogBuilder.this.objects.newInstance(DefaultLibraryAliasBuilder.class, DefaultVersionCatalogBuilder.this, this.alias, group, name);
        }
    }

    private class VersionReferencingDependencyModel
    implements Supplier<DependencyModel> {
        private final String group;
        private final String name;
        private final String versionRef;
        private final String context;

        private VersionReferencingDependencyModel(String group, String name, String versionRef) {
            this.group = group;
            this.name = name;
            this.versionRef = versionRef;
            this.context = DefaultVersionCatalogBuilder.this.currentContext;
        }

        @Override
        public DependencyModel get() {
            VersionModel model = (VersionModel)DefaultVersionCatalogBuilder.this.versionConstraints.get(this.versionRef);
            if (model == null) {
                return (DependencyModel)DefaultVersionCatalogBuilder.this.throwVersionCatalogProblem(VersionCatalogProblemId.UNDEFINED_VERSION_REFERENCE, spec -> {
                    VersionCatalogProblemBuilder.DescribedProblemWithCause solutions = spec.withShortDescription(() -> "Version reference '" + this.versionRef + "' doesn't exist").happensBecause("Dependency '" + this.group + ":" + this.name + "' references version '" + this.versionRef + "' which doesn't exist").addSolution(() -> "Declare '" + this.versionRef + "' in the catalog").documented();
                    if (!DefaultVersionCatalogBuilder.this.versionConstraints.keySet().isEmpty()) {
                        solutions.addSolution(() -> "Use one of the following existing versions: " + RenderingUtils.oxfordListOf(DefaultVersionCatalogBuilder.this.versionConstraints.keySet(), "or"));
                    }
                });
            }
            return new DependencyModel(this.group, this.name, this.versionRef, model.getVersion(), this.context);
        }
    }
}

