/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.recomp.DefaultSourceFileClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.FileNameDerivingClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationData;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntCollection;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;

public class PreviousCompilation {
    private final PreviousCompilationData data;
    private final ClassSetAnalysis classAnalysis;

    public PreviousCompilation(PreviousCompilationData data) {
        this.data = data;
        this.classAnalysis = new ClassSetAnalysis(data.getOutputSnapshot(), data.getAnnotationProcessingData(), data.getCompilerApiData());
    }

    @Nullable
    public ClassSetAnalysis getClasspath() {
        return new ClassSetAnalysis(this.data.getClasspathSnapshot());
    }

    public DependentsSet findDependents(ClassSetAnalysis.ClassSetDiff diff) {
        if (diff.getDependents().isDependencyToAll()) {
            return diff.getDependents();
        }
        return this.classAnalysis.findTransitiveDependents(diff.getDependents().getAllDependentClasses(), diff.getConstants());
    }

    public DependentsSet findDependents(String className, IntSet newConstants) {
        IntOpenHashSet constants = new IntOpenHashSet((IntCollection)this.classAnalysis.getConstants(className));
        constants.removeAll((IntCollection)newConstants);
        return this.classAnalysis.findTransitiveDependents(className, (IntSet)constants);
    }

    public Set<String> getTypesToReprocess() {
        return this.classAnalysis.getTypesToReprocess();
    }

    public SourceFileClassNameConverter getSourceToClassConverter() {
        if (this.data.getCompilerApiData().isAvailable()) {
            return new DefaultSourceFileClassNameConverter(this.data.getCompilerApiData().getSourceToClassMapping());
        }
        return new FileNameDerivingClassNameConverter();
    }
}

