/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import org.gradle.api.execution.internal.TaskInputsListeners;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.execution.EmptySourceTaskSkipper;
import org.gradle.internal.Cast;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.history.OutputsCleaner;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEmptySourceTaskSkipper
implements EmptySourceTaskSkipper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEmptySourceTaskSkipper.class);
    private final BuildOutputCleanupRegistry buildOutputCleanupRegistry;
    private final Deleter deleter;
    private final OutputChangeListener outputChangeListener;
    private final TaskInputsListeners taskInputsListeners;

    public DefaultEmptySourceTaskSkipper(BuildOutputCleanupRegistry buildOutputCleanupRegistry, Deleter deleter, OutputChangeListener outputChangeListener, TaskInputsListeners taskInputsListeners) {
        this.buildOutputCleanupRegistry = buildOutputCleanupRegistry;
        this.deleter = deleter;
        this.outputChangeListener = outputChangeListener;
        this.taskInputsListeners = taskInputsListeners;
    }

    @Override
    public Optional<ExecutionOutcome> skipIfEmptySources(TaskInternal task, boolean hasSourceFiles, FileCollection inputFiles, FileCollection sourceFiles, Map<String, FileSystemSnapshot> outputFileSnapshots) {
        if (hasSourceFiles && sourceFiles.isEmpty()) {
            ExecutionOutcome skipOutcome = this.skipOutcomeFor(task, outputFileSnapshots);
            this.broadcastFileSystemInputsOf(task, sourceFiles);
            return Optional.of(skipOutcome);
        }
        this.broadcastFileSystemInputsOf(task, inputFiles);
        return Optional.empty();
    }

    private ExecutionOutcome skipOutcomeFor(TaskInternal task, Map<String, FileSystemSnapshot> outputFileSnapshots) {
        if (outputFileSnapshots.isEmpty()) {
            LOGGER.info("Skipping {} as it has no source files and no previous output files.", (Object)task);
            return ExecutionOutcome.SHORT_CIRCUITED;
        }
        boolean didWork = this.cleanPreviousTaskOutputs(outputFileSnapshots);
        if (didWork) {
            LOGGER.info("Cleaned previous output of {} as it has no source files.", (Object)task);
            return ExecutionOutcome.EXECUTED_NON_INCREMENTALLY;
        }
        return ExecutionOutcome.SHORT_CIRCUITED;
    }

    private boolean cleanPreviousTaskOutputs(Map<String, FileSystemSnapshot> outputFileSnapshots) {
        OutputsCleaner outputsCleaner = new OutputsCleaner(this.deleter, this.buildOutputCleanupRegistry::isOutputOwnedByBuild, this.buildOutputCleanupRegistry::isOutputOwnedByBuild);
        for (FileSystemSnapshot outputFileSnapshot : outputFileSnapshots.values()) {
            try {
                this.outputChangeListener.beforeOutputChange(SnapshotUtil.rootIndex(outputFileSnapshot).keySet());
                outputsCleaner.cleanupOutputs(outputFileSnapshot);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return outputsCleaner.getDidWork();
    }

    private void broadcastFileSystemInputsOf(TaskInternal task, FileCollection fileSystemInputs) {
        this.taskInputsListeners.broadcastFileSystemInputsOf(task, Cast.cast(FileCollectionInternal.class, fileSystemInputs));
    }
}

