/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.AbstractCompositeParticipantBuildState;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;

public class DefaultIncludedBuild
extends AbstractCompositeParticipantBuildState
implements IncludedBuildState,
IncludedBuild,
Stoppable {
    private final BuildIdentifier buildIdentifier;
    private final Path identityPath;
    private final BuildDefinition buildDefinition;
    private final boolean isImplicit;
    private final BuildState owner;
    private final WorkerLeaseRegistry.WorkerLease parentLease;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildLifecycleController buildLifecycleController;

    public DefaultIncludedBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, boolean isImplicit, BuildState owner, BuildTreeState buildTree, WorkerLeaseRegistry.WorkerLease parentLease, BuildLifecycleControllerFactory buildLifecycleControllerFactory, ProjectStateRegistry projectStateRegistry) {
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.buildDefinition = buildDefinition;
        this.isImplicit = isImplicit;
        this.owner = owner;
        this.parentLease = parentLease;
        this.projectStateRegistry = projectStateRegistry;
        BuildScopeServices buildScopeServices = new BuildScopeServices(buildTree.getServices());
        this.buildLifecycleController = buildLifecycleControllerFactory.newInstance(buildDefinition.newInstance(), this, owner.getMutableModel(), buildScopeServices);
    }

    @Override
    protected ProjectStateRegistry getProjectStateRegistry() {
        return this.projectStateRegistry;
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public File getRootDirectory() {
        return this.buildDefinition.getBuildRootDir();
    }

    @Override
    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public boolean isImplicitBuild() {
        return this.isImplicit;
    }

    @Override
    public IncludedBuild getModel() {
        return this;
    }

    @Override
    public boolean isPluginBuild() {
        return this.buildDefinition.isPluginBuild();
    }

    @Override
    public File getProjectDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    @Override
    public TaskReference task(String path) {
        Preconditions.checkArgument((boolean)path.startsWith(":"), (String)"Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", (Object)path);
        return new IncludedBuildTaskReference(this, path);
    }

    @Override
    public String getName() {
        return this.identityPath.getName();
    }

    @Override
    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
        if (this.isImplicit) {
            super.assertCanAdd(includedBuildSpec);
        }
    }

    @Override
    public File getBuildRootDir() {
        return this.buildDefinition.getBuildRootDir();
    }

    @Override
    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildIdentifier.getName());
    }

    @Override
    public Path getIdentityPathForProject(Path projectPath) {
        return this.getIdentityPath().append(projectPath);
    }

    @Override
    public Action<? super DependencySubstitutions> getRegisteredDependencySubstitutions() {
        return this.buildDefinition.getDependencySubstitutions();
    }

    @Override
    public boolean hasInjectedSettingsPlugins() {
        return !this.buildDefinition.getInjectedPluginRequests().isEmpty();
    }

    @Override
    public SettingsInternal loadSettings() {
        return this.buildLifecycleController.getLoadedSettings();
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.getGradle().getSettings();
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        return this.buildLifecycleController.getConfiguredBuild();
    }

    @Override
    public GradleInternal getBuild() {
        return this.getConfiguredBuild();
    }

    @Override
    public <T> T withState(Transformer<T, ? super GradleInternal> action) {
        return action.transform(this.getGradle());
    }

    @Override
    public void finishBuild(Consumer<? super Throwable> collector) {
        this.buildLifecycleController.finishBuild(null, collector);
    }

    @Override
    public synchronized void addTasks(Iterable<String> taskPaths) {
        this.scheduleTasks(taskPaths);
    }

    @Override
    public synchronized void execute(Iterable<String> tasks, Object listener) {
        this.buildLifecycleController.addListener(listener);
        this.scheduleTasks(tasks);
        WorkerLeaseService workerLeaseService = this.gradleService(WorkerLeaseService.class);
        workerLeaseService.withSharedLease(this.parentLease, this.buildLifecycleController::executeTasks);
    }

    @Override
    public void stop() {
        this.buildLifecycleController.stop();
    }

    protected void scheduleTasks(Iterable<String> tasks) {
        this.buildLifecycleController.scheduleTasks(tasks);
    }

    protected GradleInternal getGradle() {
        return this.buildLifecycleController.getGradle();
    }

    @Override
    public GradleInternal getMutableModel() {
        return this.buildLifecycleController.getGradle();
    }

    private <T> T gradleService(Class<T> serviceType) {
        return this.getGradle().getServices().get(serviceType);
    }
}

