/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.buildsrc;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BuildSrcDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildSrcDetector.class);
    private static final String[] GRADLE_BUILD_FILES = new String[]{"settings.gradle", "settings.gradle.kts", "build.gradle", "build.gradle.kts"};

    BuildSrcDetector() {
    }

    public static boolean isValidBuildSrcBuild(File buildSrcDir) {
        if (!buildSrcDir.exists()) {
            return false;
        }
        if (!buildSrcDir.isDirectory()) {
            LOGGER.info("Ignoring buildSrc: not a directory.");
            return false;
        }
        for (String buildFileName : GRADLE_BUILD_FILES) {
            if (!new File(buildSrcDir, buildFileName).exists()) continue;
            return true;
        }
        if (BuildSrcDetector.containsFiles(new File(buildSrcDir, "src"))) {
            return true;
        }
        LOGGER.info("Ignoring buildSrc directory: does not contain 'settings.gradle[.kts]', 'build.gradle[.kts]', or a 'src' directory.");
        return false;
    }

    private static boolean containsFiles(File directory) {
        boolean bl;
        block9: {
            if (!directory.exists() || !directory.isDirectory()) {
                return false;
            }
            Stream<Path> directoryContents = Files.walk(directory.toPath(), new FileVisitOption[0]);
            try {
                bl = directoryContents.anyMatch(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
                if (directoryContents == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryContents != null) {
                        try {
                            directoryContents.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            directoryContents.close();
        }
        return bl;
    }
}

