/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.util.function.Function;
import org.gradle.internal.Cast;

public abstract class Either<L, R> {
    public static <L, R> Either<L, R> left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Right(value);
    }

    public abstract <U> U fold(Function<L, U> var1, Function<R, U> var2);

    public abstract <U> Either<L, U> map(Function<R, U> var1);

    private static class Right<L, R>
    extends Either<L, R> {
        private final R value;

        public Right(R value) {
            this.value = value;
        }

        @Override
        public <U> U fold(Function<L, U> l, Function<R, U> r) {
            return r.apply(this.value);
        }

        @Override
        public <U> Either<L, U> map(Function<R, U> r) {
            return new Right<L, U>(r.apply(this.value));
        }
    }

    private static class Left<L, R>
    extends Either<L, R> {
        private final L value;

        public Left(L value) {
            this.value = value;
        }

        @Override
        public <U> U fold(Function<L, U> l, Function<R, U> r) {
            return l.apply(this.value);
        }

        @Override
        public <U> Either<L, U> map(Function<R, U> r) {
            return (Either)Cast.uncheckedCast(this);
        }
    }
}

