/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeWorkExecutor;
import org.gradle.internal.work.WorkerLeaseService;

public class DefaultBuildTreeLifecycleController
implements BuildTreeLifecycleController {
    private boolean completed;
    private final BuildLifecycleController buildLifecycleController;
    private final WorkerLeaseService workerLeaseService;
    private final BuildTreeWorkExecutor workExecutor;
    private final IncludedBuildControllers includedBuildControllers;
    private final ExceptionAnalyser exceptionAnalyser;

    public DefaultBuildTreeLifecycleController(BuildLifecycleController buildLifecycleController, WorkerLeaseService workerLeaseService, BuildTreeWorkExecutor workExecutor, IncludedBuildControllers includedBuildControllers, ExceptionAnalyser exceptionAnalyser) {
        this.buildLifecycleController = buildLifecycleController;
        this.workerLeaseService = workerLeaseService;
        this.workExecutor = workExecutor;
        this.includedBuildControllers = includedBuildControllers;
        this.exceptionAnalyser = exceptionAnalyser;
    }

    @Override
    public GradleInternal getGradle() {
        if (this.completed) {
            throw new IllegalStateException("Cannot use Gradle object after build has finished.");
        }
        return this.buildLifecycleController.getGradle();
    }

    @Override
    public void scheduleAndRunTasks() {
        this.doBuild((buildController, failures) -> {
            buildController.scheduleRequestedTasks();
            this.workExecutor.execute(failures);
            return null;
        });
    }

    @Override
    public <T> T fromBuildModel(boolean runTasks, Function<? super GradleInternal, T> action) {
        return (T)this.doBuild((buildController, failureCollector) -> {
            if (runTasks) {
                buildController.scheduleRequestedTasks();
                ArrayList failures = new ArrayList();
                this.workExecutor.execute(throwable -> {
                    failures.add(throwable);
                    failureCollector.accept(throwable);
                });
                if (!failures.isEmpty()) {
                    return null;
                }
            } else {
                buildController.getConfiguredBuild();
            }
            return action.apply(buildController.getGradle());
        });
    }

    @Override
    public <T> T withEmptyBuild(Function<? super SettingsInternal, T> action) {
        return (T)this.doBuild((buildController, failures) -> action.apply(buildController.getLoadedSettings()));
    }

    private <T> T doBuild(BuildAction<T> build) {
        if (this.completed) {
            throw new IllegalStateException("Cannot run more than one action for this build.");
        }
        this.completed = true;
        return (T)this.workerLeaseService.withLocks(Collections.singleton(this.workerLeaseService.getWorkerLease()), () -> {
            Object result;
            ArrayList<Throwable> failures = new ArrayList<Throwable>();
            Consumer<Throwable> collector = failures::add;
            try {
                result = build.run(this.buildLifecycleController, collector);
            }
            catch (Throwable t) {
                result = null;
                failures.add(t);
            }
            this.includedBuildControllers.finishBuild(collector);
            RuntimeException reportableFailure = this.exceptionAnalyser.transform(failures);
            this.buildLifecycleController.finishBuild(reportableFailure, collector);
            RuntimeException finalReportableFailure = this.exceptionAnalyser.transform(failures);
            if (finalReportableFailure != null) {
                throw finalReportableFailure;
            }
            return result;
        });
    }

    private static interface BuildAction<T> {
        public T run(BuildLifecycleController var1, Consumer<Throwable> var2);
    }
}

