/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;

public abstract class Documentation {
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    static final Documentation NO_DOCUMENTATION = new NullDocumentation();

    static Documentation userManual(String id, String section) {
        return new UserGuide(id, section);
    }

    static Documentation userManual(String id) {
        return new UserGuide(id, null);
    }

    static Documentation upgradeGuide(int majorVersion, String upgradeGuideSection) {
        return new UpgradeGuide(majorVersion, upgradeGuideSection);
    }

    public static Documentation dslReference(Class<?> targetClass, String property) {
        return new DslReference(targetClass, property);
    }

    abstract String documentationUrl();

    public String consultDocumentationMessage() {
        return String.format("See %s for more details.", this.documentationUrl());
    }

    private static class DslReference
    extends Documentation {
        private final Class<?> targetClass;
        private final String property;

        public DslReference(Class<?> targetClass, String property) {
            this.targetClass = (Class)Preconditions.checkNotNull(targetClass);
            this.property = (String)Preconditions.checkNotNull((Object)property);
        }

        @Override
        String documentationUrl() {
            return DOCUMENTATION_REGISTRY.getDslRefForProperty(this.targetClass, this.property);
        }
    }

    private static class UpgradeGuide
    extends Documentation {
        private final int majorVersion;
        private final String section;

        private UpgradeGuide(int majorVersion, String section) {
            this.majorVersion = majorVersion;
            this.section = (String)Preconditions.checkNotNull((Object)section);
        }

        @Override
        String documentationUrl() {
            return DOCUMENTATION_REGISTRY.getDocumentationFor("upgrading_version_" + this.majorVersion, this.section);
        }

        @Override
        public String consultDocumentationMessage() {
            return "Consult the upgrading guide for further information: " + this.documentationUrl();
        }
    }

    private static class UserGuide
    extends Documentation {
        private final String id;
        private final String section;

        private UserGuide(String id, String section) {
            this.id = (String)Preconditions.checkNotNull((Object)id);
            this.section = section;
        }

        @Override
        String documentationUrl() {
            if (this.section != null) {
                return DOCUMENTATION_REGISTRY.getDocumentationFor(this.id, this.section);
            }
            return DOCUMENTATION_REGISTRY.getDocumentationFor(this.id);
        }
    }

    private static class NullDocumentation
    extends Documentation {
        private NullDocumentation() {
        }

        @Override
        String documentationUrl() {
            return null;
        }

        @Override
        public String consultDocumentationMessage() {
            return null;
        }
    }
}

