/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import javax.annotation.Nullable;
import org.gradle.internal.execution.history.changes.ExecutionStateChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.history.changes.NonIncrementalInputChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;

public class RebuildExecutionStateChanges
implements ExecutionStateChanges {
    private final String rebuildReason;
    private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileProperties;
    private final IncrementalInputProperties incrementalInputProperties;

    public RebuildExecutionStateChanges(String rebuildReason, @Nullable ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileProperties, IncrementalInputProperties incrementalInputProperties) {
        this.rebuildReason = rebuildReason;
        this.inputFileProperties = inputFileProperties;
        this.incrementalInputProperties = incrementalInputProperties;
    }

    @Override
    public ImmutableList<String> getAllChangeMessages() {
        return ImmutableList.of((Object)this.rebuildReason);
    }

    @Override
    public InputChangesInternal createInputChanges() {
        if (this.inputFileProperties == null) {
            throw new UnsupportedOperationException("Cannot query input changes when input tracking is disabled.");
        }
        return new NonIncrementalInputChanges(this.inputFileProperties, this.incrementalInputProperties);
    }

    @Override
    public ExecutionStateChanges withEnforcedRebuild(String rebuildReason) {
        return new RebuildExecutionStateChanges(rebuildReason, this.inputFileProperties, this.incrementalInputProperties);
    }
}

