/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.execution.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.execution.fingerprint.FileCollectionSnapshotter;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;

@NonNullApi
public abstract class AbstractFileCollectionFingerprinter
implements FileCollectionFingerprinter {
    private final FileCollectionSnapshotter fileCollectionSnapshotter;
    private final FingerprintingStrategy fingerprintingStrategy;

    public AbstractFileCollectionFingerprinter(FingerprintingStrategy fingerprintingStrategy, FileCollectionSnapshotter fileCollectionSnapshotter) {
        this.fingerprintingStrategy = fingerprintingStrategy;
        this.fileCollectionSnapshotter = fileCollectionSnapshotter;
    }

    @Override
    public CurrentFileCollectionFingerprint fingerprint(FileCollection files) {
        FileSystemSnapshot roots = this.fileCollectionSnapshotter.snapshot(files);
        return DefaultCurrentFileCollectionFingerprint.from(roots, this.fingerprintingStrategy);
    }

    @Override
    public CurrentFileCollectionFingerprint fingerprint(FileSystemSnapshot roots) {
        return DefaultCurrentFileCollectionFingerprint.from(roots, this.fingerprintingStrategy);
    }

    @Override
    public String normalizePath(FileSystemLocationSnapshot root) {
        return this.fingerprintingStrategy.normalizePath(root);
    }

    @Override
    public CurrentFileCollectionFingerprint empty() {
        return this.fingerprintingStrategy.getEmptyFingerprint();
    }

    @Override
    public DirectorySensitivity getDirectorySensitivity() {
        return this.fingerprintingStrategy.getDirectorySensitivity();
    }
}

