/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import java.io.File;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.Stat;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Striped;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.internal.snapshot.impl.DirectorySnapshotter;
import org.gradle.internal.snapshot.impl.DirectorySnapshotterStatistics;
import org.gradle.internal.snapshot.impl.FileSystemSnapshotFilter;
import org.gradle.internal.vfs.FileSystemAccess;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileSystemAccess
implements FileSystemAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileSystemAccess.class);
    private final VirtualFileSystem virtualFileSystem;
    private final Stat stat;
    private final Interner<String> stringInterner;
    private final FileSystemAccess.WriteListener writeListener;
    private final DirectorySnapshotterStatistics.Collector statisticsCollector;
    private ImmutableList<String> defaultExcludes;
    private DirectorySnapshotter directorySnapshotter;
    private final FileHasher hasher;
    private final StripedProducerGuard<String> producingSnapshots = new StripedProducerGuard();

    public DefaultFileSystemAccess(FileHasher hasher, Interner<String> stringInterner, Stat stat, VirtualFileSystem virtualFileSystem, FileSystemAccess.WriteListener writeListener, DirectorySnapshotterStatistics.Collector statisticsCollector, String ... defaultExcludes) {
        this.stringInterner = stringInterner;
        this.stat = stat;
        this.writeListener = writeListener;
        this.statisticsCollector = statisticsCollector;
        this.defaultExcludes = ImmutableList.copyOf((Object[])defaultExcludes);
        this.directorySnapshotter = new DirectorySnapshotter(hasher, stringInterner, (Collection<String>)this.defaultExcludes, statisticsCollector);
        this.hasher = hasher;
        this.virtualFileSystem = virtualFileSystem;
    }

    @Override
    public <T> T read(String location, Function<FileSystemLocationSnapshot, T> visitor) {
        return visitor.apply(this.readLocation(location));
    }

    @Override
    public <T> Optional<T> readRegularFileContentHash(String location, Function<HashCode, T> visitor) {
        return this.virtualFileSystem.getMetadata(location).flatMap(snapshot -> {
            if (snapshot.getType() != FileType.RegularFile) {
                return Optional.of(Optional.empty());
            }
            if (snapshot instanceof FileSystemLocationSnapshot) {
                return Optional.of(Optional.of(((FileSystemLocationSnapshot)snapshot).getHash()));
            }
            return Optional.empty();
        }).orElseGet(() -> {
            File file = new File(location);
            FileMetadata fileMetadata = this.stat.stat(file);
            if (fileMetadata.getType() == FileType.Missing) {
                this.storeMetadataForMissingFile(location, fileMetadata.getAccessType());
            }
            if (fileMetadata.getType() != FileType.RegularFile) {
                return Optional.empty();
            }
            HashCode hash = this.producingSnapshots.guardByKey(location, () -> this.virtualFileSystem.getSnapshot(location).orElseGet(() -> {
                HashCode hashCode = this.hasher.hash(file, fileMetadata.getLength(), fileMetadata.getLastModified());
                RegularFileSnapshot snapshot = new RegularFileSnapshot(location, file.getName(), hashCode, fileMetadata);
                this.virtualFileSystem.store(snapshot.getAbsolutePath(), snapshot);
                return snapshot;
            }).getHash());
            return Optional.of(hash);
        }).map(visitor);
    }

    private void storeMetadataForMissingFile(String location, FileMetadata.AccessType accessType) {
        this.virtualFileSystem.store(location, new MissingFileSnapshot(location, accessType));
    }

    @Override
    public void read(String location, SnapshottingFilter filter, Consumer<FileSystemLocationSnapshot> visitor) {
        if (filter.isEmpty()) {
            visitor.accept(this.readLocation(location));
        } else {
            FileSystemSnapshot filteredSnapshot = this.readSnapshotFromLocation(location, snapshot -> FileSystemSnapshotFilter.filterSnapshot(filter.getAsSnapshotPredicate(), snapshot), () -> {
                FileSystemLocationSnapshot snapshot = this.snapshot(location, filter);
                return snapshot.getType() == FileType.Directory ? snapshot : FileSystemSnapshotFilter.filterSnapshot(filter.getAsSnapshotPredicate(), snapshot);
            });
            if (filteredSnapshot instanceof FileSystemLocationSnapshot) {
                visitor.accept((FileSystemLocationSnapshot)filteredSnapshot);
            }
        }
    }

    private FileSystemLocationSnapshot snapshot(String location, SnapshottingFilter filter) {
        File file = new File(location);
        FileMetadata fileMetadata = this.stat.stat(file);
        switch (fileMetadata.getType()) {
            case RegularFile: {
                HashCode hash = this.hasher.hash(file, fileMetadata.getLength(), fileMetadata.getLastModified());
                RegularFileSnapshot regularFileSnapshot = new RegularFileSnapshot(location, file.getName(), hash, fileMetadata);
                this.virtualFileSystem.store(regularFileSnapshot.getAbsolutePath(), regularFileSnapshot);
                return regularFileSnapshot;
            }
            case Missing: {
                MissingFileSnapshot missingFileSnapshot = new MissingFileSnapshot(location, fileMetadata.getAccessType());
                this.virtualFileSystem.store(missingFileSnapshot.getAbsolutePath(), missingFileSnapshot);
                return missingFileSnapshot;
            }
            case Directory: {
                AtomicBoolean hasBeenFiltered = new AtomicBoolean(false);
                FileSystemLocationSnapshot directorySnapshot = this.directorySnapshotter.snapshot(location, filter.isEmpty() ? null : filter.getAsDirectoryWalkerPredicate(), hasBeenFiltered);
                if (!hasBeenFiltered.get()) {
                    this.virtualFileSystem.store(directorySnapshot.getAbsolutePath(), directorySnapshot);
                }
                return directorySnapshot;
            }
        }
        throw new UnsupportedOperationException();
    }

    private FileSystemLocationSnapshot readLocation(String location) {
        return this.readSnapshotFromLocation(location, () -> this.snapshot(location, SnapshottingFilter.EMPTY));
    }

    private FileSystemLocationSnapshot readSnapshotFromLocation(String location, Supplier<FileSystemLocationSnapshot> readFromDisk) {
        return this.readSnapshotFromLocation(location, Function.identity(), readFromDisk);
    }

    private <T> T readSnapshotFromLocation(String location, Function<FileSystemLocationSnapshot, T> snapshotProcessor, Supplier<T> readFromDisk) {
        return (T)this.virtualFileSystem.getSnapshot(location).map(snapshotProcessor).orElseGet(() -> this.producingSnapshots.guardByKey(location, () -> this.lambda$readSnapshotFromLocation$7(location, snapshotProcessor, (Supplier)readFromDisk)));
    }

    @Override
    public void write(Iterable<String> locations, Runnable action) {
        this.writeListener.locationsWritten(locations);
        this.virtualFileSystem.invalidate(locations);
        action.run();
    }

    @Override
    public void record(FileSystemLocationSnapshot snapshot) {
        this.virtualFileSystem.store(snapshot.getAbsolutePath(), snapshot);
    }

    public void updateDefaultExcludes(String ... newDefaultExcludesArgs) {
        ImmutableList newDefaultExcludes = ImmutableList.copyOf((Object[])newDefaultExcludesArgs);
        if (!this.defaultExcludes.equals((Object)newDefaultExcludes)) {
            LOGGER.debug("Default excludes changes from {} to {}", this.defaultExcludes, (Object)newDefaultExcludes);
            this.defaultExcludes = newDefaultExcludes;
            this.directorySnapshotter = new DirectorySnapshotter(this.hasher, this.stringInterner, (Collection<String>)newDefaultExcludes, this.statisticsCollector);
            this.virtualFileSystem.invalidateAll();
        }
    }

    private /* synthetic */ Object lambda$readSnapshotFromLocation$7(String location, Function snapshotProcessor, Supplier readFromDisk) {
        return this.virtualFileSystem.getSnapshot(location).map(snapshotProcessor).orElseGet(readFromDisk);
    }

    private static class StripedProducerGuard<T> {
        private final Striped<Lock> locks = Striped.lock((int)(Runtime.getRuntime().availableProcessors() * 4));

        private StripedProducerGuard() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <V> V guardByKey(T key, Supplier<V> supplier) {
            Lock lock = (Lock)this.locks.get(key);
            try {
                lock.lock();
                V v = supplier.get();
                return v;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

