/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.platform.internal;

import net.rubygrapefruit.platform.SystemInfo;
import org.gradle.internal.nativeintegration.NativeIntegrationUnavailableException;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.platform.internal.ArchitectureInternal;
import org.gradle.nativeplatform.platform.internal.Architectures;
import org.gradle.nativeplatform.platform.internal.DefaultOperatingSystem;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;

public class DefaultNativePlatform
implements NativePlatformInternal {
    private final String name;
    private ArchitectureInternal architecture;
    private OperatingSystemInternal operatingSystem;

    public DefaultNativePlatform(String name) {
        this(name, DefaultNativePlatform.getCurrentOperatingSystem(), DefaultNativePlatform.getCurrentArchitecture());
    }

    public DefaultNativePlatform(String name, OperatingSystemInternal operatingSystem, ArchitectureInternal architecture) {
        this.name = name;
        this.architecture = architecture;
        this.operatingSystem = operatingSystem;
    }

    public static DefaultOperatingSystem getCurrentOperatingSystem() {
        return new DefaultOperatingSystem(System.getProperty("os.name"), OperatingSystem.current());
    }

    public static ArchitectureInternal getCurrentArchitecture() {
        String architectureName;
        try {
            architectureName = NativeServices.getInstance().get(SystemInfo.class).getArchitectureName();
        }
        catch (NativeIntegrationUnavailableException e) {
            architectureName = System.getProperty("os.arch");
        }
        return Architectures.forInput(architectureName);
    }

    public static DefaultNativePlatform host() {
        return new HostPlatform();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return String.format("platform '%s'", this.name);
    }

    @Override
    public ArchitectureInternal getArchitecture() {
        return this.architecture;
    }

    @Override
    public void architecture(String name) {
        this.architecture = Architectures.forInput(name);
    }

    @Override
    public OperatingSystemInternal getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public void operatingSystem(String name) {
        this.operatingSystem = new DefaultOperatingSystem(name);
    }

    public DefaultNativePlatform withArchitecture(ArchitectureInternal architecture) {
        return new DefaultNativePlatform(this.name, this.operatingSystem, architecture);
    }

    private static class HostPlatform
    extends DefaultNativePlatform {
        HostPlatform() {
            super("host:" + DefaultNativePlatform.getCurrentArchitecture().getName(), DefaultNativePlatform.getCurrentOperatingSystem(), DefaultNativePlatform.getCurrentArchitecture());
        }

        HostPlatform(ArchitectureInternal architecture) {
            super("host:" + architecture.getName(), DefaultNativePlatform.getCurrentOperatingSystem(), architecture);
        }

        @Override
        public String getDisplayName() {
            return String.format("host %s %s", this.getOperatingSystem(), this.getArchitecture());
        }

        @Override
        public DefaultNativePlatform withArchitecture(ArchitectureInternal architecture) {
            return new HostPlatform(architecture);
        }
    }
}

