/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.typescript;

import com.intellij.lang.javascript.linter.tslint.TslintUtil;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServiceExtension;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TslintTypeScriptExtension
implements TypeScriptServiceExtension {
    @NotNull
    public Set<VirtualFile> getConfigFilesToWatch(@NotNull PsiFile fileToHighlight) {
        VirtualFile tslintJson;
        if (fileToHighlight == null) {
            TslintTypeScriptExtension.$$$reportNull$$$0(0);
        }
        if (!TslintTypeScriptExtension.hasTslint(fileToHighlight)) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                TslintTypeScriptExtension.$$$reportNull$$$0(1);
            }
            return set;
        }
        VirtualFile virtualFile = fileToHighlight.getVirtualFile();
        if (virtualFile != null && (tslintJson = TslintUtil.lookupConfig(fileToHighlight.getProject(), virtualFile)) != null) {
            HashSet hashSet = ContainerUtil.newHashSet((Object[])new VirtualFile[]{tslintJson});
            if (hashSet == null) {
                TslintTypeScriptExtension.$$$reportNull$$$0(2);
            }
            return hashSet;
        }
        Set<VirtualFile> set = Collections.emptySet();
        if (set == null) {
            TslintTypeScriptExtension.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean shouldReformatAfterFix(@NotNull TypeScriptLanguageServiceAnnotationResult result) {
        if (result == null) {
            TslintTypeScriptExtension.$$$reportNull$$$0(4);
        }
        return !StringUtil.equals((CharSequence)result.getSource(), (CharSequence)"tslint");
    }

    private static boolean hasTslint(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        PsiFile psi;
        if (project == null) {
            TslintTypeScriptExtension.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            TslintTypeScriptExtension.$$$reportNull$$$0(6);
        }
        return (psi = PsiManager.getInstance((Project)project).findFile(virtualFile)) != null && TslintTypeScriptExtension.hasTslint(psi);
    }

    private static boolean hasTslint(@NotNull PsiFile fileToHighlight) {
        TypeScriptConfig config;
        if (fileToHighlight == null) {
            TslintTypeScriptExtension.$$$reportNull$$$0(7);
        }
        return (config = TypeScriptConfigUtil.getConfigForPsiFile((PsiFile)fileToHighlight)) != null && (config.getPlugins().contains("typescript-tslint-plugin") || config.getPlugins().contains("tslint-language-service"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToHighlight";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/typescript/TslintTypeScriptExtension";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/typescript/TslintTypeScriptExtension";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFilesToWatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFilesToWatch";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldReformatAfterFix";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasTslint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

