/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.local;

import com.intellij.internal.statistic.local.ActionSummary;
import com.intellij.internal.statistic.local.ActionsLocalSummary;
import com.intellij.internal.statistic.local.ActionsLocalSummaryState;
import com.intellij.internal.statistic.local.ActionsTotalSummary;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SimpleModificationTracker;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ActionsLocalSummary", storages={@Storage(value="actionSummary.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false)
@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\u000eJ\b\u0010\u000f\u001a\u00020\u0002H\u0016J\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/local/ActionsLocalSummary;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/internal/statistic/local/ActionsLocalSummaryState;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "()V", "state", "totalSummary", "Lcom/intellij/internal/statistic/local/ActionsTotalSummary;", "calculateTotalSummary", "getActionStatsById", "Lcom/intellij/internal/statistic/local/ActionSummary;", "actionId", "", "getActionsStats", "", "getState", "getTotalStats", "loadState", "", "updateActionsSummary", "updateActionsSummary$intellij_platform_statistics", "intellij.platform.statistics"})
public final class ActionsLocalSummary
extends SimpleModificationTracker
implements PersistentStateComponent<ActionsLocalSummaryState> {
    private volatile ActionsLocalSummaryState state = new ActionsLocalSummaryState(null, 1, null);
    private volatile ActionsTotalSummary totalSummary = new ActionsTotalSummary(0, 0, 3, null);

    @NotNull
    public ActionsLocalSummaryState getState() {
        return this.state;
    }

    public void loadState(@NotNull ActionsLocalSummaryState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.totalSummary = this.calculateTotalSummary(state);
    }

    private final ActionsTotalSummary calculateTotalSummary(ActionsLocalSummaryState state) {
        int maxUsageCount = 0;
        int minUsageCount = Integer.MAX_VALUE;
        for (ActionSummary value : state.getData$intellij_platform_statistics().values()) {
            int n = value.usageCount;
            boolean bl = false;
            maxUsageCount = Math.max(maxUsageCount, n);
            n = value.usageCount;
            bl = false;
            minUsageCount = Math.min(minUsageCount, n);
        }
        return new ActionsTotalSummary(maxUsageCount, minUsageCount);
    }

    @NotNull
    public final synchronized ActionsTotalSummary getTotalStats() {
        return this.totalSummary;
    }

    @NotNull
    public final synchronized Map<String, ActionSummary> getActionsStats() {
        return this.state.getData$intellij_platform_statistics().isEmpty() ? MapsKt.emptyMap() : (Map)new HashMap<String, ActionSummary>(this.state.getData$intellij_platform_statistics());
    }

    @Nullable
    public final synchronized ActionSummary getActionStatsById(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        return this.state.getData$intellij_platform_statistics().get(actionId);
    }

    public final synchronized void updateActionsSummary$intellij_platform_statistics(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        ActionSummary actionSummary = this.state.getData$intellij_platform_statistics().computeIfAbsent(actionId, updateActionsSummary.summary.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)actionSummary, (String)"state.data.computeIfAbse\u2026onId) { ActionSummary() }");
        ActionSummary summary2 = actionSummary;
        summary2.lastUsedTimestamp = System.currentTimeMillis();
        int n = summary2.usageCount;
        n = summary2.usageCount = n + 1;
        int n2 = this.totalSummary.getMaxUsageCount();
        boolean bl = false;
        this.totalSummary.setMaxUsageCount(Math.max(n, n2));
        n = summary2.usageCount;
        n2 = this.totalSummary.getMinUsageCount();
        bl = false;
        this.totalSummary.setMinUsageCount(Math.min(n, n2));
        this.incModificationCount();
    }
}

