/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import org.coffeescript.file.CoffeeScriptFileType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class CoffeeScriptChangeUtil {
    @NonNls
    private static final String DUMMY = "dummy.";

    @Nullable
    public static PsiElement createElementFromText(String text, FileType fileType, Project project) {
        @NonNls String ext = fileType.getDefaultExtension();
        @NonNls String name = DUMMY + ext;
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)project).createFileFromText(name, text);
        return dummyFile.getFirstChild();
    }

    @Nullable
    public static ASTNode createCoffeeScriptNodeFromText(String text, Project project) {
        PsiElement resultElement = CoffeeScriptChangeUtil.createElementFromText(text, (FileType)CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE, project);
        return resultElement != null ? resultElement.getNode() : null;
    }
}

