/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.jest.JestConsoleProperties;
import com.intellij.javascript.jest.JestCoverageConfigurator;
import com.intellij.javascript.jest.JestFailedTest;
import com.intellij.javascript.jest.JestFilter;
import com.intellij.javascript.jest.JestPackageProvider;
import com.intellij.javascript.jest.JestPkgInfo;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.debug.NodeCommandLineOwner;
import com.intellij.javascript.nodejs.debug.NodeLocalDebuggableRunProfileStateSync;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testing.AngularCliConfig;
import com.intellij.javascript.testing.JSTestRunnerUtil;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JestRunProfileState
extends NodeLocalDebuggableRunProfileStateSync
implements NodeCommandLineOwner {
    private static final Logger LOG = Logger.getInstance(JestRunProfileState.class);
    private static final String TEST_RESULTS_PROCESSOR = "jest-intellij/lib/jest-intellij-test-results-processor.js";
    private static final String REPORTER = "jest-intellij/lib/jest-intellij-reporter.js";
    private static final String STDIN_FIX = "jest-intellij/lib/jest-intellij-stdin-fix.js";
    private static volatile File TEMP_INPUT_FILE;
    private final Project myProject;
    private final JestRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnvironment;
    private final NodePackage myJestPackage;
    private final JestRunSettings myRunSettings;
    private final ConsoleCommandLineFolder myFolder;
    private List<JestFailedTest> myFailedTests;
    private final ClearableLazyValue<Ref<SemVer>> myJestVersionLazyValue;
    private final ClearableLazyValue<Ref<SemVer>> myJestVersionFromDependenciesLazyValue;

    public JestRunProfileState(@NotNull JestRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodePackage jestPackage) {
        if (runConfiguration == null) {
            JestRunProfileState.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            JestRunProfileState.$$$reportNull$$$0(1);
        }
        if (jestPackage == null) {
            JestRunProfileState.$$$reportNull$$$0(2);
        }
        this.myFolder = new ConsoleCommandLineFolder(new String[0]);
        this.myJestVersionLazyValue = ClearableLazyValue.create(() -> Ref.create((Object)this.calcJestVersion()));
        this.myJestVersionFromDependenciesLazyValue = ClearableLazyValue.create(() -> Ref.create((Object)this.calcJestVersionFromDependencies()));
        this.myProject = runConfiguration.getProject();
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myJestPackage = jestPackage;
        this.myRunSettings = runConfiguration.getRunSettings();
    }

    @Override
    @NotNull
    protected ExecutionResult executeSync(@Nullable CommandLineDebugConfigurator configurator) throws ExecutionException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myProject);
        GeneralCommandLine commandLine = NodeCommandLineUtil.createCommandLineForTestTools();
        NodeCommandLineUtil.configureCommandLine(commandLine, configurator, interpreter, (ThrowableConsumer<? super Boolean, ? extends ExecutionException>)((ThrowableConsumer)debugMode -> this.configureCommandLine(commandLine, interpreter, Boolean.TRUE.equals(debugMode))));
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, false);
        JestConsoleProperties consoleProperties = this.myRunConfiguration.createTestConsoleProperties(this.myEnvironment.getExecutor(), NodeCommandLineUtil.shouldUseTerminalConsole((ProcessHandler)processHandler));
        ConsoleView consoleView = this.createSmtRunnerConsoleView(commandLine.getWorkDirectory(), consoleProperties);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        JestUtil.emitNewLineToFlushTrailingOutput((ProcessHandler)processHandler);
        if (!NodeCommandLineUtil.isTerminalCommandLine(commandLine)) {
            JestRunProfileState.sendInput(processHandler, consoleView);
        }
        consoleView.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(consoleView, (ProcessHandler)processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        executionResult.setRestartActions(new AnAction[]{consoleProperties.createRerunFailedTestsAction(consoleView)});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            JestRunProfileState.$$$reportNull$$$0(3);
        }
        return defaultExecutionResult;
    }

    public void setFailedTests(@NotNull List<JestFailedTest> failedTests) {
        if (failedTests == null) {
            JestRunProfileState.$$$reportNull$$$0(4);
        }
        this.myFailedTests = failedTests;
    }

    @NotNull
    public JestRunSettings getRunSettings() {
        JestRunSettings jestRunSettings = this.myRunSettings;
        if (jestRunSettings == null) {
            JestRunProfileState.$$$reportNull$$$0(5);
        }
        return jestRunSettings;
    }

    private static void sendInput(final @NotNull OSProcessHandler processHandler, @NotNull ConsoleView consoleView) {
        SMTRunnerConsoleView testConsole;
        ConsoleViewImpl consoleImpl;
        Editor editor;
        if (processHandler == null) {
            JestRunProfileState.$$$reportNull$$$0(6);
        }
        if (consoleView == null) {
            JestRunProfileState.$$$reportNull$$$0(7);
        }
        if ((editor = (consoleImpl = (ConsoleViewImpl)(testConsole = (SMTRunnerConsoleView)consoleView).getConsole()).getEditor()) == null) {
            LOG.warn("Cannot send input to jest process: no editor");
            return;
        }
        final Map keyCodeMapping = ContainerUtil.newHashMap((Pair)Pair.create((Object)40, (Object)1792834), (Pair[])new Pair[]{Pair.create((Object)37, (Object)1792836), Pair.create((Object)39, (Object)1792835), Pair.create((Object)38, (Object)1792833), Pair.create((Object)8, (Object)(SystemInfo.isWindows ? 8 : 127)), Pair.create((Object)10, (Object)13), Pair.create((Object)27, (Object)27)});
        editor.getContentComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (event.getKeyChar() != '\u0000') {
                    this.sendCode(event.getKeyChar());
                }
            }

            @Override
            public void keyReleased(KeyEvent event) {
                Integer newKeyCode = (Integer)keyCodeMapping.get(event.getKeyCode());
                if (newKeyCode != null) {
                    this.sendCode(newKeyCode);
                }
            }

            private void sendCode(int keyCode) {
                if (!processHandler.isProcessTerminated()) {
                    OutputStream input = processHandler.getProcessInput();
                    try {
                        input.write(keyCode);
                        input.flush();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to send input to jest process", (Throwable)e);
                    }
                }
            }
        });
    }

    private void configureCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull NodeJsInterpreter interpreter, boolean debugMode) throws ExecutionException {
        List<String> testFilePaths;
        if (commandLine == null) {
            JestRunProfileState.$$$reportNull$$$0(8);
        }
        if (interpreter == null) {
            JestRunProfileState.$$$reportNull$$$0(9);
        }
        this.myJestVersionLazyValue.drop();
        this.myJestVersionFromDependenciesLazyValue.drop();
        if (SystemInfo.isWindows && !NodeCommandLineUtil.isTerminalCommandLine(commandLine)) {
            commandLine.withInput(JestRunProfileState.getOrCreateEmptyInputFile());
        }
        commandLine.setCharset(StandardCharsets.UTF_8);
        String workingDir = this.myRunSettings.getWorkingDirSystemDependentPath();
        if (!workingDir.isEmpty()) {
            commandLine.setWorkDirectory(workingDir);
        }
        if (!NodeCommandLineUtil.isTerminalCommandLine(commandLine)) {
            commandLine.addParameters(new String[]{"--require", HelperFilesLocator.resolvePathForExecution(STDIN_FIX)});
        }
        commandLine.addParameters(ParametersListUtil.parse((String)this.myRunSettings.getNodeOptions().trim()));
        if (this.myJestPackage instanceof YarnPnpNodePackage) {
            ((YarnPnpNodePackage)this.myJestPackage).addYarnRunToCommandLine(commandLine, this.myProject, interpreter, null);
        } else {
            commandLine.addParameter(JestUtil.getJestMainJsFile(this.myJestPackage).getAbsolutePath());
        }
        List<String> testRunnerSetupCliOptions = this.getTestRunnerSetupCliOptions();
        String packageName = this.myJestPackage.getName();
        this.myFolder.addPlaceholderText(this.myJestPackage.nameMatches("@angular/cli") ? "ng" : packageName);
        commandLine.addParameters(testRunnerSetupCliOptions);
        this.myFolder.addPlaceholderTexts(testRunnerSetupCliOptions);
        this.configureEnvironment(commandLine);
        NodeCommandLineUtil.prependNodeDirToPATH(commandLine, interpreter);
        if (!this.myRunSettings.getConfigFileSystemDependentPath().trim().isEmpty()) {
            commandLine.addParameter("--config");
            commandLine.addParameter(this.myRunSettings.getConfigFileSystemDependentPath());
            this.myFolder.addPlaceholderTexts("--config=" + PathUtil.getFileName((String)this.myRunSettings.getConfigFileSystemDependentPath()));
        }
        if (StringUtil.isNotEmpty((String)this.myRunSettings.getJestOptions())) {
            String[] options = ParametersList.parse((String)this.myRunSettings.getJestOptions());
            commandLine.addParameters(options);
            this.myFolder.addPlaceholderTexts(options);
        }
        if (debugMode) {
            commandLine.addParameter("--runInBand");
            this.myFolder.addLastParameterFrom(commandLine);
        }
        if (this.myRunConfiguration.isOptionUpdateSnapshot()) {
            commandLine.addParameter("--updateSnapshot");
            this.myFolder.addLastParameterFrom(commandLine);
            this.myRunConfiguration.clearOptionUpdateSnapshot();
        }
        commandLine.addParameter("--colors");
        SemVer jestVersion = this.getJestVersion(false);
        if (jestVersion == null || jestVersion.isGreaterOrEqualThan(20, 0, 0)) {
            commandLine.addParameter("--reporters");
            commandLine.addParameter(HelperFilesLocator.resolvePathForExecution(REPORTER));
            commandLine.addParameter("--verbose");
        } else {
            commandLine.addParameter("--testResultsProcessor");
            commandLine.addParameter(HelperFilesLocator.resolvePathForExecution(TEST_RESULTS_PROCESSOR));
        }
        JestCoverageConfigurator.configure(this.myEnvironment, commandLine);
        JestScopeKind scopeKind = this.myRunSettings.getScopeKind();
        String testNamePattern = this.getTestNamePattern(scopeKind);
        if (testNamePattern != null) {
            commandLine.addParameter("--testNamePattern=" + testNamePattern);
            JestFailedTest failedTest = (JestFailedTest)ContainerUtil.getFirstItem(this.myFailedTests);
            List<String> anyTestName = failedTest != null ? failedTest.getTestNames() : this.myRunSettings.getTestNames();
            String extra = this.myFailedTests != null && this.myFailedTests.size() > 1 ? "|..." : "";
            this.myFolder.addPlaceholderTexts("--testNamePattern=" + StringUtil.join(anyTestName, (String)" ") + extra);
        }
        if ((testFilePaths = this.getTestFilePaths(scopeKind, interpreter)) != null) {
            if (this.isRunTestsByPathSupported()) {
                commandLine.addParameter("--runTestsByPath");
                commandLine.addParameters(ContainerUtil.map(testFilePaths, path2 -> FileUtil.toSystemIndependentName((String)path2)));
            } else {
                commandLine.addParameters(new String[]{"--testPathPattern=" + JestRunProfileState.getTestFilePathPattern(testFilePaths)});
            }
            if (scopeKind == JestScopeKind.TEST_FILE) {
                this.myFolder.addPlaceholderText(PathUtil.getFileName((String)this.myRunSettings.getTestFileSystemDependentPath()));
            }
        }
    }

    @NotNull
    private List<String> getTestRunnerSetupCliOptions() {
        JestPkgInfo pkgInfo = JestPackageProvider.findJestPackageInfo(this.myJestPackage.getName());
        if (pkgInfo != null) {
            List<String> list2 = pkgInfo.getInitialTestRunnerCliOptions(this.myRunSettings);
            if (list2 == null) {
                JestRunProfileState.$$$reportNull$$$0(10);
            }
            return list2;
        }
        List<String> list3 = Collections.emptyList();
        if (list3 == null) {
            JestRunProfileState.$$$reportNull$$$0(11);
        }
        return list3;
    }

    @Nullable
    private String findContextAngularProject() {
        VirtualFile contextFile;
        AngularCliConfig config2;
        String workingDir = this.myRunSettings.getWorkingDirSystemDependentPath();
        if (FileUtil.isAbsolute((String)workingDir) && (config2 = AngularCliConfig.findProjectConfig(new File(workingDir))) != null && (contextFile = JestUtil.findContextFile(this.myRunSettings)) != null) {
            return config2.getProjectContainingFile(contextFile);
        }
        return null;
    }

    private boolean isRunTestsByPathSupported() {
        if (this.myJestPackage.nameMatches("@angular/cli")) {
            return false;
        }
        SemVer jestVersion = this.getJestVersion(true);
        return jestVersion == null || jestVersion.isGreaterOrEqualThan(22, 0, 0);
    }

    @Nullable
    private SemVer getJestVersion(boolean searchInDependencies) {
        SemVer version = (SemVer)((Ref)this.myJestVersionLazyValue.getValue()).get();
        if (version == null && searchInDependencies) {
            version = (SemVer)((Ref)this.myJestVersionFromDependenciesLazyValue.getValue()).get();
        }
        return version;
    }

    @Nullable
    private SemVer calcJestVersion() {
        return JestUtil.isJestOrJestCliPackage(this.myJestPackage.getName()) ? this.myJestPackage.getVersion(this.myProject) : null;
    }

    @Nullable
    private SemVer calcJestVersionFromDependencies() {
        ResolvedModuleInfo info;
        VirtualFile pkgRoot;
        if (JestUtil.isReactScriptsFamilyPackage(this.myJestPackage) && (pkgRoot = LocalFileSystem.getInstance().findFileByPath(this.myJestPackage.getSystemIndependentPath())) != null && (info = NodeModuleSearchUtil.resolveModuleFromNodeModulesDir(pkgRoot, "jest", NodeModuleDirectorySearchProcessor.PROCESSOR)) != null) {
            return new NodePackage(info.getModuleSourceRoot().getPath()).getVersion();
        }
        return null;
    }

    @Nullable
    private List<String> getTestFilePaths(@NotNull JestScopeKind scopeKind, @NotNull NodeJsInterpreter interpreter) {
        if (scopeKind == null) {
            JestRunProfileState.$$$reportNull$$$0(12);
        }
        if (interpreter == null) {
            JestRunProfileState.$$$reportNull$$$0(13);
        }
        if (this.myFailedTests != null) {
            List paths = ContainerUtil.map(this.myFailedTests, failedTest -> NodeInterpreterUtil.convertLocalPathToRemote(failedTest.getTestFilePath(), interpreter));
            return new ArrayList<String>(new HashSet(paths));
        }
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            String testFilePath = JestUtil.resolveFilePath(this.myRunSettings.getTestFileSystemDependentPath());
            return Collections.singletonList(NodeInterpreterUtil.convertLocalPathToRemote(testFilePath, interpreter));
        }
        return null;
    }

    @NotNull
    private static String getTestFilePathPattern(@NotNull List<String> testFilePaths) {
        if (testFilePaths == null) {
            JestRunProfileState.$$$reportNull$$$0(14);
        }
        if (testFilePaths.size() == 1) {
            String string = JestUtil.getTestFilePathPattern(testFilePaths.get(0));
            if (string == null) {
                JestRunProfileState.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = "^(" + StringUtil.join(testFilePaths, path2 -> JSTestRunnerUtil.escapeJavaScriptRegexp(path2), (String)"|") + ")$";
        if (string == null) {
            JestRunProfileState.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    private String getTestNamePattern(@NotNull JestScopeKind testKind) {
        if (testKind == null) {
            JestRunProfileState.$$$reportNull$$$0(17);
        }
        if (this.myFailedTests != null) {
            return JSTestRunnerUtil.getTestsPattern(ContainerUtil.map(this.myFailedTests, failedTest -> failedTest.getTestNames()), false);
        }
        if (JestScopeKind.SUITE == testKind || JestScopeKind.TEST == testKind) {
            return JSTestRunnerUtil.buildTestNamesPattern(this.myProject, this.myRunSettings.getTestFileSystemDependentPath(), this.myRunSettings.getTestNames(), JestScopeKind.SUITE == testKind);
        }
        return null;
    }

    @Nullable
    private static File getOrCreateEmptyInputFile() {
        File input = TEMP_INPUT_FILE;
        if (input == null || !input.isFile()) {
            try {
                input = FileUtil.createTempFile((String)"intellij-jest-empty-input", null, (boolean)true);
            }
            catch (IOException e) {
                LOG.warn("jest: cannot create temp file", (Throwable)e);
            }
            TEMP_INPUT_FILE = input;
        }
        return input;
    }

    private void configureEnvironment(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            JestRunProfileState.$$$reportNull$$$0(18);
        }
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        if (JestUtil.isReactScriptsFamilyPackage(this.myJestPackage)) {
            commandLine.getEnvironment().put("CI", "1");
        }
        if (!Registry.is((String)"jest.test.tree.use.jasmine.reporter", (boolean)true)) {
            commandLine.getEnvironment().put("_JB_INTELLIJ_JASMINE_REPORTER_DISABLED", Boolean.toString(true));
        }
    }

    @NotNull
    private ConsoleView createSmtRunnerConsoleView(@Nullable File workingDirectory, @NotNull JestConsoleProperties consoleProperties) {
        if (consoleProperties == null) {
            JestRunProfileState.$$$reportNull$$$0(19);
        }
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)consoleProperties.getTestFrameworkName(), (TestConsoleProperties)consoleProperties);
        consoleProperties.addStackTraceFilter((Filter)new NodeStackTraceFilter(this.myProject, workingDirectory));
        for (Filter filter : consoleProperties.getStackTrackFilters()) {
            consoleView.addMessageFilter(filter);
        }
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myProject, workingDirectory));
        consoleView.addMessageFilter((Filter)new JestFilter());
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            JestRunProfileState.$$$reportNull$$$0(20);
        }
        return baseTestsOutputConsoleView;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            JestRunProfileState.$$$reportNull$$$0(21);
        }
        if (processHandler == null) {
            JestRunProfileState.$$$reportNull$$$0(22);
        }
        this.myFolder.foldCommandLine(consoleView, processHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestPackage";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestRunProfileState";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedTests";
                break;
            }
            case 6: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeKind";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilePaths";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testKind";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestRunProfileState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "executeSync";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRunnerSetupCliOptions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFilePathPattern";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmtRunnerConsoleView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFailedTests";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sendInput";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureCommandLine";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTestFilePaths";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTestFilePathPattern";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamePattern";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "configureEnvironment";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createSmtRunnerConsoleView";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

