/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterTargetRunSetup;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.NullableConsumer;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class NodeJsInterpreter {
    @NotNull
    public abstract NodeJsInterpreterType<? extends NodeJsInterpreter> getType();

    @NotNull
    public abstract String getReferenceName();

    @NotNull
    @Nls
    public abstract String getPresentableName();

    @Nullable
    public abstract Ref<SemVer> getCachedVersion();

    public abstract void fetchVersion(@NotNull NullableConsumer<? super SemVer> var1);

    public void provideCachedVersionOrFetch(@NotNull NullableConsumer<SemVer> consumer) {
        Ref<SemVer> versionRef;
        if (consumer == null) {
            NodeJsInterpreter.$$$reportNull$$$0(0);
        }
        if ((versionRef = this.getCachedVersion()) != null) {
            consumer.consume((Object)((SemVer)versionRef.get()));
        } else {
            this.fetchVersion(consumer);
        }
    }

    @NotNull
    public Promise<SemVer> provideCachedVersionOrFetch() {
        Ref<SemVer> versionRef = this.getCachedVersion();
        if (versionRef != null) {
            Promise promise = Promises.resolvedPromise((Object)((SemVer)versionRef.get()));
            if (promise == null) {
                NodeJsInterpreter.$$$reportNull$$$0(1);
            }
            return promise;
        }
        AsyncPromise promise = new AsyncPromise();
        this.fetchVersion((NullableConsumer<? super SemVer>)((NullableConsumer)ver -> promise.setResult(ver)));
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            NodeJsInterpreter.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    @Nullable
    @InspectionMessage
    public abstract String validate(@Nullable Project var1);

    public boolean deepEquals(@Nullable NodeJsInterpreter other) {
        return this.equals(other);
    }

    @Deprecated
    public final String getOldPath() {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(this);
        if (localInterpreter != null) {
            return localInterpreter.getInterpreterSystemDependentPath();
        }
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast(this);
        if (remoteInterpreter != null) {
            return remoteInterpreter.getRemoteUrl();
        }
        return this.getReferenceName();
    }

    @NotNull
    public NodeJsInterpreterRef toRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create(this.getReferenceName());
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreter.$$$reportNull$$$0(3);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public NodeInterpreterTargetRunSetup createTargetRunSetup(@NotNull Project project, @NotNull NodeTargetRun.Options options) throws ExecutionException {
        if (project == null) {
            NodeJsInterpreter.$$$reportNull$$$0(4);
        }
        if (options == null) {
            NodeJsInterpreter.$$$reportNull$$$0(5);
        }
        throw new ExecutionException(JavaScriptBundle.message("node.interpreter.unavailable.target", this.getPresentableName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "provideCachedVersionOrFetch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "provideCachedVersionOrFetch";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTargetRunSetup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

