/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.remote;

import com.google.common.base.Function;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJSRemoteSdkCredentials;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJSRemoteSdkCredentialsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentialsBuilder;
import com.intellij.remote.RemoteSdkCredentialsHolder;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSRemoteSdkAdditionalData
implements RemoteSdkAdditionalData<NodeJSRemoteSdkCredentials> {
    public static final String HELPERS_DIR = ".webstorm_nodejs_helpers";
    private static final String VERSION = "VERSION";
    private static final String OUTDATED_ID = "OUTDATED_ID";
    private final RemoteConnectionCredentialsWrapper myRemoteConnectionCredentialsWrapper;
    private final RemoteSdkPropertiesHolder myRemoteSdkProperties;
    private String myVersionString;
    private String myOutdatedSdkId;

    public NodeJSRemoteSdkAdditionalData(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            NodeJSRemoteSdkAdditionalData.$$$reportNull$$$0(0);
        }
        this.myRemoteConnectionCredentialsWrapper = new RemoteConnectionCredentialsWrapper();
        this.myRemoteSdkProperties = new RemoteSdkPropertiesHolder(HELPERS_DIR);
        this.setInterpreterPath(interpreterPath);
    }

    private RemoteSdkCredentialsProducer<NodeJSRemoteSdkCredentials> getProducer() {
        NodeJSRemoteInterpreterManager manager2 = NodeJSRemoteInterpreterManager.getInstance();
        if (manager2 != null) {
            return manager2.getRemoteSdkCredentialsProducer((Function<? super RemoteCredentials, ? extends NodeJSRemoteSdkCredentials>)((Function)credentials -> this.createRemoteCredentials((RemoteCredentials)credentials)), this.myRemoteConnectionCredentialsWrapper);
        }
        throw new IllegalStateException(NodeJSRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage());
    }

    private NodeJSRemoteSdkCredentials createRemoteCredentials(RemoteCredentials credentials) {
        NodeJSRemoteSdkCredentialsHolder holder = new NodeJSRemoteSdkCredentialsHolder(this.myRemoteSdkProperties);
        RemoteSdkCredentialsBuilder.copyCredentials((RemoteCredentials)credentials, (MutableRemoteCredentials)holder);
        return holder;
    }

    public String getInterpreterPath() {
        return this.myRemoteSdkProperties.getInterpreterPath();
    }

    public void setInterpreterPath(String interpreterPath) {
        this.myRemoteSdkProperties.setInterpreterPath(interpreterPath);
    }

    public String getHelpersPath() {
        return this.myRemoteSdkProperties.getHelpersPath();
    }

    public void setHelpersPath(String helpersPath) {
        this.myRemoteSdkProperties.setHelpersPath(helpersPath);
    }

    public String getDefaultHelpersName() {
        return this.myRemoteSdkProperties.getDefaultHelpersName();
    }

    @NotNull
    public PathMappingSettings getPathMappings() {
        PathMappingSettings pathMappingSettings = this.myRemoteSdkProperties.getPathMappings();
        if (pathMappingSettings == null) {
            NodeJSRemoteSdkAdditionalData.$$$reportNull$$$0(1);
        }
        return pathMappingSettings;
    }

    public void setPathMappings(@Nullable PathMappingSettings pathMappings) {
        this.myRemoteSdkProperties.setPathMappings(pathMappings);
    }

    public boolean isHelpersVersionChecked() {
        return this.myRemoteSdkProperties.isHelpersVersionChecked();
    }

    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myRemoteSdkProperties.setHelpersVersionChecked(helpersVersionChecked);
    }

    public void setSdkId(String sdkId) {
        throw new IllegalStateException("sdkId in this class is constructed based on fields, so it can't be set");
    }

    public String getSdkId() {
        return FileUtil.toSystemIndependentName((String)(this.myRemoteConnectionCredentialsWrapper.getId() + this.myRemoteSdkProperties.getInterpreterPath()));
    }

    @Nullable
    public String getOutdatedSdkId() {
        return this.myOutdatedSdkId;
    }

    public boolean isInitialized() {
        return this.myRemoteSdkProperties.isInitialized();
    }

    public void setInitialized(boolean initialized) {
        this.myRemoteSdkProperties.setInitialized(initialized);
    }

    public boolean isValid() {
        return this.myRemoteSdkProperties.isValid();
    }

    public void setValid(boolean valid) {
        this.myRemoteSdkProperties.setValid(valid);
    }

    public boolean isRunAsRootViaSudo() {
        return this.myRemoteSdkProperties.isRunAsRootViaSudo();
    }

    public void setRunAsRootViaSudo(boolean runAsRootViaSudo) {
        this.myRemoteSdkProperties.setRunAsRootViaSudo(runAsRootViaSudo);
    }

    public RemoteConnectionCredentialsWrapper connectionCredentials() {
        return this.myRemoteConnectionCredentialsWrapper;
    }

    public NodeJSRemoteSdkCredentials getRemoteSdkCredentials() throws InterruptedException, ExecutionException {
        return (NodeJSRemoteSdkCredentials)this.getProducer().getRemoteSdkCredentials();
    }

    public NodeJSRemoteSdkCredentials getRemoteSdkCredentials(boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return (NodeJSRemoteSdkCredentials)this.getProducer().getRemoteSdkCredentials(allowSynchronousInteraction);
    }

    public NodeJSRemoteSdkCredentials getRemoteSdkCredentials(@Nullable Project project, boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return (NodeJSRemoteSdkCredentials)this.getProducer().getRemoteSdkCredentials(allowSynchronousInteraction);
    }

    public void produceRemoteSdkCredentials(boolean allowSynchronousInteraction, Consumer<? super NodeJSRemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        this.getProducer().produceRemoteSdkCredentials(allowSynchronousInteraction, remoteSdkCredentialsConsumer);
    }

    public void produceRemoteSdkCredentials(@Nullable Project project, boolean allowSynchronousInteraction, Consumer<? super NodeJSRemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        this.getProducer().produceRemoteSdkCredentials(allowSynchronousInteraction, remoteSdkCredentialsConsumer);
    }

    public void produceRemoteSdkCredentials(Consumer<? super NodeJSRemoteSdkCredentials> remoteSdkCredentialsConsumer) {
        this.getProducer().produceRemoteSdkCredentials(remoteSdkCredentialsConsumer);
    }

    public Object getRemoteSdkDataKey() {
        return this.myRemoteConnectionCredentialsWrapper.getConnectionKey();
    }

    public void save(Element rootElement) {
        this.myRemoteSdkProperties.save(rootElement);
        rootElement.setAttribute(VERSION, StringUtil.notNullize((String)this.getVersionString()));
        rootElement.setAttribute(OUTDATED_ID, StringUtil.notNullize((String)this.getOutdatedSdkId()));
        this.myRemoteConnectionCredentialsWrapper.save(rootElement);
    }

    public static NodeJSRemoteSdkAdditionalData load(@Nullable Element element, @NotNull String interpreterPath) {
        if (interpreterPath == null) {
            NodeJSRemoteSdkAdditionalData.$$$reportNull$$$0(2);
        }
        String fullPath = RemoteSdkCredentialsHolder.getInterpreterPathFromFullPath((String)interpreterPath);
        NodeJSRemoteSdkAdditionalData data = new NodeJSRemoteSdkAdditionalData(fullPath);
        if (element != null) {
            CredentialsManager.getInstance().loadCredentials(interpreterPath, element, (RemoteSdkAdditionalData)data);
            data.myOutdatedSdkId = StringUtil.nullize((String)element.getAttributeValue(OUTDATED_ID));
            if (data.myOutdatedSdkId == null) {
                data.myOutdatedSdkId = data.getSdkId();
                CredentialsManager.updateOutdatedSdk((RemoteSdkAdditionalData)data, null);
                NodeJSRemoteInterpreterManager manager2 = NodeJSRemoteInterpreterManager.getInstance();
                if (manager2 != null) {
                    manager2.loadFullyCredentials(data);
                }
                if (data.getSdkId().equals(data.myOutdatedSdkId)) {
                    data.myOutdatedSdkId = null;
                }
            }
            data.myRemoteSdkProperties.load(element);
            data.setVersionString(StringUtil.notNullize((String)element.getAttributeValue(VERSION)));
        }
        return data;
    }

    public <C> void setCredentials(Key<C> key, C credentials) {
        this.myRemoteConnectionCredentialsWrapper.setCredentials(key, credentials);
    }

    public CredentialsType getRemoteConnectionType() {
        return this.myRemoteConnectionCredentialsWrapper.getRemoteConnectionType();
    }

    public void switchOnConnectionType(CredentialsCase ... cases2) {
        this.myRemoteConnectionCredentialsWrapper.switchType(cases2);
    }

    public String getVersionString() {
        return this.myVersionString;
    }

    public void setVersionString(String versionString) {
        this.myVersionString = versionString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJSRemoteSdkAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJSRemoteSdkAdditionalData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

