/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesIndexingRulesProvider;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.NodeModulesIndexableFileNamesProvider;
import com.intellij.lang.typescript.psi.TypeScriptExcludeUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeModulesLibraryDirectory {
    private static final Logger LOG = Logger.getInstance(NodeModulesLibraryDirectory.class);
    private static final Set<String> BUILD_DIR_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"dist", "build", "built"});
    public static final RegistryValue INDEX_DIRECT_DEPS_SYMLINKS = Registry.get((String)"node_modules.index.direct.dependency.symlink");
    private final Project myProject;
    private final VirtualFile myNodeModulesDir;
    private final String myLibraryName;
    private final AtomicInteger myLibraryCalcCount;
    private final NodeModulesIndexingRulesProvider myNodeModulesIndexingRulesProvider;
    private volatile SyntheticLibrary myLibrary;
    @Nullable
    private NodeModulesLibraryDirectory myWorkspaceRoot;
    private final List<VirtualFile> myChildWorkspaceRoots;
    private final NodeModulesDirectoryManager myDirectoryManager;

    public NodeModulesLibraryDirectory(@NotNull NodeModulesDirectoryManager directoryManager, @NotNull VirtualFile nodeModulesDir, @NotNull String libraryName) {
        if (directoryManager == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(0);
        }
        if (nodeModulesDir == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(2);
        }
        this.myLibraryCalcCount = new AtomicInteger(0);
        this.myChildWorkspaceRoots = new ArrayList<VirtualFile>();
        this.myProject = directoryManager.getProject();
        this.myDirectoryManager = directoryManager;
        this.myNodeModulesDir = nodeModulesDir;
        this.myLibraryName = libraryName;
        this.myNodeModulesIndexingRulesProvider = NodeModulesIndexingRulesProvider.Companion.getManager(directoryManager.getProject());
    }

    @NotNull
    public VirtualFile getNodeModulesDir() {
        VirtualFile virtualFile = this.myNodeModulesDir;
        if (virtualFile == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    public boolean isForApplicationSourceCode() {
        return this.myDirectoryManager.getChecker().isForApplicationSourceCode(this.myNodeModulesDir);
    }

    @Nullable
    static VirtualFile findChild(@Nullable VirtualFile parent, @NotNull String childName, boolean directory) {
        if (childName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(4);
        }
        VirtualFile child = parent != null ? parent.findChild(childName) : null;
        return child != null && child.isValid() && child.isDirectory() == directory ? child : null;
    }

    void setWorkspaceRoot(@Nullable NodeModulesLibraryDirectory workspaceRoot) {
        this.myWorkspaceRoot = workspaceRoot;
    }

    @NotNull
    public String getLibraryName() {
        String string = this.myLibraryName;
        if (string == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void invalidateRoots() {
        this.myLibrary = null;
        this.myLibraryCalcCount.set(0);
    }

    @NotNull
    public SyntheticLibrary getLibrary() {
        SyntheticLibrary library = this.myLibrary;
        if (library == null) {
            this.myLibrary = library = this.createLibrary();
        }
        SyntheticLibrary syntheticLibrary = library;
        if (syntheticLibrary == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(6);
        }
        return syntheticLibrary;
    }

    @NotNull
    private SyntheticLibrary createLibrary() {
        int calcCount = this.myLibraryCalcCount.incrementAndGet();
        if (calcCount > 1) {
            LOG.debug("Concurrent node_modules roots calculation: " + calcCount);
        }
        return this.doCreateLibrary();
    }

    @NotNull
    private SyntheticLibrary doCreateLibrary() {
        Set<VirtualFile> roots;
        if (!this.myNodeModulesDir.isValid()) {
            LOG.warn("Invalid " + this.myNodeModulesDir.getPath());
            SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(Collections.emptyList());
            if (syntheticLibrary == null) {
                NodeModulesLibraryDirectory.$$$reportNull$$$0(7);
            }
            return syntheticLibrary;
        }
        VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(this.myNodeModulesDir);
        if (packageJson != null && packageJson.isValid()) {
            PackageJsonFiles packageJsonFiles = new PackageJsonFiles(this.myProject, packageJson, this.myChildWorkspaceRoots);
            roots = this.getIndexableModuleRoots(packageJsonFiles);
            for (Pair<VirtualFile, PackageJsonData> pair : packageJsonFiles.myList) {
                this.myDirectoryManager.setProvidedPackageJsonRoots((VirtualFile)pair.first, (PackageJsonData)pair.second);
            }
        } else {
            roots = new HashSet<VirtualFile>();
        }
        HashSet<VirtualFile> directRoots = new HashSet<VirtualFile>(roots);
        Set<VirtualFile> tsOnlyRoots = this.collectTsOnlyRoots(roots);
        roots.addAll(tsOnlyRoots);
        HashSet excludedRoots = new HashSet();
        roots.forEach(root -> this.collectExcludedRoots((VirtualFile)root, excludedRoots));
        SyntheticLibrary syntheticLibrary = SyntheticLibrary.newImmutableLibrary(new ArrayList<VirtualFile>(roots), excludedRoots, NodeModulesLibraryDirectory.getExcludeConditionForNonTsSources(roots, directRoots, tsOnlyRoots));
        if (syntheticLibrary == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(8);
        }
        return syntheticLibrary;
    }

    @NotNull
    private Set<VirtualFile> getIndexableModuleRoots(@NotNull PackageJsonFiles packageJsonFiles) {
        if (packageJsonFiles == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(9);
        }
        List indexableDependencies = ContainerUtil.filter(packageJsonFiles.getAllDependencies(), this::isDependencyIndexed);
        VirtualFile types2 = NodeModulesLibraryDirectory.findChild(this.myNodeModulesDir, "@types", true);
        if (types2 == null) {
            return this.toRootFiles(indexableDependencies);
        }
        List typesChildren = ((StreamEx)StreamEx.of((Object[])types2.getChildren()).filter(VirtualFile::isValid)).toList();
        Set typesDependencies = StreamEx.of((Collection)typesChildren).map(module -> this.getPackageJsonDataForDependency(NodeModulesLibraryDirectory.findPackageJsonForDependency(module))).nonNull().flatMap(data -> data.getAllDependencies().stream()).toSet();
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        result2.addAll(this.toRootFiles(indexableDependencies));
        result2.addAll(this.toRootFiles(typesDependencies));
        result2.addAll(StreamEx.of((Collection)typesChildren).map(dep -> this.getDependencyToIndex((VirtualFile)dep)).nonNull().toList());
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    private Set<VirtualFile> toRootFiles(@NotNull Collection<String> dependencies) {
        if (dependencies == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(11);
        }
        Set set = ((StreamEx)StreamEx.of(dependencies).map(this::getRootForDependency).nonNull().filter(el -> el.isValid() && el.isDirectory())).toSet();
        if (set == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Nullable
    private VirtualFile getRootForDependency(@NotNull String dependency) {
        VirtualFile rootForDependency;
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(13);
        }
        if ((rootForDependency = this.getRootForDependency(dependency, this.myNodeModulesDir)) != null) {
            return rootForDependency;
        }
        if (this.myWorkspaceRoot != null) {
            return this.myWorkspaceRoot.getNodeModulesDir().findFileByRelativePath(dependency);
        }
        return null;
    }

    @Nullable
    private VirtualFile getRootForDependency(@NotNull String dependency, @NotNull VirtualFile nodeModulesDir) {
        VirtualFile dir;
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(14);
        }
        if (nodeModulesDir == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(15);
        }
        if ((dir = NodeModulesLibraryDirectory.findDescendantFileByRelativePath(nodeModulesDir, dependency)) != null && dir.isValid() && dir.isDirectory()) {
            return this.getDependencyToIndex(dir);
        }
        return null;
    }

    @Nullable
    private VirtualFile getDependencyToIndex(@NotNull VirtualFile dependencyRoot) {
        if (dependencyRoot == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(16);
        }
        if (!dependencyRoot.is(VFileProperty.SYMLINK)) {
            return dependencyRoot;
        }
        if (INDEX_DIRECT_DEPS_SYMLINKS.asBoolean()) {
            return dependencyRoot;
        }
        VirtualFile target = dependencyRoot.getCanonicalFile();
        if (target == null) {
            return dependencyRoot;
        }
        if (NodeModuleSearchUtil.findAncestorNodeModulesDir(target) != null) {
            return target;
        }
        if (this.myDirectoryManager.isUnderContentRoots(target)) {
            return null;
        }
        return target;
    }

    @Nullable
    private static VirtualFile findDescendantFileByRelativePath(@NotNull VirtualFile root, @NotNull String relPath) {
        String name;
        VirtualFile result2;
        if (root == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(17);
        }
        if (relPath == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(18);
        }
        int offset = 0;
        for (result2 = root; result2 != null && offset < relPath.length(); result2 = result2.findChild(name)) {
            int separatorInd = relPath.indexOf(47, offset + 1);
            if (separatorInd < 0) {
                separatorInd = relPath.length();
            }
            name = relPath.substring(offset, separatorInd);
            offset = separatorInd + 1;
        }
        return root.equals(result2) ? null : result2;
    }

    @Nullable
    private static VirtualFile getParentNodeModules(@NotNull VirtualFile root) {
        VirtualFile parent;
        if (root == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(19);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(parent = root.getParent())) {
            return parent;
        }
        VirtualFile superParent = parent != null ? parent.getParent() : null;
        return NodeModulesDirectoryManager.isNodeModulesDir(superParent) ? superParent : null;
    }

    @NotNull
    private Set<VirtualFile> collectTsOnlyRoots(@NotNull Set<VirtualFile> roots) {
        if (roots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(20);
        }
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        boolean isExcludingJSSourceEnabled = TypeScriptExcludeUtil.isExcludingJSSourcesEnabled();
        HashSet<Pair> directDependencies = new HashSet<Pair>();
        HashSet<Pair> queuedDependencies = new HashSet<Pair>();
        for (VirtualFile virtualFile : roots) {
            String dependencyName;
            VirtualFile packageJson;
            PackageJsonData dependency2;
            if (NodeModuleUtil.isTypesDir(virtualFile) || (dependency2 = this.getPackageJsonDataForDependency(packageJson = NodeModulesLibraryDirectory.findPackageJsonForDependency(virtualFile))) == null || (dependencyName = NodeModulesLibraryDirectory.getPackageName(dependency2)) == null) continue;
            VirtualFile nodeModules = NodeModulesLibraryDirectory.getParentNodeModules(virtualFile);
            directDependencies.add(Pair.create((Object)dependencyName, (Object)nodeModules));
            if (dependency2.hasTypings()) {
                for (String anyDependency : dependency2.getAllDependencies()) {
                    queuedDependencies.add(Pair.create((Object)anyDependency, (Object)nodeModules));
                }
            }
            for (String additionalDependency : this.myNodeModulesIndexingRulesProvider.getAdditionalInclusions(dependencyName)) {
                queuedDependencies.add(Pair.create((Object)additionalDependency, (Object)nodeModules));
            }
            if (!isExcludingJSSourceEnabled || !TypeScriptExcludeUtil.arePackageSourcesExcluded(this.myProject, dependency2)) continue;
            result2.add(virtualFile);
        }
        Stack stack = new Stack();
        for (Pair dependencyPair : queuedDependencies) {
            String dependency2 = (String)dependencyPair.getFirst();
            if (directDependencies.contains(dependencyPair) || this.myNodeModulesIndexingRulesProvider.isIndirectDependencyExcluded(dependency2)) continue;
            stack.add((Object)dependencyPair);
        }
        queuedDependencies.addAll(directDependencies);
        while (!stack.isEmpty()) {
            PackageJsonData dependencyPackageJsonData;
            String packageName;
            VirtualFile packageJson;
            Pair pair = (Pair)stack.pop();
            String dependencyName = (String)pair.getFirst();
            VirtualFile root = this.getDirectOrSymlinkedRoot(dependencyName, (VirtualFile)pair.getSecond());
            if (root == null || !root.isValid() || !root.isDirectory() || (packageJson = NodeModulesLibraryDirectory.findPackageJsonForDependency(root)) == null || (packageName = NodeModulesLibraryDirectory.getPackageName(dependencyPackageJsonData = this.getPackageJsonDataForDependency(packageJson))) == null) continue;
            VirtualFile nodeModules = NodeModulesLibraryDirectory.getParentNodeModules(root);
            this.myNodeModulesIndexingRulesProvider.getAdditionalInclusions(packageName).forEach(dependency -> {
                Pair nameWithNodeModules = Pair.create((Object)dependency, (Object)nodeModules);
                if (queuedDependencies.add(nameWithNodeModules)) {
                    stack.add((Object)nameWithNodeModules);
                }
            });
            if (!dependencyPackageJsonData.hasTypings()) continue;
            if (!packageName.startsWith("@types/")) {
                result2.add(root);
            }
            for (String name : dependencyPackageJsonData.getAllDependencies()) {
                Pair nameWithNodeModules = Pair.create((Object)name, (Object)nodeModules);
                if (this.myNodeModulesIndexingRulesProvider.isIndirectDependencyExcluded(name) || !queuedDependencies.add(nameWithNodeModules)) continue;
                stack.add((Object)nameWithNodeModules);
            }
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    @Nullable
    private VirtualFile getDirectOrSymlinkedRoot(@NotNull String dependencyName, @Nullable VirtualFile nodeModules) {
        VirtualFile root;
        if (dependencyName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(22);
        }
        if ((root = this.getRootForDependency(dependencyName)) == null || !root.isValid() || !root.isDirectory()) {
            if (nodeModules != null && !nodeModules.equals(this.myNodeModulesDir)) {
                return this.getRootForDependency(dependencyName, nodeModules);
            }
            return null;
        }
        return root;
    }

    @Nullable
    private static String getPackageName(@NotNull PackageJsonData packageJsonData) {
        String packageName;
        if (packageJsonData == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(23);
        }
        if ((packageName = packageJsonData.getName()) != null) {
            return packageName;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Name property missing in " + packageJsonData.getPackageJsonFile().getPath());
        }
        return null;
    }

    @NotNull
    private static Condition<VirtualFile> getExcludeConditionForNonTsSources(@NotNull Set<VirtualFile> allRoots, @NotNull Set<VirtualFile> directRoots, @NotNull Set<VirtualFile> typingRoots) {
        if (allRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(24);
        }
        if (directRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(25);
        }
        if (typingRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(26);
        }
        Condition condition = file2 -> {
            VirtualFile parent;
            if (file2.isDirectory()) {
                return NodeModulesDirectoryManager.isNodeModulesDir(file2);
            }
            for (parent = file2.getParent(); parent != null && !allRoots.contains(parent); parent = parent.getParent()) {
            }
            if (parent == null) {
                return false;
            }
            if (typingRoots.contains(parent)) {
                return !NodeModulesIndexableFileNamesProvider.isIndexableFileName(file2.getNameSequence(), directRoots.contains(parent) ? NodeModulesIndexableFileNamesProvider.DependencyKind.DIRECT_TYPINGS : NodeModulesIndexableFileNamesProvider.DependencyKind.INDIRECT_TYPINGS);
            }
            return !NodeModulesIndexableFileNamesProvider.isIndexableFileName(file2.getNameSequence(), NodeModulesIndexableFileNamesProvider.DependencyKind.DIRECT);
        };
        if (condition == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(27);
        }
        return condition;
    }

    void addChildWorkspace(@NotNull VirtualFile childWorkspaceRoot) {
        if (childWorkspaceRoot == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(28);
        }
        this.myChildWorkspaceRoots.add(childWorkspaceRoot);
    }

    private void collectExcludedRoots(@NotNull VirtualFile dependency, @NotNull Set<? super VirtualFile> excludedRoots) {
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(29);
        }
        if (excludedRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(30);
        }
        PackageJsonData dependencyPackageJsonData = this.getPackageJsonDataForDependency(NodeModulesLibraryDirectory.findPackageJsonForDependency(dependency));
        for (String name2 : BUILD_DIR_NAMES) {
            boolean shouldIndexDist;
            VirtualFile child = dependency.findChild(name2);
            if (child == null || !child.isDirectory() || (shouldIndexDist = dependencyPackageJsonData != null && (NodeModulesLibraryDirectory.isMainResolvedInsideFolder(dependencyPackageJsonData, name2) || dependencyPackageJsonData.hasTypings()))) continue;
            excludedRoots.add((VirtualFile)child);
        }
        ((StreamEx)StreamEx.of(this.myNodeModulesIndexingRulesProvider.getExcludedDirs(dependencyPackageJsonData == null ? null : dependencyPackageJsonData.getName())).map(name -> NodeModulesLibraryDirectory.findDescendantFileByRelativePath(dependency, name)).nonNull().filter(VirtualFile::isDirectory)).into(excludedRoots);
        if (dependencyPackageJsonData != null) {
            NodeModulesLibraryDirectory.collectExcludedAdditionalMainFiles(dependency, dependencyPackageJsonData, excludedRoots);
        }
    }

    private static boolean isMainResolvedInsideFolder(@NotNull PackageJsonData packageJsonData, @NotNull String folderName) {
        String jsNextMain;
        if (packageJsonData == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(31);
        }
        if (folderName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(32);
        }
        if ((jsNextMain = packageJsonData.getJsNextMain()) != null && NodeModulesLibraryDirectory.startsWithFolder(jsNextMain, folderName)) {
            return true;
        }
        String main = packageJsonData.getMain();
        return main != null && !main.equals(jsNextMain) && NodeModulesLibraryDirectory.startsWithFolder(main, folderName);
    }

    private static boolean startsWithFolder(@NotNull String path2, @NotNull String folderName) {
        if (path2 == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(33);
        }
        if (folderName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(34);
        }
        path2 = FileUtil.toSystemIndependentName((String)path2);
        int startInd = 0;
        if (path2.startsWith("./")) {
            startInd += 2;
        }
        if (StringUtil.startsWith((CharSequence)path2, (int)startInd, (CharSequence)folderName)) {
            if (folderName.length() + startInd == path2.length()) {
                return true;
            }
            return path2.charAt(startInd + folderName.length()) == '/';
        }
        return false;
    }

    @Contract(value="!null -> !null; null -> null")
    private PackageJsonData getPackageJsonDataForDependency(@Nullable VirtualFile dependencyPackageJson) {
        if (dependencyPackageJson == null) {
            return null;
        }
        return PackageJsonData.getOrCreateWithPreferredProject(this.myProject, dependencyPackageJson);
    }

    @Nullable
    private static VirtualFile findPackageJsonForDependency(@NotNull VirtualFile dependency) {
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(35);
        }
        return PackageJsonUtil.findChildPackageJsonFile(dependency);
    }

    private static void collectExcludedAdditionalMainFiles(@NotNull VirtualFile dependency, @NotNull PackageJsonData dependencyPackageJsonData, @NotNull Set<? super VirtualFile> excludedRoots) {
        Collection<String> additionalMainPaths;
        if (dependency == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(36);
        }
        if (dependencyPackageJsonData == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(37);
        }
        if (excludedRoots == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(38);
        }
        if ((additionalMainPaths = dependencyPackageJsonData.getAdditionalMains()).isEmpty()) {
            return;
        }
        String preferableMainFile = dependencyPackageJsonData.getJsNextMain();
        if (preferableMainFile == null) {
            preferableMainFile = dependencyPackageJsonData.getMain();
        }
        if (preferableMainFile == null) {
            return;
        }
        VirtualFile defaultFile = NodeModuleSearchUtil.findMainModuleByPath(dependency, preferableMainFile);
        if (defaultFile == null) {
            return;
        }
        ArrayList<String> modules2 = new ArrayList<String>(additionalMainPaths.size() + 1);
        String main = dependencyPackageJsonData.getMain();
        if (main != null) {
            modules2.add(main);
        }
        modules2.addAll(additionalMainPaths);
        for (String mainToExclude : modules2) {
            VirtualFile candidateFile;
            if (preferableMainFile.equals(mainToExclude) || StringUtil.isEmptyOrSpaces((String)mainToExclude) || (candidateFile = NodeModuleSearchUtil.findMainModuleByPath(dependency, mainToExclude)) == null || defaultFile.equals(candidateFile) || candidateFile.isDirectory()) continue;
            excludedRoots.add((VirtualFile)candidateFile);
        }
    }

    public boolean isDependencyIndexed(@NotNull String dependencyName) {
        if (dependencyName == null) {
            NodeModulesLibraryDirectory.$$$reportNull$$$0(39);
        }
        return this.myNodeModulesIndexingRulesProvider.isDependencyIndexed(dependencyName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 21: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 21: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryManager";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 13: 
            case 14: 
            case 29: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyRoot";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 22: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 23: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonData";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directRoots";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typingRoots";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childWorkspaceRoot";
                break;
            }
            case 30: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRoots";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyPackageJsonData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModulesDir";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrary";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateLibrary";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableModuleRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toRootFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTsOnlyRoots";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeConditionForNonTsSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 21: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndexableModuleRoots";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toRootFiles";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRootForDependency";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyToIndex";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findDescendantFileByRelativePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParentNodeModules";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectTsOnlyRoots";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDirectOrSymlinkedRoot";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeConditionForNonTsSources";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addChildWorkspace";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectExcludedRoots";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isMainResolvedInsideFolder";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "startsWithFolder";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findPackageJsonForDependency";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "collectExcludedAdditionalMainFiles";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyIndexed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 21: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PackageJsonFiles {
        private final List<Pair<VirtualFile, PackageJsonData>> myList;

        private PackageJsonFiles(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull List<VirtualFile> childWorkspaceRoots) {
            if (project == null) {
                PackageJsonFiles.$$$reportNull$$$0(0);
            }
            if (packageJson == null) {
                PackageJsonFiles.$$$reportNull$$$0(1);
            }
            if (childWorkspaceRoots == null) {
                PackageJsonFiles.$$$reportNull$$$0(2);
            }
            ArrayList<VirtualFile> packageJsonFiles = new ArrayList<VirtualFile>(1 + childWorkspaceRoots.size());
            packageJsonFiles.add(packageJson);
            for (VirtualFile workspaceRoot : childWorkspaceRoots) {
                if (!workspaceRoot.isValid()) continue;
                ContainerUtil.addIfNotNull(packageJsonFiles, (Object)PackageJsonUtil.findChildPackageJsonFile(workspaceRoot));
            }
            this.myList = ContainerUtil.map(packageJsonFiles, file2 -> (Pair)ProjectLocator.computeWithPreferredProject((VirtualFile)file2, (Project)project, () -> Pair.create((Object)file2, (Object)PackageJsonData.getOrCreate(file2))));
        }

        @NotNull
        public Set<String> getAllDependencies() {
            if (this.myList.size() == 1) {
                Set<String> set = ((PackageJsonData)this.myList.get((int)0).second).getAllDependencies();
                if (set == null) {
                    PackageJsonFiles.$$$reportNull$$$0(3);
                }
                return set;
            }
            HashSet<String> dependencies = new HashSet<String>();
            for (Pair<VirtualFile, PackageJsonData> pair : this.myList) {
                dependencies.addAll(((PackageJsonData)pair.second).getAllDependencies());
            }
            HashSet<String> hashSet = dependencies;
            if (hashSet == null) {
                PackageJsonFiles.$$$reportNull$$$0(4);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJson";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childWorkspaceRoots";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory$PackageJsonFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesLibraryDirectory$PackageJsonFiles";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

