/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpWorkspace;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpWorkspaceList {
    private static final Logger LOG = Logger.getInstance(YarnPnpWorkspaceList.class);
    private final ImmutableList<YarnPnpWorkspace> myWorkspaces;
    private final boolean myVirtualResolved;
    private final ImmutableMap<VirtualFile, YarnPnpWorkspace> myLocationDirToWorkspaceMap;
    private final ImmutableMap<String, YarnPnpWorkspace> myLocationToWorkspaceMap;

    private YarnPnpWorkspaceList(@NotNull ImmutableList<YarnPnpWorkspace> workspaces, boolean virtualResolved) {
        if (workspaces == null) {
            YarnPnpWorkspaceList.$$$reportNull$$$0(0);
        }
        this.myWorkspaces = workspaces;
        this.myVirtualResolved = virtualResolved;
        for (YarnPnpWorkspace workspace2 : workspaces) {
            workspace2.setWorkspaceList(this);
        }
        this.myLocationDirToWorkspaceMap = ImmutableMap.copyOf((Map)ContainerUtil.map2MapNotNull(workspaces, workspace -> {
            VirtualFile location = LocalFileSystem.getInstance().findFileByPath(workspace.getLocation());
            if (location == null) {
                LOG.info("Cannot find workspace location: " + workspace.getLocation());
                return null;
            }
            return Pair.create((Object)location, (Object)workspace);
        }));
        this.myLocationToWorkspaceMap = ImmutableMap.copyOf((Map)ContainerUtil.map2MapNotNull(workspaces, workspace -> Pair.create((Object)workspace.getLocation(), (Object)workspace)));
    }

    @NotNull
    public ImmutableList<YarnPnpWorkspace> getWorkspaces() {
        ImmutableList<YarnPnpWorkspace> immutableList = this.myWorkspaces;
        if (immutableList == null) {
            YarnPnpWorkspaceList.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    public boolean isVirtualResolved() {
        return this.myVirtualResolved;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        YarnPnpWorkspaceList list2 = (YarnPnpWorkspaceList)o;
        return this.myWorkspaces.equals(list2.myWorkspaces);
    }

    public int hashCode() {
        return Objects.hash(this.myWorkspaces);
    }

    @Nullable
    public YarnPnpWorkspace findWorkspaceByFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            YarnPnpWorkspaceList.$$$reportNull$$$0(2);
        }
        if (this.myLocationDirToWorkspaceMap.isEmpty()) {
            return null;
        }
        for (VirtualFile dir = file2; dir != null; dir = dir.getParent()) {
            YarnPnpWorkspace workspace = (YarnPnpWorkspace)this.myLocationDirToWorkspaceMap.get((Object)dir);
            if (workspace == null) continue;
            return workspace;
        }
        return null;
    }

    public boolean isWorkspaceLocation(@NotNull String location) {
        if (location == null) {
            YarnPnpWorkspaceList.$$$reportNull$$$0(3);
        }
        return this.myLocationToWorkspaceMap.containsKey((Object)location);
    }

    public void calcLibraryNames(@NotNull Project project) {
        if (project == null) {
            YarnPnpWorkspaceList.$$$reportNull$$$0(4);
        }
        for (YarnPnpWorkspace workspace : this.myWorkspaces) {
            workspace.calcLibraryName(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaces";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpWorkspaceList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpWorkspaceList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findWorkspaceByFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isWorkspaceLocation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcLibraryNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private final TreeMap<String, YarnPnpWorkspace> myWorkspaces = new TreeMap();
        private boolean myVirtualResolved;

        public void add(@NotNull YarnPnpWorkspace workspace) {
            if (workspace == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myWorkspaces.put(workspace.getLocation(), workspace);
        }

        public void setVirtualResolved(boolean virtualResolved) {
            this.myVirtualResolved = virtualResolved;
        }

        @NotNull
        public YarnPnpWorkspaceList build() {
            return new YarnPnpWorkspaceList((ImmutableList<YarnPnpWorkspace>)ImmutableList.copyOf(this.myWorkspaces.values()), this.myVirtualResolved);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "com/intellij/javascript/nodejs/library/yarn/YarnPnpWorkspaceList$Builder", "add"));
        }
    }
}

