/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.reference;

import com.google.common.base.Splitter;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.env.DotEnvFileManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePathManager {
    public static final String NODE_PATH = "NODE_PATH";
    private static final char NODE_PATH_SEPARATOR = (char)(SystemInfo.isWindows ? 59 : 58);
    private final Project myProject;
    private volatile Pair<NodePathData, List<VirtualFile>> myCache;

    public NodePathManager(@NotNull Project project) {
        if (project == null) {
            NodePathManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public List<VirtualFile> getNodePaths(@Nullable VirtualFile contextFile) {
        NodePathData nodePathData = this.findNodePathData(contextFile);
        if (nodePathData == null) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                NodePathManager.$$$reportNull$$$0(1);
            }
            return list2;
        }
        Pair cache2 = this.myCache;
        if (cache2 != null && nodePathData.equals(cache2.first)) {
            List list3 = (List)cache2.second;
            if (list3 == null) {
                NodePathManager.$$$reportNull$$$0(2);
            }
            return list3;
        }
        List<VirtualFile> paths = NodePathManager.parsePathsFromNodePathEnvVariable(nodePathData);
        this.myCache = cache2 = Pair.create((Object)nodePathData, paths);
        List<VirtualFile> list4 = paths;
        if (list4 == null) {
            NodePathManager.$$$reportNull$$$0(3);
        }
        return list4;
    }

    @Nullable
    private NodePathData findNodePathData(@Nullable VirtualFile contextFileOrDir) {
        NodePathData nodePath;
        NodeRunConfigurationNodePathProvider service;
        DotEnvFileManager envFileManager = DotEnvFileManager.getInstance(this.myProject);
        if (contextFileOrDir != null) {
            List<DotEnvFileManager.EnvFileData> envFileDataList = envFileManager.findEnvs(contextFileOrDir);
            for (DotEnvFileManager.EnvFileData envFileData : envFileDataList) {
                String nodePathValue = envFileData.getEnvs().get(NODE_PATH);
                if (nodePathValue == null) continue;
                return new NodePathData(nodePathValue, envFileData.getEnvFile());
            }
        }
        if ((service = NodeRunConfigurationNodePathProvider.getInstance(this.myProject)) != null && (nodePath = service.getNodePathData()) != null) {
            return nodePath;
        }
        String value = EnvironmentUtil.getValue((String)NODE_PATH);
        if (value != null) {
            return new NodePathData(value, null);
        }
        return null;
    }

    @NotNull
    private static List<VirtualFile> parsePathsFromNodePathEnvVariable(@NotNull NodePathData nodePathData) {
        if (nodePathData == null) {
            NodePathManager.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)nodePathData.myNodePathValue)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                NodePathManager.$$$reportNull$$$0(5);
            }
            return list2;
        }
        Iterable res = Splitter.on((char)NODE_PATH_SEPARATOR).split((CharSequence)nodePathData.myNodePathValue);
        VirtualFile contextDir = nodePathData.myContextFileOrDir;
        if (contextDir != null && !contextDir.isDirectory()) {
            contextDir = contextDir.getParent();
        }
        ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (String dirPath : res) {
            if (!StringUtil.isNotEmpty((String)dirPath)) continue;
            VirtualFile dir = null;
            if (OSAgnosticPathUtil.isAbsolute((String)dirPath)) {
                dir = fileSystem.findFileByPath(dirPath);
            } else if (contextDir != null) {
                dir = contextDir.findFileByRelativePath(dirPath);
            }
            if (dir == null) continue;
            dirs.add(dir);
        }
        ArrayList<VirtualFile> arrayList = dirs;
        if (arrayList == null) {
            NodePathManager.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static EnvironmentVariablesData prependPath(@NotNull EnvironmentVariablesData envData, @NotNull String extraNodePath) {
        Object value;
        if (envData == null) {
            NodePathManager.$$$reportNull$$$0(7);
        }
        if (extraNodePath == null) {
            NodePathManager.$$$reportNull$$$0(8);
        }
        if ((value = (String)envData.getEnvs().get(NODE_PATH)) == null && envData.isPassParentEnvs()) {
            value = (String)EnvironmentUtil.getEnvironmentMap().get(NODE_PATH);
        }
        value = ((String)(value = StringUtil.notNullize((String)value))).isEmpty() || StringUtil.startsWithChar((CharSequence)value, (char)NODE_PATH_SEPARATOR) ? extraNodePath + (String)value : extraNodePath + NODE_PATH_SEPARATOR + (String)value;
        LinkedHashMap<String, Object> envs = new LinkedHashMap<String, Object>(envData.getEnvs());
        envs.put(NODE_PATH, value);
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create(Map.copyOf(envs), (boolean)envData.isPassParentEnvs());
        if (environmentVariablesData == null) {
            NodePathManager.$$$reportNull$$$0(9);
        }
        return environmentVariablesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/reference/NodePathManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePathData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraNodePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/reference/NodePathManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodePaths";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePathsFromNodePathEnvVariable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prependPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePathsFromNodePathEnvVariable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prependPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface NodeRunConfigurationNodePathProvider {
        @Nullable
        public NodePathData getNodePathData();

        @Nullable
        public static NodeRunConfigurationNodePathProvider getInstance(@NotNull Project project) {
            if (project == null) {
                NodeRunConfigurationNodePathProvider.$$$reportNull$$$0(0);
            }
            return (NodeRunConfigurationNodePathProvider)project.getService(NodeRunConfigurationNodePathProvider.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/reference/NodePathManager$NodeRunConfigurationNodePathProvider", "getInstance"));
        }
    }

    public static class NodePathData {
        private final String myNodePathValue;
        private final VirtualFile myContextFileOrDir;

        public NodePathData(@NotNull String nodePathValue, @Nullable VirtualFile contextFileOrDir) {
            if (nodePathValue == null) {
                NodePathData.$$$reportNull$$$0(0);
            }
            this.myNodePathValue = nodePathValue;
            this.myContextFileOrDir = contextFileOrDir;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodePathData data = (NodePathData)o;
            return this.myNodePathValue.equals(data.myNodePathValue) && Objects.equals(this.myContextFileOrDir, data.myContextFileOrDir);
        }

        public int hashCode() {
            return Objects.hash(this.myNodePathValue, this.myContextFileOrDir);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePathValue", "com/intellij/javascript/nodejs/reference/NodePathManager$NodePathData", "<init>"));
        }
    }
}

