/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodePackage;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageDescriptor {
    private static final Logger LOG = Logger.getInstance(NodePackageDescriptor.class);
    private final List<String> myPackageNames;
    private final Map<String, String> myDependencyByPackageMap;
    private final @NlsContexts.StatusText String myHintText;

    public NodePackageDescriptor(@NotNull String packageName) {
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(0);
        }
        this(Collections.singletonList(packageName), null);
    }

    public NodePackageDescriptor(String ... packageNames) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(1);
        }
        this(List.of(packageNames), null);
    }

    public NodePackageDescriptor(@NotNull List<String> packageNames) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(2);
        }
        this(List.copyOf(packageNames), null);
    }

    public NodePackageDescriptor(@NotNull List<String> packageNames, @Nullable @NlsContexts.StatusText String hintText) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(3);
        }
        this(List.copyOf(packageNames), Collections.emptyMap(), hintText);
    }

    public NodePackageDescriptor(@NotNull List<String> packageNames, @NotNull Map<String, String> dependencyByPackageMap, @Nullable @NlsContexts.StatusText String hintText) {
        if (packageNames == null) {
            NodePackageDescriptor.$$$reportNull$$$0(4);
        }
        if (dependencyByPackageMap == null) {
            NodePackageDescriptor.$$$reportNull$$$0(5);
        }
        this.myPackageNames = List.copyOf(packageNames);
        this.myDependencyByPackageMap = Map.copyOf(dependencyByPackageMap);
        this.myHintText = hintText;
    }

    @NotNull
    public List<String> getPackageNames() {
        List<String> list2 = this.myPackageNames;
        if (list2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Nullable
    public String getDependencyByPackageName(@NotNull String packageName) {
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(7);
        }
        return this.myDependencyByPackageMap.get(packageName);
    }

    @NotNull
    public NodePackage createPackage(@NotNull String path2) {
        WslNodePackage wslNodePackage;
        if (path2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(8);
        }
        if ((wslNodePackage = WslNodePackage.createIfWslPackagePath(path2)) != null) {
            WslNodePackage wslNodePackage2 = wslNodePackage;
            if (wslNodePackage2 == null) {
                NodePackageDescriptor.$$$reportNull$$$0(9);
            }
            return wslNodePackage2;
        }
        YarnPnpNodePackage yarnPnpNodePackage = YarnPnpNodePackage.createFromText(path2);
        if (yarnPnpNodePackage != null) {
            YarnPnpNodePackage yarnPnpNodePackage2 = yarnPnpNodePackage;
            if (yarnPnpNodePackage2 == null) {
                NodePackageDescriptor.$$$reportNull$$$0(10);
            }
            return yarnPnpNodePackage2;
        }
        return new NodePackage(path2);
    }

    @NotNull
    public NodePackageRef createPackageRef(@NotNull String text) {
        if (text == null) {
            NodePackageDescriptor.$$$reportNull$$$0(11);
        }
        NodePackageRef nodePackageRef = NodePackageRef.create(this.createPackage(text));
        if (nodePackageRef == null) {
            NodePackageDescriptor.$$$reportNull$$$0(12);
        }
        return nodePackageRef;
    }

    @NotNull
    public NodePackageRef dereferenceIfProjectRef(@NotNull Project project, @NotNull NodePackageRef ref) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(13);
        }
        if (ref == null) {
            NodePackageDescriptor.$$$reportNull$$$0(14);
        }
        NodePackageRef nodePackageRef = ref;
        if (nodePackageRef == null) {
            NodePackageDescriptor.$$$reportNull$$$0(15);
        }
        return nodePackageRef;
    }

    @NotNull
    public NodePackage findFirstDirectDependencyPackage(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(16);
        }
        NodePackage nodePackage = (NodePackage)ReadAction.compute(() -> {
            List<NodePackage> packages = this.listAvailable(project, interpreter, contextFileOrDirectory, true);
            NodePackage pkg = (NodePackage)ContainerUtil.getFirstItem(packages);
            return pkg != null ? pkg : this.createPackage("");
        });
        if (nodePackage == null) {
            NodePackageDescriptor.$$$reportNull$$$0(17);
        }
        return nodePackage;
    }

    @NotNull
    public List<NodePackageRef> listPackageRefs(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(18);
        }
        List<NodePackage> packages = this.listAvailable(project, interpreter, contextFileOrDirectory, false);
        List list2 = ContainerUtil.map(packages, pkg -> NodePackageRef.create(pkg));
        if (list2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    public final List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(20);
        }
        List<NodePackage> list2 = this.listAvailable(project, interpreter, contextFileOrDirectory, false);
        if (list2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(22);
        }
        List<NodePackage> list2 = this.listAvailable(project, interpreter, contextFileOrDirectory, directDependenciesInsideProject, false);
        if (list2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @NotNull
    public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject, boolean dependenciesShouldBeVisibleFromContext) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(24);
        }
        LinkedHashSet packages = new LinkedHashSet();
        LinkedHashSet globalPackages = new LinkedHashSet();
        for (String packageName : this.myPackageNames) {
            ReadAction.run(() -> NodePackageDescriptor.listAvailable(packages, globalPackages, packageName, this.myDependencyByPackageMap.get(packageName), project, interpreter, contextFileOrDirectory, directDependenciesInsideProject, this::createPackage));
        }
        LinkedHashSet<NodePackage> result2 = new LinkedHashSet<NodePackage>();
        if (contextFileOrDirectory != null) {
            MultiMap map = MultiMap.create();
            for (NodePackageAndPackageJson pkg : packages) {
                VirtualFile root = pkg.getPackageJson() != null ? pkg.getPackageJson().getParent() : null;
                if (root == null) continue;
                map.putValue((Object)root, (Object)pkg.getPackage());
            }
            for (VirtualFile dir = contextFileOrDirectory; dir != null; dir = dir.getParent()) {
                result2.addAll(map.get((Object)dir));
            }
        }
        if (!dependenciesShouldBeVisibleFromContext) {
            for (NodePackageAndPackageJson pkg : packages) {
                result2.add(pkg.getPackage());
            }
        }
        result2.addAll(globalPackages);
        return new ArrayList<NodePackage>(result2);
    }

    @Nullable
    @NlsContexts.StatusText
    public String getHintText() {
        String pkgText;
        if (this.myHintText != null) {
            return this.myHintText;
        }
        if (this.myPackageNames.size() == 1) {
            pkgText = (String)ContainerUtil.getFirstItem(this.myPackageNames);
        } else if (this.myPackageNames.size() > 1) {
            pkgText = JavaScriptBundle.message("node.package.empty.hint.pkg1.or.pkg2", StringUtil.join(this.myPackageNames.subList(0, this.myPackageNames.size() - 1), (String)", "), ContainerUtil.getLastItem(this.myPackageNames));
        } else {
            return null;
        }
        return JavaScriptBundle.message("node.package.empty.hint", pkgText);
    }

    @Nullable
    public NodePackage findUnambiguousDependencyPackage(@NotNull Project project) {
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(25);
        }
        String packageName = Objects.requireNonNull((String)ContainerUtil.getFirstItem(this.myPackageNames));
        VirtualFile projectRoot = ProjectUtil.guessProjectDir((Project)project);
        if (project.isDefault() || projectRoot == null) {
            return null;
        }
        VirtualFile packageJson = JSLinterConfigFileUtil.findDistinctConfigInContentRoots(project, Collections.singletonList("package.json"));
        if (packageJson == null || !PackageJsonData.getOrCreate(packageJson).isDependencyOfAnyType(packageName)) {
            return null;
        }
        YarnPnpNodePackage yarnPnpNodePackage = YarnPnpNodePackage.create(project, packageJson, packageName, true, false);
        if (yarnPnpNodePackage != null) {
            return yarnPnpNodePackage;
        }
        boolean yarn = NpmUtil.isYarnAlikePackageRef(NpmManager.getInstance(project).getPackageRef());
        if (yarn) {
            return null;
        }
        String basePath = FileUtil.toSystemDependentName((String)projectRoot.getPath());
        return new NodePackage(StringUtil.trimEnd((String)basePath, (String)File.separator) + File.separator + "node_modules" + File.separator + packageName);
    }

    private static void listAvailable(@NotNull Set<NodePackageAndPackageJson> packages, @NotNull Set<NodePackage> globalPackages, @NotNull String packageName, @Nullable String dependencyName, @NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject, @NotNull NodePackageProducer packageProducer) {
        if (packages == null) {
            NodePackageDescriptor.$$$reportNull$$$0(26);
        }
        if (globalPackages == null) {
            NodePackageDescriptor.$$$reportNull$$$0(27);
        }
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(28);
        }
        if (project == null) {
            NodePackageDescriptor.$$$reportNull$$$0(29);
        }
        if (packageProducer == null) {
            NodePackageDescriptor.$$$reportNull$$$0(30);
        }
        ArrayList modules2 = new ArrayList();
        if (contextFileOrDirectory != null) {
            NodeModuleSearchUtil.findModulesWithName(modules2, packageName, contextFileOrDirectory, null);
        }
        if (!project.isDefault()) {
            NodeModuleSearchUtil.findModulesByNameInContentRoots(modules2, packageName, project);
            Set<VirtualFile> packageJsonFiles = PackageJsonFileManager.getInstance(project).getValidPackageJsonFiles();
            HashSet<VirtualFile> packageJsonWithInheritedDependency = new HashSet<VirtualFile>();
            for (VirtualFile virtualFile : packageJsonFiles) {
                YarnPnpNodePackage yarnPnpNodePackage;
                PackageJsonData data = PackageJsonData.getOrCreate(virtualFile);
                if (!NodePackageDescriptor.isPackageAndDependencyDeclared(data, packageName, dependencyName)) continue;
                VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(virtualFile);
                if (nodeModulesDir != null) {
                    int countBefore = modules2.size();
                    NodeModuleSearchUtil.findModuleWithNameInDirectory(modules2, nodeModulesDir, ModuleType.NODE_MODULES_DIR, packageName);
                    if (modules2.size() == countBefore) {
                        VirtualFile parentPackageJson;
                        VirtualFile parent = virtualFile.getParent();
                        if (parent != null) {
                            parent = parent.getParent();
                        }
                        if (parent != null && (parentPackageJson = PackageJsonUtil.findUpPackageJson(parent)) != null) {
                            packageJsonWithInheritedDependency.add(parentPackageJson);
                        }
                    }
                }
                if ((yarnPnpNodePackage = YarnPnpNodePackage.create(project, virtualFile, packageName, true, false)) == null) continue;
                packages.add(new NodePackageAndPackageJson(yarnPnpNodePackage, virtualFile));
            }
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            for (CompletionModuleInfo module : modules2) {
                VirtualFile dir = module.getVirtualFile();
                if (dir == null || !dir.isDirectory()) continue;
                boolean ok = false;
                VirtualFile packageJson = null;
                if (directDependenciesInsideProject && JSLibraryUtil.getContentRootForFile(fileIndex, dir) != null) {
                    VirtualFile nodeModulesDir = NodePackageDescriptor.findNodeModulesByPackageDir(dir);
                    packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir);
                    if (packageJson != null) {
                        PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
                        ok = NodePackageDescriptor.isPackageAndDependencyDeclared(data, packageName, dependencyName) || packageJsonWithInheritedDependency.contains(packageJson);
                    }
                } else {
                    ok = NodePackageDescriptor.hasSiblingPackageInstalled(dir, dependencyName);
                }
                if (!ok) continue;
                NodePackage pkg = packageProducer.create(dir.getPath());
                packages.add(new NodePackageAndPackageJson(pkg, packageJson));
            }
        }
        List<File> packageDirs = NodePackageDescriptor.findGloballyInstalledPackages(project, packageName, interpreter);
        for (File dir : packageDirs) {
            if (dir == null || !dir.isDirectory() || !NodePackageDescriptor.hasSiblingPackageInstalled(dir, dependencyName)) continue;
            NodePackage nodePackage = packageProducer.create(dir.getPath());
            globalPackages.add(nodePackage);
        }
    }

    @NotNull
    public static List<File> findGloballyInstalledPackages(@Nullable Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        File packageDir2;
        File configDir;
        Path packageDir3;
        NodePackageRef npmRef;
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(31);
        }
        if (interpreter == null) {
            List<File> list2 = Collections.emptyList();
            if (list2 == null) {
                NodePackageDescriptor.$$$reportNull$$$0(32);
            }
            return list2;
        }
        ArrayList globalModules = new ArrayList();
        NodeModuleSearchUtil.findGloballyInstalledModules(globalModules, packageName, interpreter);
        ArrayList<File> dirs = new ArrayList<File>();
        NodePackageRef nodePackageRef = npmRef = project != null ? NpmManager.getInstance(project).getPackageRef() : null;
        if ((npmRef != null && NpmUtil.isPnpmPackageRef(npmRef) || "pnpm".equals(packageName)) && (packageDir3 = NodePackageDescriptor.getPnpmGlobalInstallation(packageName, interpreter)) != null) {
            dirs.add(packageDir3.toFile());
        }
        dirs.addAll(ContainerUtil.mapNotNull(globalModules, info -> {
            VirtualFile file2 = info.getVirtualFile();
            return file2 != null ? VfsUtilCore.virtualToIoFile((VirtualFile)file2) : null;
        }));
        if (npmRef != null && NpmUtil.isYarnAlikePackageRef(npmRef) && (configDir = NodePackageDescriptor.getYarnGlobalNodeModules()) != null && (packageDir2 = new File(configDir, packageName)).isDirectory()) {
            dirs.add(packageDir2);
        }
        ArrayList<File> arrayList = dirs;
        if (arrayList == null) {
            NodePackageDescriptor.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @Nullable
    private static Path getPnpmGlobalInstallation(@NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        NodeJsLocalInterpreter localInterpreter;
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(34);
        }
        if ((localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter)) == null) {
            return null;
        }
        String configPrefix = localInterpreter.getConfigPrefix();
        if (configPrefix == null) {
            return null;
        }
        Path pnpmGlobalDir = Paths.get(configPrefix, "pnpm-global");
        if (Files.isDirectory(pnpmGlobalDir, new LinkOption[0])) {
            return NodePackageDescriptor.findPnpmGlobalPackage(localInterpreter, packageName, pnpmGlobalDir);
        }
        return null;
    }

    @Nullable
    private static Path findPnpmGlobalPackage(@NotNull NodeJsLocalInterpreter interpreter, @NotNull String packageName, @NotNull Path pnpmGlobalDir) {
        if (interpreter == null) {
            NodePackageDescriptor.$$$reportNull$$$0(35);
        }
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(36);
        }
        if (pnpmGlobalDir == null) {
            NodePackageDescriptor.$$$reportNull$$$0(37);
        }
        if ("pnpm".equals(packageName)) {
            Path result2;
            String layoutVersion = NodePackageDescriptor.findLayoutVersion(packageName, interpreter);
            if (layoutVersion != null && Files.isDirectory(result2 = pnpmGlobalDir.resolve(layoutVersion + File.separator + "node_modules" + File.separator + packageName), new LinkOption[0])) {
                return result2;
            }
            return null;
        }
        try {
            return Files.list(pnpmGlobalDir).map(layoutVersionDir -> {
                Path result2 = layoutVersionDir.resolve("node_modules" + File.separatorChar + packageName);
                return Files.isDirectory(result2, new LinkOption[0]) ? result2 : null;
            }).filter(Objects::nonNull).findFirst().orElse(null);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static String findLayoutVersion(@NotNull String binaryName, @NotNull NodeJsLocalInterpreter interpreter) {
        Path binDir;
        Path pnpmBinary;
        if (binaryName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(38);
        }
        if (interpreter == null) {
            NodePackageDescriptor.$$$reportNull$$$0(39);
        }
        if (Files.isRegularFile(pnpmBinary = (binDir = Paths.get(PathUtil.getParentPath((String)interpreter.getInterpreterSystemDependentPath()), new String[0])).resolve(binaryName), new LinkOption[0])) {
            try {
                String text = FileUtil.toSystemIndependentName((String)Files.readString(pnpmBinary));
                Pattern pattern2 = Pattern.compile("/pnpm-global/([^/]+)/node_modules/");
                Matcher matcher = pattern2.matcher(text);
                if (matcher.find()) {
                    return matcher.group(1);
                }
            }
            catch (IOException e) {
                LOG.info("Cannot read " + pnpmBinary, (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    private static File getYarnGlobalNodeModules() {
        String userHome = SystemProperties.getUserHome();
        if (StringUtil.isNotEmpty((String)userHome)) {
            return new File(userHome, ".config/yarn/global/node_modules");
        }
        return null;
    }

    private static boolean isPackageAndDependencyDeclared(@NotNull PackageJsonData data, @NotNull String packageName, @Nullable String dependencyName) {
        if (data == null) {
            NodePackageDescriptor.$$$reportNull$$$0(40);
        }
        if (packageName == null) {
            NodePackageDescriptor.$$$reportNull$$$0(41);
        }
        return data.isDependencyOfAnyType(packageName) && (dependencyName == null || data.isDependencyOfAnyType(dependencyName));
    }

    private static boolean hasSiblingPackageInstalled(@NotNull VirtualFile packageDir2, @Nullable String siblingPackageName) {
        if (packageDir2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(42);
        }
        if (siblingPackageName == null) {
            return true;
        }
        VirtualFile nodeModulesDir = NodePackageDescriptor.findNodeModulesByPackageDir(packageDir2);
        return nodeModulesDir != null && nodeModulesDir.findFileByRelativePath(siblingPackageName) != null;
    }

    private static boolean hasSiblingPackageInstalled(@NotNull File packageDir2, @Nullable String siblingPackageName) {
        String nodeModulesStr;
        if (packageDir2 == null) {
            NodePackageDescriptor.$$$reportNull$$$0(43);
        }
        if (siblingPackageName == null) {
            return true;
        }
        String path2 = FileUtil.toSystemIndependentName((String)packageDir2.getAbsolutePath());
        int i2 = path2.lastIndexOf(nodeModulesStr = "/node_modules/");
        if (i2 < 0) {
            return false;
        }
        String absoluteSiblingPath = path2.substring(0, i2) + nodeModulesStr + siblingPackageName;
        return new File(absoluteSiblingPath).isDirectory();
    }

    @Nullable
    private static VirtualFile findNodeModulesByPackageDir(@NotNull VirtualFile dir) {
        VirtualFile parent;
        if (dir == null) {
            NodePackageDescriptor.$$$reportNull$$$0(44);
        }
        if ((parent = dir.getParent()) == null) {
            return null;
        }
        CharSequence parentName = parent.getNameSequence();
        if (parent.isDirectory() && StringUtil.equals((CharSequence)"node_modules", (CharSequence)dir.getNameSequence())) {
            return parent;
        }
        if (NodeModuleSearchUtil.isScopeDirName(parentName)) {
            parent = parent.getParent();
        }
        return parent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyByPackageMap";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalPackages";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageProducer";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pnpmGlobalDir";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryName";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageRef";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "dereferenceIfProjectRef";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirstDirectDependencyPackage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "listPackageRefs";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "listAvailable";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findGloballyInstalledPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 32: 
            case 33: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyByPackageName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPackage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPackageRef";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dereferenceIfProjectRef";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findFirstDirectDependencyPackage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "listPackageRefs";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "listAvailable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findUnambiguousDependencyPackage";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findGloballyInstalledPackages";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPnpmGlobalInstallation";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findPnpmGlobalPackage";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findLayoutVersion";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isPackageAndDependencyDeclared";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasSiblingPackageInstalled";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findNodeModulesByPackageDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class NodePackageAndPackageJson {
        private final NodePackage myPackage;
        private final VirtualFile myPackageJson;

        private NodePackageAndPackageJson(@NotNull NodePackage pkg, @Nullable VirtualFile packageJson) {
            if (pkg == null) {
                NodePackageAndPackageJson.$$$reportNull$$$0(0);
            }
            this.myPackage = pkg;
            this.myPackageJson = packageJson;
        }

        @NotNull
        private NodePackage getPackage() {
            NodePackage nodePackage = this.myPackage;
            if (nodePackage == null) {
                NodePackageAndPackageJson.$$$reportNull$$$0(1);
            }
            return nodePackage;
        }

        @Nullable
        private VirtualFile getPackageJson() {
            return this.myPackageJson;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodePackageAndPackageJson json = (NodePackageAndPackageJson)o;
            return this.myPackage.equals(json.myPackage);
        }

        public int hashCode() {
            return this.myPackage.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pkg";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor$NodePackageAndPackageJson";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageDescriptor$NodePackageAndPackageJson";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPackage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface NodePackageProducer {
        @NotNull
        public NodePackage create(@NotNull String var1);
    }
}

