/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.web.webTypes;

import com.intellij.diagnostic.PluginException;
import com.intellij.javascript.web.webTypes.WebTypesLoadUtilKt;
import com.intellij.javascript.web.webTypes.json.WebTypes;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.text.SemVer;
import com.intellij.util.xmlb.annotations.Attribute;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0014R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/web/webTypes/WebTypesDefinitionsEP;", "Lcom/intellij/openapi/extensions/CustomLoadingExtensionPointBean;", "Lcom/intellij/javascript/web/webTypes/json/WebTypes;", "()V", "enableByDefault", "", "Ljava/lang/Boolean;", "source", "", "createInstance", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getImplementationClassName", "Companion", "intellij.javascript.web"})
@ApiStatus.Experimental
public final class WebTypesDefinitionsEP
extends CustomLoadingExtensionPointBean<WebTypes> {
    @Attribute(value="source")
    @JvmField
    @Nullable
    public String source;
    @Attribute(value="enableByDefault")
    @JvmField
    @Nullable
    public Boolean enableByDefault;
    @NotNull
    private static final ExtensionPointName<WebTypesDefinitionsEP> EP_NAME;
    @NotNull
    public static final Companion Companion;

    @Nullable
    protected String getImplementationClassName() {
        return null;
    }

    @NotNull
    public WebTypes createInstance(@NotNull ComponentManager componentManager, @NotNull PluginDescriptor pluginDescriptor) {
        WebTypes webTypes;
        Intrinsics.checkNotNullParameter((Object)componentManager, (String)"componentManager");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        try {
            InputStream inputStream = pluginDescriptor.getPluginClassLoader().getResourceAsStream(this.source);
            if (inputStream == null) {
                throw (Throwable)new PluginException("Cannot find web-types definitions located at '" + this.source + '\'', pluginDescriptor.getPluginId());
            }
            webTypes = WebTypesLoadUtilKt.readWebTypes(inputStream);
        }
        catch (Throwable e) {
            throw (Throwable)new PluginException("Cannot load web-types definitions from '" + this.source + "': " + e.getMessage(), e, pluginDescriptor.getPluginId());
        }
        boolean bl = false;
        boolean bl2 = false;
        WebTypes it = webTypes;
        boolean bl3 = false;
        if (it.getName() == null) {
            throw (Throwable)new PluginException("Missing package-name in web-types definitions from '" + this.source + '\'', pluginDescriptor.getPluginId());
        }
        if (SemVer.parseFromText((String)it.getVersion()) == null) {
            throw (Throwable)new PluginException("Cannot parse version '" + it.getVersion() + "' in web-types definitions from '" + this.source + '\'', pluginDescriptor.getPluginId());
        }
        return webTypes;
    }

    static {
        Companion = new Companion(null);
        EP_NAME = new ExtensionPointName("com.intellij.javascript.webTypes");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/web/webTypes/WebTypesDefinitionsEP$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/javascript/web/webTypes/WebTypesDefinitionsEP;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.javascript.web"})
    public static final class Companion {
        @NotNull
        public final ExtensionPointName<WebTypesDefinitionsEP> getEP_NAME() {
            return EP_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

