/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.web.webTypes;

import com.intellij.javascript.web.webTypes.JavaScriptSymbolResolver;
import com.intellij.javascript.web.webTypes.json.SourceBase;
import com.intellij.javascript.web.webTypes.json.SourceFileOffset;
import com.intellij.javascript.web.webTypes.json.SourceSymbol;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/web/webTypes/WebTypesSourceSymbolResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "pluginName", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "resolve", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "Lcom/intellij/psi/PsiElement;", "source", "Lcom/intellij/javascript/web/webTypes/json/SourceBase;", "intellij.javascript.web"})
public final class WebTypesSourceSymbolResolver {
    private final Project project;
    private final VirtualFile context;
    private final String pluginName;

    @NotNull
    public final CachedValueProvider.Result<PsiElement> resolve(@NotNull SourceBase source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        SourceBase sourceBase = source2;
        if (sourceBase instanceof SourceSymbol) {
            String moduleName = ((SourceSymbol)source2).getModule();
            String symbolName = ((SourceSymbol)source2).getSymbol();
            if (symbolName != null) {
                String string = moduleName;
                if (string == null) {
                    string = this.pluginName;
                }
                return JavaScriptSymbolResolver.INSTANCE.resolveModuleSymbol(symbolName, string, this.project, this.context);
            }
        } else if (sourceBase instanceof SourceFileOffset) {
            String file2 = ((SourceFileOffset)source2).getFile();
            Integer offset = ((SourceFileOffset)source2).getOffset();
            if (file2 != null && offset != null) {
                return JavaScriptSymbolResolver.INSTANCE.resolveFileSymbol(file2, offset, this.project, this.context);
            }
        }
        CachedValueProvider.Result result2 = CachedValueProvider.Result.create(null, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"Result.create(null, Modi\u2026ionTracker.NEVER_CHANGED)");
        return result2;
    }

    public WebTypesSourceSymbolResolver(@NotNull Project project, @NotNull VirtualFile context, @NotNull String pluginName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pluginName, (String)"pluginName");
        this.project = project;
        this.context = context;
        this.pluginName = pluginName;
    }
}

