/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.ecmascript6.completion.ES6ClassMemberCompletionProvider;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSPropertyNameCompletionProvider;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6PropertyCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(2);
        }
        ES6PropertyCompletionProvider.addCompletions(parameters, result2);
    }

    public static void addCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiElement parent;
        PsiElement grandParent;
        if (parameters == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(4);
        }
        if ((grandParent = ES6PropertyCompletionProvider.findParentProperty(parent = parameters.getPosition().getParent())) == null) {
            return;
        }
        JSProperty property = ES6PropertyCompletionProvider.assertProperty(grandParent, parent);
        if (property == null) {
            return;
        }
        PsiElement greatGrandParent = grandParent.getParent();
        JSObjectLiteralExpression literalExpression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)greatGrandParent, JSObjectLiteralExpression.class);
        literalExpression = literalExpression == null ? null : (JSObjectLiteralExpression)CompletionUtilCoreImpl.getOriginalOrSelf((PsiElement)literalExpression);
        JSTypeSubstitutor substitutor = BaseCreateMembersFix.buildSubstitutorForLiteral(literalExpression);
        boolean useOverridesCompletion = JSApplicationSettings.getInstance().isUseOverridesCompletion();
        Set<String> existingNames = ES6PropertyCompletionProvider.getNamesToSkip(grandParent, greatGrandParent);
        JSPropertyNameCompletionProvider.calcPropertyNameReferenceVariants(property, parameters, result2, !useOverridesCompletion && existingNames.isEmpty() ? null : results -> {
            ArrayList<LookupElement> newResults = new ArrayList<LookupElement>(results.size());
            for (LookupElement element : results) {
                LookupElement lookupElement = ES6PropertyCompletionProvider.transformElementIfNeeded(grandParent, element, substitutor, parameters);
                if (lookupElement == null || existingNames.contains(lookupElement.getLookupString())) continue;
                newResults.add(lookupElement);
            }
            return newResults;
        });
    }

    @NotNull
    private static Set<String> getNamesToSkip(PsiElement grandParent, PsiElement greatGrandParent) {
        Set set = greatGrandParent instanceof JSObjectLiteralExpression && grandParent instanceof ES6Property && ((ES6Property)grandParent).isShorthanded() ? ContainerUtil.map2Set((Object[])((JSObjectLiteralExpression)greatGrandParent).getProperties(), p -> p.getName()) : Collections.emptySet();
        if (set == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static JSProperty assertProperty(PsiElement grandParent, PsiElement parent) {
        PsiReference parentReference;
        Object[] parentReferences;
        if (grandParent instanceof ES6FunctionProperty) {
            return (JSProperty)grandParent;
        }
        PsiElement firstElement = grandParent.getNode().getFirstChildNode().getPsi();
        if (firstElement.isEquivalentTo(parent) && (parentReferences = grandParent.getReferences()).length > 0 && (parentReference = (PsiReference)ArrayUtil.getFirstElement((Object[])parentReferences)) instanceof JSPropertyNameReference) {
            return ((JSPropertyNameReference)parentReference).getElement();
        }
        return null;
    }

    @Nullable
    private static PsiElement findParentProperty(PsiElement parent) {
        if (parent instanceof JSReferenceExpression) {
            return (PsiElement)ObjectUtils.tryCast((Object)parent.getParent(), ES6Property.class);
        }
        assert (parent instanceof JSParameter);
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof JSParameterList) {
            JSParameterListElement[] parameters = ((JSParameterList)grandParent).getParameters();
            if (parameters.length != 1 || parameters[0] != parent) {
                return null;
            }
            return (PsiElement)ObjectUtils.tryCast((Object)grandParent.getParent(), ES6FunctionProperty.class);
        }
        return null;
    }

    @Nullable
    private static LookupElement transformElementIfNeeded(@NotNull PsiElement grandParent, @NotNull LookupElement element, @Nullable JSTypeSubstitutor substitutor, @NotNull CompletionParameters parameters) {
        if (grandParent == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(6);
        }
        if (element == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(7);
        }
        if (parameters == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(8);
        }
        PsiElement psiElement = element.getPsiElement();
        PsiElement classOfContext = grandParent.getParent() instanceof JSObjectLiteralExpression ? grandParent.getParent() : JSResolveUtil.getClassOfContext(grandParent);
        String lookupString = element.getLookupString();
        boolean paramsOnly = grandParent instanceof ES6FunctionProperty;
        if (!(psiElement instanceof JSFunction)) {
            return paramsOnly ? null : element;
        }
        JSAttributeList attributeList = ((JSFunction)psiElement).getAttributeList();
        if (attributeList != null && (attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE || attributeList.getAccessType() == JSAttributeList.AccessType.PROTECTED)) {
            return null;
        }
        if (paramsOnly && !Objects.equals(((JSFunction)psiElement).getName(), ((ES6FunctionProperty)grandParent).getName())) {
            return null;
        }
        if (classOfContext != null) {
            int priority2 = (int)JSCompletionUtil.getLookupElementPriority(element);
            boolean isPartial = priority2 < JSLookupPriority.MAX_PRIORITY.getPriorityValue();
            JSLookupElementRenderer renderer = ES6ClassMemberCompletionProvider.getRenderer(psiElement, JSResolveUtil.getClassOfContext(psiElement), substitutor, element.getLookupString(), isPartial, paramsOnly);
            InsertHandler<LookupElement> insertHandler = ES6ClassMemberCompletionProvider.createInsertHandler(psiElement, classOfContext, lookupString, parameters, paramsOnly);
            LookupElementBuilder result2 = LookupElementBuilder.create((Object)psiElement, (String)lookupString).withRenderer((LookupElementRenderer)renderer).withExpensiveRenderer((LookupElementRenderer)renderer).withInsertHandler(insertHandler);
            return JSLookupUtilImpl.wrapWithPriority(element, result2);
        }
        return paramsOnly ? null : element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/completion/ES6PropertyCompletionProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandParent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/completion/ES6PropertyCompletionProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamesToSkip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "transformElementIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

