/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ecmascript6.psi.impl.JSImportDescriptorProcessor;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.ecmascript6.psi.impl.JSSymlinkLinkedProject;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptInES6ImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptSymlinkLinkedProject;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptConfigGraphCache;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.model.ModelBranchUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportPathBuilder
extends TypeScriptInES6ImportPathBuilder {
    @NotNull
    public static final Key<VirtualFile> KEY_ROOT_DIR = Key.create((String)"root.dir");
    @Nullable
    private final TypeScriptConfig myConfigFile;

    public TypeScriptImportPathBuilder(@NotNull JSImportPathConfiguration configuration) {
        if (configuration == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(0);
        }
        super(configuration);
        this.myConfigFile = configuration.getTsConfig();
    }

    @Override
    protected boolean useNodeResolution() {
        if (!super.useNodeResolution()) {
            return false;
        }
        if (this.myConfigFile == null) {
            return true;
        }
        TypeScriptConfig.ModuleResolution resolution = this.myConfigFile.getResolution();
        if (resolution == TypeScriptConfig.ModuleResolution.NODE) {
            return true;
        }
        return TypeScriptConfig.ModuleTarget.COMMON_JS == this.myConfigFile.getModule();
    }

    @Override
    protected boolean processModuleNamesWithoutExistingImports(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(1);
        }
        if (this.myConfigFile != null && !this.processModuleNameUsingPathMappings(processor)) {
            return false;
        }
        return super.processModuleNamesWithoutExistingImports(processor);
    }

    private boolean processModuleNameUsingPathMappings(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(2);
        }
        if (this.myConfigFile == null) {
            return true;
        }
        VirtualFile baseUrl = this.myConfigFile.getBaseUrl();
        if (baseUrl == null) {
            return true;
        }
        Collection<JSModulePathSubstitution> mappings = this.myConfigFile.getPaths();
        for (JSImportDescriptor descriptor2 : this.getMappingsForBaseUrl(baseUrl, mappings)) {
            if (processor.processDescriptor(descriptor2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private VirtualFile getRootFromConfig() {
        if (this.myConfigFile == null) {
            return null;
        }
        VirtualFile baseUrl = this.myConfigFile.getBaseUrl();
        VirtualFile root = baseUrl != null ? baseUrl : this.myConfigFile.getConfigDirectory();
        return ModelBranchUtil.obtainCopyFromTheSameBranch((VirtualFile)this.myPlaceFile, (VirtualFile)root);
    }

    @Override
    protected boolean processRootPaths(@NotNull JSImportDescriptorProcessor processor, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        VirtualFile rootFile;
        if (processor == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(3);
        }
        if (moduleFileOrDirectory == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(4);
        }
        if (resolvedModuleFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(5);
        }
        if ((rootFile = this.getRootFromConfig()) != null) {
            return this.processPathForRoot(processor, moduleFileOrDirectory, resolvedModuleFile, rootFile);
        }
        return super.processRootPaths(processor, moduleFileOrDirectory, resolvedModuleFile);
    }

    @Override
    @Nullable
    protected JSSymlinkLinkedProject getLinkedProject(@NotNull VirtualFile importRoot, @Nullable VirtualFile nodeModules, @Nullable String packageName) {
        if (importRoot == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(6);
        }
        if (TypeScriptUtil.isDefinitionFile(this.myFileToImport)) {
            return super.getLinkedProject(importRoot, nodeModules, packageName);
        }
        VirtualFile linkedPackage = TypeScriptImportPathBuilder.getLinkedPackage(importRoot, nodeModules, packageName);
        if (linkedPackage == null) {
            return null;
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForFile(this.myProject, this.myFileToImport);
        if (config2 == null) {
            return null;
        }
        VirtualFile configDirectory = config2.getConfigDirectory();
        if (!VfsUtilCore.isAncestor((VirtualFile)configDirectory, (VirtualFile)this.myFileToImport, (boolean)true)) {
            return null;
        }
        VirtualFile sourceRoot = this.getSourceRoot(config2, this.myFileToImport);
        if (sourceRoot == null) {
            return null;
        }
        String outDirPath = config2.getOutDirectory();
        VirtualFile outDirectory = (VirtualFile)ObjectUtils.coalesce((Object)(outDirPath == null ? null : LocalFileSystem.getInstance().findFileByPath(outDirPath)), (Object)configDirectory);
        if (outDirectory.equals(sourceRoot)) {
            return new TypeScriptSymlinkLinkedProject(importRoot, linkedPackage, importRoot, importRoot, packageName);
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)importRoot, (VirtualFile)outDirectory, (boolean)false)) {
            return null;
        }
        return new TypeScriptSymlinkLinkedProject(importRoot, linkedPackage, sourceRoot, outDirectory, packageName);
    }

    @Nullable
    private VirtualFile getSourceRoot(@NotNull TypeScriptConfig importFileConfig, @NotNull VirtualFile fileToImport) {
        VirtualFile rootDir;
        if (importFileConfig == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(7);
        }
        if (fileToImport == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(8);
        }
        if ((rootDir = importFileConfig.getRootDirFile()) == null) {
            return this.detectRootDir(importFileConfig);
        }
        return VfsUtilCore.isAncestor((VirtualFile)rootDir, (VirtualFile)fileToImport, (boolean)true) ? rootDir : null;
    }

    @NotNull
    private VirtualFile detectRootDir(@NotNull TypeScriptConfig importFileConfig) {
        if (importFileConfig == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(9);
        }
        VirtualFile configDir = importFileConfig.getConfigDirectory();
        if (importFileConfig.getOutDirectory() == null) {
            VirtualFile virtualFile = configDir;
            if (virtualFile == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(10);
            }
            return virtualFile;
        }
        TypeScriptImportGraph graph = TypeScriptConfigGraphCache.getService(this.myProject).getGraph(importFileConfig);
        VirtualFile rootDirCandidate = graph.getUserData(KEY_ROOT_DIR);
        if (rootDirCandidate != null) {
            VirtualFile virtualFile = rootDirCandidate;
            if (virtualFile == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(11);
            }
            return virtualFile;
        }
        List realFiles = ContainerUtil.filter((Collection)graph.getNodes(), el -> !TypeScriptUtil.isDefinitionFile(el));
        if (realFiles.size() == 1) {
            VirtualFile virtualFile = ((VirtualFile)realFiles.get(0)).getParent();
            if (virtualFile == null) {
                TypeScriptImportPathBuilder.$$$reportNull$$$0(12);
            }
            return virtualFile;
        }
        VirtualFile ancestor = VfsUtil.getCommonAncestor((Collection)realFiles);
        VirtualFile file2 = ancestor != null && VfsUtilCore.isAncestor((VirtualFile)configDir, (VirtualFile)ancestor, (boolean)false) ? ancestor : configDir;
        graph.putUserData(KEY_ROOT_DIR, file2);
        VirtualFile virtualFile = file2;
        if (virtualFile == null) {
            TypeScriptImportPathBuilder.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileOrDirectory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModuleFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importRoot";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importFileConfig";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportPathBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptImportPathBuilder";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRootDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNamesWithoutExistingImports";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNameUsingPathMappings";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processRootPaths";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedProject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "detectRootDir";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

