/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JSStringLiteralLexer
extends StringLiteralLexer {
    private final boolean myAllowUnicodeEscapesWithinBraces;
    private final boolean myAllowNonEscapesAfterSlash;

    public JSStringLiteralLexer(char quoteChar, IElementType originalLiteralToken, String additionalValidEscapes, boolean allowOctal, boolean allowUnicodeEscapesWithinBraces, boolean allowNonEscapesAfterSlash) {
        super(quoteChar, originalLiteralToken, true, additionalValidEscapes, allowOctal, true);
        this.myAllowUnicodeEscapesWithinBraces = allowUnicodeEscapesWithinBraces;
        this.myAllowNonEscapesAfterSlash = allowNonEscapesAfterSlash;
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        if (this.myAllowUnicodeEscapesWithinBraces && this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            int i2 = this.myStart + 3;
            boolean foundHex = false;
            boolean hadDigitBefore = false;
            while (i2 < this.myEnd) {
                char c = this.myBuffer.charAt(i2);
                if (hadDigitBefore && c == '_') {
                    ++i2;
                    hadDigitBefore = false;
                    continue;
                }
                if (!StringUtil.isHexDigit((char)c)) break;
                foundHex = true;
                hadDigitBefore = true;
                ++i2;
            }
            IElementType iElementType = foundHex && i2 < this.myEnd && this.myBuffer.charAt(i2) == '}' ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            if (iElementType == null) {
                JSStringLiteralLexer.$$$reportNull$$$0(0);
            }
            return iElementType;
        }
        int digitsCount = 0;
        boolean hadDigitBefore = false;
        int i3 = this.myStart + 2;
        while (digitsCount < 4) {
            if (i3 >= this.myEnd) {
                IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                if (iElementType == null) {
                    JSStringLiteralLexer.$$$reportNull$$$0(1);
                }
                return iElementType;
            }
            char c = this.myBuffer.charAt(i3);
            if (!StringUtil.isHexDigit((char)c)) {
                if (!hadDigitBefore || c != '_') {
                    IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                    if (iElementType == null) {
                        JSStringLiteralLexer.$$$reportNull$$$0(2);
                    }
                    return iElementType;
                }
                hadDigitBefore = false;
            } else {
                hadDigitBefore = true;
                ++digitsCount;
            }
            ++i3;
        }
        IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        if (iElementType == null) {
            JSStringLiteralLexer.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @NotNull
    protected IElementType handleSingleSlashEscapeSequence() {
        IElementType iElementType = this.myAllowNonEscapesAfterSlash ? this.myOriginalLiteralToken : super.handleSingleSlashEscapeSequence();
        if (iElementType == null) {
            JSStringLiteralLexer.$$$reportNull$$$0(4);
        }
        return iElementType;
    }

    protected int locateHexEscapeSequence(int start, int i2) {
        if (!this.myAllowNonEscapesAfterSlash) {
            return super.locateHexEscapeSequence(start, i2);
        }
        ++i2;
        boolean isValid = true;
        while (i2 < start + 4) {
            if (i2 == this.myBufferEnd) {
                isValid = isValid && i2 == start + 3;
                return !isValid ? start + 1 : i2;
            }
            char c = this.myBuffer.charAt(i2);
            if (!StringUtil.isHexDigit((char)c)) {
                isValid = false;
            }
            if (c == '\n' || this.myBuffer.charAt(i2) == this.myQuoteChar) {
                return !isValid ? start + 1 : i2;
            }
            ++i2;
        }
        return !isValid ? start + 1 : i2;
    }

    protected int locateUnicodeEscapeSequence(int start, int i2) {
        if (this.myAllowUnicodeEscapesWithinBraces && ++i2 < this.myBufferEnd && this.myBuffer.charAt(i2) == '{') {
            ++i2;
            boolean hadDigitBefore = false;
            boolean isValid = true;
            while (i2 < this.myBufferEnd) {
                char c = this.myBuffer.charAt(i2);
                if (!StringUtil.isHexDigit((char)c)) {
                    if (!hadDigitBefore || c != '_') {
                        if (c == '}') break;
                        isValid = false;
                        break;
                    }
                    ++i2;
                    hadDigitBefore = false;
                    continue;
                }
                hadDigitBefore = true;
                ++i2;
            }
            if (i2 < this.myBufferEnd && this.myBuffer.charAt(i2) == '}') {
                ++i2;
            }
            return this.myAllowNonEscapesAfterSlash && !isValid ? start + 1 : i2;
        }
        int digitsCount = 0;
        boolean isValid = true;
        while (digitsCount < 4) {
            if (i2 == this.myBufferEnd) {
                return this.myAllowNonEscapesAfterSlash ? start + 1 : i2;
            }
            char c = this.myBuffer.charAt(i2);
            if (c == '\n' || c == this.myQuoteChar) {
                return this.myAllowNonEscapesAfterSlash && !isValid ? start + 1 : i2;
            }
            if (StringUtil.isHexDigit((char)c)) {
                ++digitsCount;
            } else {
                isValid = false;
            }
            ++i2;
        }
        return this.myAllowNonEscapesAfterSlash && !isValid ? start + 1 : i2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/JSStringLiteralLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnicodeEscapeSequenceType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "handleSingleSlashEscapeSequence";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

