/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.arrangement.JSArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSElementArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSRearrangerBase;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectIntHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6Rearranger
extends JSRearrangerBase {
    private static final Comparator<JSRearrangerBase.OverrideInfo> NAME_COMPARATOR = Comparator.comparing(info1 -> info1.member.getName());
    private static final Set<ArrangementSettingsToken> SUPPORTED_TYPES = ContainerUtil.newLinkedHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.EntryType.CONSTRUCTOR, StdArrangementTokens.EntryType.METHOD, StdArrangementTokens.EntryType.FIELD, StdArrangementTokens.EntryType.PROPERTY});
    private final Set<ArrangementSettingsToken> mySupportedModifiers;
    private final Set<ArrangementSettingsToken> myVisibilityModifiers;
    private final StdArrangementSettings myDefaultSettings;
    private final DefaultArrangementSettingsSerializer mySettingsSerializer;
    private final JSLanguageDialect myDialect;
    @NotNull
    public static final ArrangementSettingsToken TREAT_LAMBDA_INITIALIZED_FIELDS_AS_METHODS = new StdArrangementSettingsToken("TREAT_LAMBDA_INITIALIZED_FIELDS_AS_METHODS", JavaScriptBundle.message("js.arrangement.group.arrow.fields.with.methods", new Object[0]), StdArrangementTokenType.GROUPING);

    public ES6Rearranger() {
        this(JavaScriptSupportLoader.ECMA_SCRIPT_6, CollectionFactory.createSmallMemoryFootprintLinkedSet(), Collections.singletonList(StdArrangementTokens.Modifier.STATIC));
    }

    public ES6Rearranger(JSLanguageDialect dialect, Set<ArrangementSettingsToken> visibilityModifiers, Collection<ArrangementSettingsToken> additionalModifiers) {
        List<ArrangementGroupingRule> defaultGroupingRules = Arrays.asList(new ArrangementGroupingRule(StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER), new ArrangementGroupingRule(TREAT_LAMBDA_INITIALIZED_FIELDS_AS_METHODS));
        List<StdArrangementMatchRule> matchRules = ES6Rearranger.getDefaultMatchRules(visibilityModifiers);
        this.myDefaultSettings = StdArrangementSettings.createByMatchRules(defaultGroupingRules, matchRules);
        this.mySettingsSerializer = this.createCustomTokensSerializer();
        this.myVisibilityModifiers = visibilityModifiers;
        this.mySupportedModifiers = new ObjectLinkedOpenHashSet(visibilityModifiers.size() + additionalModifiers.size() + 1);
        this.mySupportedModifiers.addAll(visibilityModifiers);
        this.mySupportedModifiers.addAll(additionalModifiers);
        this.mySupportedModifiers.add(StdArrangementTokens.Modifier.OVERRIDDEN);
        this.myDialect = dialect;
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return this.myDefaultSettings;
    }

    @Override
    protected boolean isAcceptableElement(@NotNull PsiElement element) {
        if (element == null) {
            ES6Rearranger.$$$reportNull$$$0(0);
        }
        return DialectDetector.isES6(element);
    }

    @Override
    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return Arrays.asList(new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER), new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.OVERRIDDEN_METHODS, (Collection)ContainerUtil.set((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME})), new CompositeArrangementSettingsToken(TREAT_LAMBDA_INITIALIZED_FIELDS_AS_METHODS));
    }

    @Override
    protected void postprocessClassMembers(@NotNull JSClass jsClass, @NotNull JSRearrangerBase.ClassArrangementInfo classArrangementInfo, @NotNull JSRearrangerBase.ArrangementInfo arrangementInfo) {
        if (jsClass == null) {
            ES6Rearranger.$$$reportNull$$$0(1);
        }
        if (classArrangementInfo == null) {
            ES6Rearranger.$$$reportNull$$$0(2);
        }
        if (arrangementInfo == null) {
            ES6Rearranger.$$$reportNull$$$0(3);
        }
        super.postprocessClassMembers(jsClass, classArrangementInfo, arrangementInfo);
        ArrangementGroupingRule groupingRule = ES6Rearranger.findGroupingRule(arrangementInfo.getSettings(), StdArrangementTokens.Grouping.OVERRIDDEN_METHODS);
        if (groupingRule != null) {
            ArrangementSettingsToken orderType = groupingRule.getOrderType();
            ES6Rearranger.processOverriddenMembers(classArrangementInfo.getMemberEntries(), classArrangementInfo.overrides, orderType);
        }
        ES6Rearranger.processDependantFields(arrangementInfo.getSettings(), classArrangementInfo.fieldToEntry, jsClass);
    }

    @Override
    @NotNull
    protected ArrangementSettingsToken detectFieldType(@NotNull ArrangementSettings settings, @NotNull JSVariable variable) {
        if (settings == null) {
            ES6Rearranger.$$$reportNull$$$0(4);
        }
        if (variable == null) {
            ES6Rearranger.$$$reportNull$$$0(5);
        }
        ArrangementSettingsToken arrangementSettingsToken = variable.getInitializer() instanceof JSFunctionExpression && ES6Rearranger.hasGroupingRule(settings, TREAT_LAMBDA_INITIALIZED_FIELDS_AS_METHODS) ? StdArrangementTokens.EntryType.METHOD : StdArrangementTokens.EntryType.FIELD;
        if (arrangementSettingsToken == null) {
            ES6Rearranger.$$$reportNull$$$0(6);
        }
        return arrangementSettingsToken;
    }

    private static void processOverriddenMembers(@NotNull Map<? extends JSNamedElement, JSElementArrangementEntry> membersMap, @NotNull MultiMap<JSClass, JSRearrangerBase.OverrideInfo> overrides, @NotNull ArrangementSettingsToken ordering) {
        if (membersMap == null) {
            ES6Rearranger.$$$reportNull$$$0(7);
        }
        if (overrides == null) {
            ES6Rearranger.$$$reportNull$$$0(8);
        }
        if (ordering == null) {
            ES6Rearranger.$$$reportNull$$$0(9);
        }
        for (Map.Entry entry : overrides.entrySet()) {
            TObjectIntHashMap superMemberIndexes = new TObjectIntHashMap();
            int index = 0;
            for (JSElement jSElement : ((JSClass)entry.getKey()).getMembers()) {
                superMemberIndexes.put((Object)jSElement, index++);
            }
            Comparator<JSRearrangerBase.OverrideInfo> comparator = ordering == StdArrangementTokens.Order.BY_NAME ? NAME_COMPARATOR : Comparator.comparing(o -> superMemberIndexes.get((Object)o.superMember));
            List<JSElementArrangementEntry> list2 = ((Collection)entry.getValue()).stream().sorted(comparator).map(arrangementInfo -> (JSElementArrangementEntry)membersMap.get(arrangementInfo.member)).filter(c -> c != null).collect(Collectors.toList());
            ES6Rearranger.setupDependenciesForOrder(list2);
        }
    }

    private static void setupDependenciesForOrder(@NotNull Collection<JSElementArrangementEntry> entries) {
        if (entries == null) {
            ES6Rearranger.$$$reportNull$$$0(10);
        }
        JSElementArrangementEntry previous = null;
        for (JSElementArrangementEntry entry : entries) {
            if (previous != null) {
                entry.addDependency((ArrangementEntry)previous);
            }
            previous = entry;
        }
    }

    private static void processDependantFields(@NotNull ArrangementSettings settings, @NotNull Map<JSField, JSElementArrangementEntry> fieldToEntry, @NotNull JSClass jsClass) {
        if (settings == null) {
            ES6Rearranger.$$$reportNull$$$0(11);
        }
        if (fieldToEntry == null) {
            ES6Rearranger.$$$reportNull$$$0(12);
        }
        if (jsClass == null) {
            ES6Rearranger.$$$reportNull$$$0(13);
        }
        HashMap<String, JSField> fieldsByName = new HashMap<String, JSField>();
        for (JSField field : fieldToEntry.keySet()) {
            fieldsByName.put(field.getName(), field);
        }
        List dependantFieldEntries = ContainerUtil.mapNotNull(fieldToEntry.entrySet(), pair -> {
            JSField field = (JSField)pair.getKey();
            List dependsOnEntries = ContainerUtil.mapNotNull(ES6Rearranger.getDependsOnFields(field, fieldsByName, jsClass), fieldToEntry::get);
            if (dependsOnEntries.isEmpty()) {
                return null;
            }
            return Pair.create((Object)((JSElementArrangementEntry)pair.getValue()), (Object)dependsOnEntries);
        });
        List rearranged = ArrangementEngine.arrange(fieldToEntry.values(), (List)settings.getSections(), (List)settings.getRulesSortedByPriority(), null);
        for (Pair entry : dependantFieldEntries) {
            int sourceEntryIndex = rearranged.indexOf(entry.first);
            for (JSElementArrangementEntry dependentEntry : (List)entry.second) {
                int dependentEntryIndex = rearranged.indexOf(dependentEntry);
                if (dependentEntryIndex <= sourceEntryIndex) continue;
                ((JSElementArrangementEntry)entry.first).addDependency((ArrangementEntry)dependentEntry);
            }
        }
    }

    @NotNull
    private static List<JSField> getDependsOnFields(@NotNull JSField source2, @NotNull Map<String, JSField> fieldsByName, @NotNull JSClass jsClass) {
        JSExpression initializer;
        if (source2 == null) {
            ES6Rearranger.$$$reportNull$$$0(14);
        }
        if (fieldsByName == null) {
            ES6Rearranger.$$$reportNull$$$0(15);
        }
        if (jsClass == null) {
            ES6Rearranger.$$$reportNull$$$0(16);
        }
        if ((initializer = JSUtils.unparenthesize(source2.getInitializer())) == null || initializer instanceof JSFunction || initializer instanceof JSClass) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ES6Rearranger.$$$reportNull$$$0(17);
            }
            return list2;
        }
        ArrayList<JSField> results = new ArrayList<JSField>();
        PsiTreeUtil.processElements((PsiElement)initializer, element -> {
            JSReferenceExpression referenceExpression;
            JSReferenceExpression jSReferenceExpression = referenceExpression = element instanceof JSReferenceExpression ? (JSReferenceExpression)element : null;
            if (referenceExpression == null) {
                return true;
            }
            JSField referenced = (JSField)fieldsByName.get(referenceExpression.getReferenceName());
            boolean isStatic = JSPsiImplUtils.hasModifier(referenced, JSAttributeList.ModifierType.STATIC);
            if (referenced != null && isStatic == JSPsiImplUtils.hasModifier(source2, JSAttributeList.ModifierType.STATIC) && ES6Rearranger.isFieldAccessQualifier(referenceExpression.getQualifier(), isStatic, jsClass)) {
                results.add(referenced);
            }
            return true;
        });
        ArrayList<JSField> arrayList = results;
        if (arrayList == null) {
            ES6Rearranger.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static boolean isFieldAccessQualifier(@Nullable JSExpression qualifier, boolean isStatic, @NotNull JSClass jsClass) {
        if (jsClass == null) {
            ES6Rearranger.$$$reportNull$$$0(19);
        }
        if (qualifier == null) {
            return false;
        }
        if (isStatic) {
            return qualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)qualifier, jsClass.getName());
        }
        return qualifier instanceof JSThisExpression;
    }

    @Override
    protected boolean isModifierEnabled(@NotNull ArrangementSettingsToken modifier, @NotNull ArrangementSettingsToken entryType, @NotNull Set<ArrangementSettingsToken> existingModifiers) {
        if (modifier == null) {
            ES6Rearranger.$$$reportNull$$$0(20);
        }
        if (entryType == null) {
            ES6Rearranger.$$$reportNull$$$0(21);
        }
        if (existingModifiers == null) {
            ES6Rearranger.$$$reportNull$$$0(22);
        }
        return (entryType == StdArrangementTokens.EntryType.METHOD || entryType == StdArrangementTokens.EntryType.FIELD || entryType == StdArrangementTokens.EntryType.PROPERTY) && modifier == StdArrangementTokens.Modifier.STATIC;
    }

    public int getBlankLines(@NotNull CodeStyleSettings settings, @Nullable JSArrangementEntry parent, @Nullable JSArrangementEntry previous, @NotNull JSArrangementEntry target) {
        if (settings == null) {
            ES6Rearranger.$$$reportNull$$$0(23);
        }
        if (target == null) {
            ES6Rearranger.$$$reportNull$$$0(24);
        }
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)this.myDialect);
        JSElementArrangementEntry targetElement = (JSElementArrangementEntry)ObjectUtils.tryCast((Object)target, JSElementArrangementEntry.class);
        JSElementArrangementEntry previousElement = (JSElementArrangementEntry)ObjectUtils.tryCast((Object)previous, JSElementArrangementEntry.class);
        JSElementArrangementEntry parentElement = (JSElementArrangementEntry)ObjectUtils.tryCast((Object)parent, JSElementArrangementEntry.class);
        if (targetElement != null && previousElement != null) {
            return Math.max(this.getBlankLines(commonSettings, targetElement.getType(), parentElement), this.getBlankLines(commonSettings, previousElement.getType(), parentElement));
        }
        return -1;
    }

    protected int getBlankLines(@NotNull CommonCodeStyleSettings commonSettings, @Nullable ArrangementSettingsToken type, @Nullable JSElementArrangementEntry parent) {
        if (commonSettings == null) {
            ES6Rearranger.$$$reportNull$$$0(25);
        }
        return type == StdArrangementTokens.EntryType.FIELD ? commonSettings.BLANK_LINES_AROUND_FIELD : commonSettings.BLANK_LINES_AROUND_METHOD;
    }

    @NotNull
    public final ArrangementSettingsSerializer getSerializer() {
        DefaultArrangementSettingsSerializer defaultArrangementSettingsSerializer = this.mySettingsSerializer;
        if (defaultArrangementSettingsSerializer == null) {
            ES6Rearranger.$$$reportNull$$$0(26);
        }
        return defaultArrangementSettingsSerializer;
    }

    @Override
    @NotNull
    protected final Set<ArrangementSettingsToken> getSupportedTypes() {
        Set<ArrangementSettingsToken> set = SUPPORTED_TYPES;
        if (set == null) {
            ES6Rearranger.$$$reportNull$$$0(27);
        }
        return set;
    }

    @Override
    @NotNull
    protected final Set<ArrangementSettingsToken> getVisibilityModifiers() {
        Set<ArrangementSettingsToken> set = this.myVisibilityModifiers;
        if (set == null) {
            ES6Rearranger.$$$reportNull$$$0(28);
        }
        return set;
    }

    @Override
    @NotNull
    protected final Set<ArrangementSettingsToken> getSupportedModifiers() {
        Set<ArrangementSettingsToken> set = this.mySupportedModifiers;
        if (set == null) {
            ES6Rearranger.$$$reportNull$$$0(29);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<ArrangementSettingsToken> detectModifiers(@NotNull JSAttributeListOwner fieldOrMethod) {
        HashSet<ArrangementSettingsToken> result2;
        JSAttributeList attributes;
        block12: {
            block11: {
                if (fieldOrMethod == null) {
                    ES6Rearranger.$$$reportNull$$$0(30);
                }
                if ((attributes = fieldOrMethod.getAttributeList()) == null) {
                    HashSet hashSet = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Modifier.PUBLIC});
                    if (hashSet == null) {
                        ES6Rearranger.$$$reportNull$$$0(31);
                    }
                    return hashSet;
                }
                result2 = new HashSet<ArrangementSettingsToken>();
                JSAttributeList.AccessType accessType = attributes.getExplicitAccessType();
                if (accessType == null) break block11;
                switch (accessType) {
                    case PUBLIC: {
                        result2.add(StdArrangementTokens.Modifier.PUBLIC);
                        break block12;
                    }
                    case PROTECTED: {
                        result2.add(StdArrangementTokens.Modifier.PROTECTED);
                        break block12;
                    }
                    case PRIVATE: {
                        result2.add(StdArrangementTokens.Modifier.PRIVATE);
                        break block12;
                    }
                    default: {
                        throw new RuntimeException("Unknown accessType " + accessType);
                    }
                }
            }
            result2.add(StdArrangementTokens.Modifier.PUBLIC);
        }
        if (attributes.hasModifier(JSAttributeList.ModifierType.STATIC)) {
            result2.add(StdArrangementTokens.Modifier.STATIC);
        }
        if (attributes.hasModifier(JSAttributeList.ModifierType.READONLY)) {
            result2.add(StdArrangementTokens.Modifier.READONLY);
        }
        HashSet<ArrangementSettingsToken> hashSet = result2;
        if (hashSet == null) {
            ES6Rearranger.$$$reportNull$$$0(32);
        }
        return hashSet;
    }

    @Override
    protected List<JSRearrangerBase.OverrideInfo> detectOverrides(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            ES6Rearranger.$$$reportNull$$$0(33);
        }
        ArrayList<JSPsiElementBase> superMembers = new ArrayList<JSPsiElementBase>(JSInheritanceUtil.findImplementedMembers(member));
        JSInheritanceUtil.iterateOverriddenMembersUp(member, true, (overridden, superType) -> {
            superMembers.addAll((Collection<JSPsiElementBase>)overridden);
            return true;
        }, false);
        return ContainerUtil.map(superMembers, superMember -> new JSRearrangerBase.OverrideInfo(member, (JSPsiElementBase)superMember));
    }

    public List<StdArrangementMatchRule> getDefaultMatchRules() {
        return ES6Rearranger.getDefaultMatchRules(this.myVisibilityModifiers);
    }

    @NotNull
    private DefaultArrangementSettingsSerializer createCustomTokensSerializer() {
        DefaultArrangementSettingsSerializer.Mixin customGroupingTokenMixin = id -> {
            if (StringUtil.equals((CharSequence)id, (CharSequence)TREAT_LAMBDA_INITIALIZED_FIELDS_AS_METHODS.getId())) {
                return TREAT_LAMBDA_INITIALIZED_FIELDS_AS_METHODS;
            }
            return null;
        };
        return new DefaultArrangementSettingsSerializer(customGroupingTokenMixin, this.myDefaultSettings);
    }

    @NotNull
    private static List<StdArrangementMatchRule> getDefaultMatchRules(@NotNull Collection<ArrangementSettingsToken> visibilityModifiers) {
        if (visibilityModifiers == null) {
            ES6Rearranger.$$$reportNull$$$0(34);
        }
        ArrayList<StdArrangementMatchRule> matchRules = new ArrayList<StdArrangementMatchRule>();
        ES6Rearranger.addRules(matchRules, StdArrangementTokens.EntryType.FIELD, visibilityModifiers);
        ES6Rearranger.addRule(matchRules, StdArrangementTokens.EntryType.CONSTRUCTOR);
        ES6Rearranger.addRules(matchRules, StdArrangementTokens.EntryType.PROPERTY, visibilityModifiers);
        ES6Rearranger.addRules(matchRules, StdArrangementTokens.EntryType.METHOD, visibilityModifiers);
        ArrayList<StdArrangementMatchRule> arrayList = matchRules;
        if (arrayList == null) {
            ES6Rearranger.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    private static void addRules(@NotNull List<StdArrangementMatchRule> matchRules, @NotNull ArrangementSettingsToken type, @NotNull Collection<ArrangementSettingsToken> visibilityModifiers) {
        if (matchRules == null) {
            ES6Rearranger.$$$reportNull$$$0(36);
        }
        if (type == null) {
            ES6Rearranger.$$$reportNull$$$0(37);
        }
        if (visibilityModifiers == null) {
            ES6Rearranger.$$$reportNull$$$0(38);
        }
        if (visibilityModifiers.isEmpty()) {
            ES6Rearranger.addRule(matchRules, type, StdArrangementTokens.Modifier.STATIC);
            ES6Rearranger.addRule(matchRules, type);
        } else {
            for (ArrangementSettingsToken modifier : visibilityModifiers) {
                ES6Rearranger.addRule(matchRules, type, modifier, StdArrangementTokens.Modifier.STATIC);
            }
            for (ArrangementSettingsToken modifier : visibilityModifiers) {
                ES6Rearranger.addRule(matchRules, type, modifier);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classArrangementInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrangementInfo";
                break;
            }
            case 4: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 6: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/arrangement/ES6Rearranger";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overrides";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldToEntry";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldsByName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingModifiers";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldOrMethod";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityModifiers";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchRules";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/arrangement/ES6Rearranger";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFieldType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependsOnFields";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializer";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedTypes";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityModifiers";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedModifiers";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "detectModifiers";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMatchRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "postprocessClassMembers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectFieldType";
                break;
            }
            case 6: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processOverriddenMembers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setupDependenciesForOrder";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processDependantFields";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDependsOnFields";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isFieldAccessQualifier";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isModifierEnabled";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBlankLines";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "detectModifiers";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "detectOverrides";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultMatchRules";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addRules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 17: 
            case 18: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

