/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.lang.javascript.buildTools.base.JsbtEventAdapter;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsBuildToolPackageJson", storages={@Storage(value="$CACHE_FILE$")})
public final class PackageJsonBuildFileManager
extends JsbtFileManager
implements PersistentStateComponent<Element> {
    private static final String DETECTION_DONE_ATTR = "detection-done";
    private static final String SORTING_ATTR = "sorting";
    private static final String PACKAGE_JSON_TAG = "package-json";
    private final ClearableLazyValue<List<VirtualFile>> mySortedPackageJsonFiles;
    private final Project myProject;
    private volatile List<VirtualFile> myPackageJsonFileFromConfiguration;

    public PackageJsonBuildFileManager(@NotNull Project project) {
        if (project == null) {
            PackageJsonBuildFileManager.$$$reportNull$$$0(0);
        }
        super(project, NpmScriptsService.getInstance(project));
        this.mySortedPackageJsonFiles = ClearableLazyValue.createAtomic(() -> this.computeAndSortPackageJsonFiles());
        this.myProject = project;
        this.addListener(new JsbtEventAdapter(){

            @Override
            public void onBuildfileChanged(@NotNull VirtualFile oldBuildfile, @NotNull VirtualFile newBuildfile) {
                if (oldBuildfile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newBuildfile == null) {
                    1.$$$reportNull$$$0(1);
                }
                PackageJsonBuildFileManager.this.mySortedPackageJsonFiles.drop();
            }

            @Override
            public void onBuildfileAdded(@NotNull VirtualFile buildfile) {
                if (buildfile == null) {
                    1.$$$reportNull$$$0(2);
                }
                PackageJsonBuildFileManager.this.mySortedPackageJsonFiles.drop();
            }

            @Override
            public void onBuildfileRemoved(@NotNull VirtualFile buildfile) {
                if (buildfile == null) {
                    1.$$$reportNull$$$0(3);
                }
                PackageJsonBuildFileManager.this.mySortedPackageJsonFiles.drop();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldBuildfile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newBuildfile";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "buildfile";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonBuildFileManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBuildfileChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBuildfileAdded";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBuildfileRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
    }

    public void setPackageJsonFilesFromConfiguration(@NotNull List<VirtualFile> packageJsonFilesFromConfiguration) {
        if (packageJsonFilesFromConfiguration == null) {
            PackageJsonBuildFileManager.$$$reportNull$$$0(1);
        }
        this.myPackageJsonFileFromConfiguration = packageJsonFilesFromConfiguration;
        this.mySortedPackageJsonFiles.drop();
    }

    @NotNull
    public static PackageJsonBuildFileManager getInstance(@NotNull Project project) {
        if (project == null) {
            PackageJsonBuildFileManager.$$$reportNull$$$0(2);
        }
        PackageJsonBuildFileManager packageJsonBuildFileManager = (PackageJsonBuildFileManager)project.getService(PackageJsonBuildFileManager.class);
        if (packageJsonBuildFileManager == null) {
            PackageJsonBuildFileManager.$$$reportNull$$$0(3);
        }
        return packageJsonBuildFileManager;
    }

    @Override
    @Nullable
    public NpmScriptsStructure getCachedStructure(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonBuildFileManager.$$$reportNull$$$0(4);
        }
        return (NpmScriptsStructure)super.getCachedStructure(packageJson);
    }

    @Override
    protected boolean shouldSaveAllDocumentBeforeFetch() {
        return false;
    }

    @NotNull
    public Element getState() {
        Element parent = new Element("package-json-files");
        if (this.isDetectionDone()) {
            parent.setAttribute(DETECTION_DONE_ATTR, Boolean.TRUE.toString());
        }
        parent.setAttribute(SORTING_ATTR, this.getSortingMode().name());
        List paths = ContainerUtil.map(this.getBuildfiles(), file2 -> file2.getPath());
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)parent, (String)PACKAGE_JSON_TAG, (List)paths);
        Element element = parent;
        if (element == null) {
            PackageJsonBuildFileManager.$$$reportNull$$$0(5);
        }
        return element;
    }

    public void loadState(@NotNull Element parent) {
        if (parent == null) {
            PackageJsonBuildFileManager.$$$reportNull$$$0(6);
        }
        this.clearAllBuildfiles();
        if (Boolean.parseBoolean(parent.getAttributeValue(DETECTION_DONE_ATTR))) {
            this.setDetectionDone();
        }
        this.setSortingMode(JsbtSortingMode.findByName(parent.getAttributeValue(SORTING_ATTR), JsbtSortingMode.DEFINITION_ORDER));
        List paths = JDOMExternalizerUtil.getChildrenValueAttributes((Element)parent, (String)PACKAGE_JSON_TAG);
        for (String path2 : paths) {
            VirtualFile packageJson;
            if (!StringUtil.isNotEmpty((String)path2) || (packageJson = LocalFileSystem.getInstance().findFileByPath(path2)) == null || !packageJson.isValid() || packageJson.isDirectory()) continue;
            this.addBuildfileStructure(new NpmScriptsStructure(packageJson));
        }
    }

    @NotNull
    public List<VirtualFile> getPackageJsonSortedByImportanceDesc() {
        List result2 = (List)this.mySortedPackageJsonFiles.getValue();
        VirtualFile first = (VirtualFile)ContainerUtil.getFirstItem((List)result2);
        if (first != null && !first.isValid()) {
            this.mySortedPackageJsonFiles.drop();
            List list2 = (List)this.mySortedPackageJsonFiles.getValue();
            if (list2 == null) {
                PackageJsonBuildFileManager.$$$reportNull$$$0(7);
            }
            return list2;
        }
        List list3 = result2;
        if (list3 == null) {
            PackageJsonBuildFileManager.$$$reportNull$$$0(8);
        }
        return list3;
    }

    @NotNull
    private List<VirtualFile> computeAndSortPackageJsonFiles() {
        List list2 = (List)ReadAction.compute(() -> {
            List<VirtualFile> result2;
            List<VirtualFile> files = this.myPackageJsonFileFromConfiguration;
            if (files != null && !(result2 = this.sort(files)).isEmpty()) {
                return result2;
            }
            return this.sort(this.getBuildfiles());
        });
        if (list2 == null) {
            PackageJsonBuildFileManager.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    private List<VirtualFile> sort(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            PackageJsonBuildFileManager.$$$reportNull$$$0(10);
        }
        if (files.isEmpty() || this.myProject.isDisposed()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                PackageJsonBuildFileManager.$$$reportNull$$$0(11);
            }
            return list2;
        }
        VirtualFile root = ProjectUtil.guessProjectDir((Project)this.myProject);
        AtomicInteger order = new AtomicInteger(0);
        List orderedFiles = ContainerUtil.mapNotNull(files, packageJson -> {
            String relativePath;
            if (!packageJson.isValid()) {
                return null;
            }
            VirtualFile parent = packageJson.getParent();
            if (parent == null) {
                return null;
            }
            int depth = 1000;
            if (root != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)packageJson, (VirtualFile)root, (char)'/')) != null) {
                depth = StringUtil.countChars((CharSequence)relativePath, (char)'/');
            }
            return new OrderedPackageJson((VirtualFile)packageJson, depth, order.incrementAndGet());
        });
        orderedFiles.sort((o1, o2) -> {
            if (o1.myDepth == 0 || o2.myDepth == 0) {
                return o1.myDepth - o2.myDepth;
            }
            return o1.myNaturalOrder - o2.myNaturalOrder;
        });
        List list3 = ContainerUtil.map((Collection)orderedFiles, orderedFile -> orderedFile.myPackageJson);
        if (list3 == null) {
            PackageJsonBuildFileManager.$$$reportNull$$$0(12);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFilesFromConfiguration";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonBuildFileManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonBuildFileManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageJsonSortedByImportanceDesc";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAndSortPackageJsonFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "sort";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPackageJsonFilesFromConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCachedStructure";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OrderedPackageJson {
        private final VirtualFile myPackageJson;
        private final int myDepth;
        private final int myNaturalOrder;

        private OrderedPackageJson(@NotNull VirtualFile packageJson, int depth, int naturalOrder) {
            if (packageJson == null) {
                OrderedPackageJson.$$$reportNull$$$0(0);
            }
            this.myPackageJson = packageJson;
            this.myDepth = depth;
            this.myNaturalOrder = naturalOrder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/PackageJsonBuildFileManager$OrderedPackageJson", "<init>"));
        }
    }
}

