/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectsMappings;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsFlowSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FlowJSSettingsManager
implements PersistentStateComponent<FlowJSSettings> {
    @NotNull
    private volatile FlowJSSettings myFlowSettings = new FlowJSSettings();

    @NotNull
    public FlowJSSettings getState() {
        FlowJSSettings flowJSSettings = this.myFlowSettings;
        if (flowJSSettings == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(0);
        }
        return flowJSSettings;
    }

    public void loadState(@NotNull FlowJSSettings state2) {
        if (state2 == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(1);
        }
        this.myFlowSettings = state2;
    }

    @NotNull
    public FlowJSSettings getRawSettings() {
        FlowJSSettings flowJSSettings = this.myFlowSettings;
        if (flowJSSettings == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(2);
        }
        return flowJSSettings;
    }

    private static boolean hasFlowVersionConfigured(@NotNull Project project) {
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(3);
        }
        return JSRootConfiguration.getInstance(project).getLanguageLevel() == JSLanguageLevel.FLOW || JSDialectsMappings.getInstance(project).getMappings().containsValue(JSLanguageLevel.FLOW.getId());
    }

    public static boolean isTypeCheckingEnabled(@Nullable PsiFile file2, @NotNull Project project) {
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(4);
        }
        if (file2 == null && !FlowJSSettingsManager.hasFlowVersionConfigured(project)) {
            return false;
        }
        if (file2 != null && file2.getLanguage() != JavaScriptSupportLoader.FLOW_JS) {
            return false;
        }
        FlowJSSettings settings = FlowJSSettingsManager.getInstance(project).getRawSettings();
        return settings.getFlowExecutable() != null && settings.isTypeCheckingEnabled();
    }

    @Nullable
    public static FlowJSSettings.FlowJSExecutable getFlowExecutable(@Nullable PsiFile file2, @NotNull Project project) {
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(5);
        }
        if (!FlowJSSettingsManager.isTypeCheckingEnabled(file2, project)) {
            return null;
        }
        return FlowJSSettingsManager.getInstance(project).getRawSettings().getFlowExecutable();
    }

    public static boolean areOtherServicesEnabled(@NotNull PsiFile file2) {
        Project project;
        if (file2 == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(6);
        }
        return FlowJSSettingsManager.isTypeCheckingEnabled(file2, project = file2.getProject()) && FlowJSSettingsManager.getInstance(project).getRawSettings().isOtherServicesEnabled();
    }

    public static boolean isAutoSaveEnabled(@NotNull Project project) {
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(7);
        }
        return FlowJSSettingsManager.getInstance(project).getRawSettings().isAutoSaveEnabled();
    }

    public static FlowJSSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlowJSSettingsManager.$$$reportNull$$$0(8);
        }
        return (FlowJSSettingsManager)project.getService(FlowJSSettingsManager.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSSettingsManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSSettingsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasFlowVersionConfigured";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTypeCheckingEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFlowExecutable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "areOtherServicesEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAutoSaveEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

