/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLineWrapPositionStrategy
implements LineWrapPositionStrategy {
    public int calculateWrapPosition(@NotNull Document document2, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        if (document2 == null) {
            JSLineWrapPositionStrategy.$$$reportNull$$$0(0);
        }
        if (isSoftWrap) {
            LineWrapPositionStrategy implementation = LanguageLineWrapPositionStrategy.INSTANCE.getDefaultImplementation();
            return implementation.calculateWrapPosition(document2, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, true);
        }
        return JSLineWrapPositionStrategy.calcWrapPosition(document2, project, maxPreferredOffset);
    }

    private static int calcWrapPosition(@NotNull Document document2, @Nullable Project project, int wrapOffset) {
        if (document2 == null) {
            JSLineWrapPositionStrategy.$$$reportNull$$$0(1);
        }
        if (project != null) {
            PsiElement currElement;
            PsiElement elementToWrap;
            PsiFile file2;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            if (documentManager.isUncommited(document2)) {
                documentManager.commitDocument(document2);
            }
            if ((file2 = documentManager.getPsiFile(document2)) != null && (elementToWrap = JSLineWrapPositionStrategy.getElementToWrapAsText(currElement = file2.findElementAt(wrapOffset))) != null) {
                return JSLineWrapPositionStrategy.getCommentWrapPos(elementToWrap, wrapOffset);
            }
        }
        return -1;
    }

    @Nullable
    private static PsiElement getElementToWrapAsText(@Nullable PsiElement element) {
        if (element != null) {
            if (element instanceof PsiComment || element.getNode().getElementType() == JSTokenTypes.STRING_LITERAL) {
                return element;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof JSDocComment) {
                return parent;
            }
        }
        return null;
    }

    private static int getCommentWrapPos(@NotNull PsiElement elementToWrap, int wrapOffset) {
        if (elementToWrap == null) {
            JSLineWrapPositionStrategy.$$$reportNull$$$0(2);
        }
        CharSequence chars = elementToWrap.getNode().getChars();
        int startOffset = elementToWrap.getTextRange().getStartOffset();
        int lastSpaceStart = -1;
        int prev = 0;
        for (int i2 = 0; i2 < chars.length() && i2 < wrapOffset - startOffset; ++i2) {
            char c = chars.charAt(i2);
            if ((c == ' ' || c == '\t') && prev != 32 && prev != 9) {
                lastSpaceStart = i2;
            }
            prev = c;
        }
        if (lastSpaceStart > 2) {
            return startOffset + lastSpaceStart;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToWrap";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/JSLineWrapPositionStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateWrapPosition";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calcWrapPosition";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentWrapPos";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

