/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReactTagNameReference
extends TagNameReference
implements PsiPolyVariantReference {
    private static final ResolveCache.AbstractResolver<ReactTagNameReference, ResolveResult[]> RESOLVER = (reference, incompleteCode) -> {
        XmlTag tag = reference.getTagElement();
        assert (tag != null);
        if (ReactXmlExtension.hasQualifiedName(tag)) {
            return ReactXmlExtension.resolveQualifiedComponent(tag);
        }
        return ReactXmlExtension.resolveTopLevelTagOrComponent(tag);
    };

    ReactTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        super(nameElement, startTagFlag);
    }

    protected int getPrefixIndex(@NotNull String name) {
        if (name == null) {
            ReactTagNameReference.$$$reportNull$$$0(0);
        }
        return name.lastIndexOf(".");
    }

    protected String prependNamespacePrefix(String newElementName, String namespacePrefix) {
        newElementName = (String)(!namespacePrefix.isEmpty() ? namespacePrefix + "." : namespacePrefix) + (String)newElementName;
        return newElementName;
    }

    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length > 0 ? results[0].getElement() : null;
    }

    @Nullable
    public XmlTag getTagElement() {
        return super.getTagElement();
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        XmlTag tag = this.getTagElement();
        if (ReactXmlExtension.nonJsxTag(tag)) {
            return ReactTagNameReference.toResults(super.resolve());
        }
        ResolveResult[] elements = (ResolveResult[])ResolveCache.getInstance((Project)tag.getProject()).resolveWithCaching((PsiReference)this, RESOLVER, false, false);
        ResolveResult[] resolveResultArray = elements == null || elements.length == 0 ? ReactTagNameReference.toResults(super.resolve()) : elements;
        if (resolveResultArray == null) {
            ReactTagNameReference.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    private static ResolveResult @NotNull [] toResults(@Nullable PsiElement resolve) {
        if (resolve == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ReactTagNameReference.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(resolve)};
        if (resolveResultArray == null) {
            ReactTagNameReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactTagNameReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactTagNameReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixIndex";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

