/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.util.PlatformUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaScriptColorsAndFontsPage
implements RainbowColorSettingsPage,
DisplayPrioritySortable {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.keyword", new Object[0]), JSHighlighter.JS_KEYWORD), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.string", new Object[0]), JSHighlighter.JS_STRING), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.valid.string.escape", new Object[0]), JSHighlighter.JS_VALID_STRING_ESCAPE), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.invalid.string.escape", new Object[0]), JSHighlighter.JS_INVALID_STRING_ESCAPE), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.number", new Object[0]), JSHighlighter.JS_NUMBER), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.regexp", new Object[0]), JSHighlighter.JS_REGEXP), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.linecomment", new Object[0]), JSHighlighter.JS_LINE_COMMENT), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.blockcomment", new Object[0]), JSHighlighter.JS_BLOCK_COMMENT), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.operation", new Object[0]), JSHighlighter.JS_OPERATION_SIGN), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.parens", new Object[0]), JSHighlighter.JS_PARENTHS), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.brackets", new Object[0]), JSHighlighter.JS_BRACKETS), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.braces", new Object[0]), JSHighlighter.JS_BRACES), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.comma", new Object[0]), JSHighlighter.JS_COMMA), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.dot", new Object[0]), JSHighlighter.JS_DOT), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.semicolon", new Object[0]), JSHighlighter.JS_SEMICOLON), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.badcharacter", new Object[0]), JSHighlighter.JS_BAD_CHARACTER), new AttributesDescriptor(JavaScriptBundle.messagePointer("jsdoc.text", new Object[0]), JSHighlighter.JS_DOC_COMMENT), new AttributesDescriptor(JavaScriptBundle.messagePointer("jsdoc.tag", new Object[0]), JSHighlighter.JS_DOC_TAG), new AttributesDescriptor(JavaScriptBundle.messagePointer("jsdoc.tag.value", new Object[0]), JSHighlighter.JS_DOC_TAG_VALUE), new AttributesDescriptor(JavaScriptBundle.messagePointer("jsdoc.type", new Object[0]), JSHighlighter.JS_DOC_TYPE), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.parameter", new Object[0]), JSHighlighter.JS_PARAMETER), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.local.variable", new Object[0]), JSHighlighter.JS_LOCAL_VARIABLE), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.global.variable", new Object[0]), JSHighlighter.JS_GLOBAL_VARIABLE), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.global.function", new Object[0]), JSHighlighter.JS_GLOBAL_FUNCTION), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.local.function", new Object[0]), JSHighlighter.JS_LOCAL_FUNCTION), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.global.decorator", new Object[0]), JSHighlighter.ES6_DECORATOR), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.instance.member.function", new Object[0]), JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.static.member.function", new Object[0]), JSHighlighter.JS_STATIC_MEMBER_FUNCTION), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.static.member.variable", new Object[0]), JSHighlighter.JS_STATIC_MEMBER_VARIABLE), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.module.name", new Object[0]), JSHighlighter.JS_MODULE_NAME), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.instance.member.variable", new Object[0]), JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.class", new Object[0]), JSHighlighter.JS_CLASS), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.label", new Object[0]), JSHighlighter.JS_LABEL), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.function.arrow", new Object[0]), JSHighlighter.FUNCTION_ARROW), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.interface", new Object[0]), JSHighlighter.JS_INTERFACE), new AttributesDescriptor(JavaScriptBundle.messagePointer("typescript.type.alias.name", new Object[0]), JSHighlighter.JS_TYPE_ALIAS), new AttributesDescriptor(JavaScriptBundle.messagePointer("typescript.primitive.types.name", new Object[0]), JSHighlighter.JS_PRIMITIVE_TYPE), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.exported.variable", new Object[0]), JSHighlighter.JS_EXPORTED_VARIABLE), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.exported.function", new Object[0]), JSHighlighter.JS_EXPORTED_FUNCTION), new AttributesDescriptor(JavaScriptBundle.messagePointer("javascript.exported.class", new Object[0]), JSHighlighter.JS_EXPORTED_CLASS), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.any.color.descriptor.injected.language.fragment", (Object[])new Object[0]), JSHighlighter.JS_INJECTED_LANGUAGE_FRAGMENT)};
    @NonNls
    private static final Map<String, TextAttributesKey> ADDITIONAL_HIGHLIGHT_DESCRIPTORS = new HashMap<String, TextAttributesKey>();

    JavaScriptColorsAndFontsPage() {
    }

    @NotNull
    public String getDisplayName() {
        return "JavaScript";
    }

    public Icon getIcon() {
        return JavaScriptSupportLoader.JAVASCRIPT.getIcon();
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        if (ATTRS == null) {
            JavaScriptColorsAndFontsPage.$$$reportNull$$$0(0);
        }
        return ATTRS;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            JavaScriptColorsAndFontsPage.$$$reportNull$$$0(1);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)JavaScriptSupportLoader.JAVASCRIPT, null, null);
        assert (highlighter != null);
        SyntaxHighlighter syntaxHighlighter = highlighter;
        if (syntaxHighlighter == null) {
            JavaScriptColorsAndFontsPage.$$$reportNull$$$0(2);
        }
        return syntaxHighlighter;
    }

    @NotNull
    public String getDemoText() {
        return "<keyword>var</keyword> <global_variable>globalVar</global_variable>;\n/**\n * Constructor for AjaxRequest class\n * <doc_tag>@param</doc_tag> <doc_type>{string}</doc_type> <doc_tag_value>url</doc_tag_value> the url for the request<p/>\n */\n<keyword>function</keyword> <global_function>AjaxRequest</global_function>(<parameter>url</parameter>) {\n  <keyword>function</keyword> <local_function>local</local_function>() {}\n  <keyword>var</keyword> <local_variable>urls</local_variable> = [ \"www.cnn.com\", 5, <global_variable>globalVar</global_variable>];\n  <keyword>this</keyword>.<instance_variable>request</instance_variable> = <keyword>new</keyword> <global_function>XMLHttpRequest</global_function>();\n  <parameter>url</parameter> = <parameter>url</parameter>.replace(/^\\s*(.*)/, \"$1\"); // skip leading whitespace\n  /* check the url to be in urls */\n  <keyword>var</keyword> <local_variable>a</local_variable> = \"\\u1111\\z\\n\\u11\";\n  <keyword>this</keyword>.<instance_method>foo</instance_method> = <keyword>new</keyword> <keyword>function</keyword>() {};\n  <instance_method>foo</instance_method>();\n  #\n  <keyword>var</keyword> <local_variable>hello</local_variable> = () <function_arrow>=></function_arrow> console.<instance_method>log</instance_method>(\"hello\")}\n\n<es6_decorator>@decorator</es6_decorator>()\n<keyword>class</keyword> <class_name>NameClass</class_name> {\n}\n<keyword>declare</keyword> <keyword>module</keyword> <module_name>name</module_name>{\n  <keyword>declare</keyword> <keyword>export</keyword> <keyword>var</keyword> <exported_variable>exportedVar</exported_variable>: <primitive_type>string</primitive_type>;\n  <keyword>declare</keyword> <keyword>export</keyword> <keyword>function</keyword> <exported_function>exportedFunction</exported_function>(): <primitive_type>void</primitive_type>;\n  <keyword>declare</keyword> <keyword>export</keyword> <keyword>class</keyword> <exported_class>ExportedClass</exported_class> {}\n}\n<keyword>interface</keyword> <interface>MyInterface</interface> { }\n<keyword>type</keyword> <type_alias>FooBarAlias</type_alias> = <primitive_type>string</primitive_type>;\n<keyword>var</keyword> <global_variable>html</global_variable> =`<injected_fragment><html_tag><<html_tag_name>div</html_tag_name> <html_attr_name>title</html_attr_name><html_attr_value>='HTML injection'</html_attr_value>></html_tag>Injected language fragment<html_tag></<html_tag_name>div</html_tag_name>></html_tag></injected_fragment>`;\n<keyword>var</keyword> <global_variable>x</global_variable>: <interface>MyInterface</interface>, <global_variable>y</global_variable>: <primitive_type>string</primitive_type>, <global_variable>z</global_variable>: <type_alias>FooBarAlias</type_alias>;\n";
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ADDITIONAL_HIGHLIGHT_DESCRIPTORS;
    }

    public DisplayPriority getPriority() {
        return PlatformUtils.isWebStorm() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    public boolean isRainbowType(TextAttributesKey type) {
        return JSHighlighter.JS_PARAMETER.equals((Object)type) || JSHighlighter.JS_LOCAL_VARIABLE.equals((Object)type) || JSHighlighter.JS_GLOBAL_VARIABLE.equals((Object)type);
    }

    @Nullable
    public Language getLanguage() {
        return JavascriptLanguage.INSTANCE;
    }

    static {
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("keyword", JSHighlighter.JS_KEYWORD);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("local_variable", JSHighlighter.JS_LOCAL_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("global_variable", JSHighlighter.JS_GLOBAL_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("instance_variable", JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("instance_method", JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("global_function", JSHighlighter.JS_GLOBAL_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("local_function", JSHighlighter.JS_LOCAL_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("parameter", JSHighlighter.JS_PARAMETER);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("module_name", JSHighlighter.JS_MODULE_NAME);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("class_name", JSHighlighter.JS_CLASS);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("function_arrow", JSHighlighter.FUNCTION_ARROW);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("es6_decorator", JSHighlighter.ES6_DECORATOR);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("interface", JSHighlighter.JS_INTERFACE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("type_alias", JSHighlighter.JS_TYPE_ALIAS);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("primitive_type", JSHighlighter.JS_PRIMITIVE_TYPE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("exported_function", JSHighlighter.JS_EXPORTED_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("exported_variable", JSHighlighter.JS_EXPORTED_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("exported_class", JSHighlighter.JS_EXPORTED_CLASS);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("injected_fragment", JSHighlighter.JS_INJECTED_LANGUAGE_FRAGMENT);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("html_tag", XmlHighlighterColors.HTML_TAG);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("html_tag_name", XmlHighlighterColors.HTML_TAG_NAME);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("html_attr_name", XmlHighlighterColors.HTML_ATTRIBUTE_NAME);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("html_attr_value", XmlHighlighterColors.HTML_ATTRIBUTE_VALUE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("doc_tag", JSHighlighter.JS_DOC_TAG);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("doc_tag_value", JSHighlighter.JS_DOC_TAG_VALUE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("doc_type", JSHighlighter.JS_DOC_TYPE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/highlighting/JavaScriptColorsAndFontsPage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

