/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSInheritanceCallEvaluator;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReferenceItem;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.types.JSLiteralExpressionElementType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSSymbolUtil {
    @NonNls
    public static final String J_QUERY_VAR_NAME = "jQuery";
    @NonNls
    static final String FN_FUN_NAME = "fn";
    @NonNls
    public static final String YAHOO_NAME = "YAHOO";
    public static final String WINDOW_OBJECT_NAME = "window";
    public static final String NODE_GLOBAL_OBJECT_NAME = "global";
    public static final String GLOBAL_OBJECT_NAME3 = "GLOBAL";
    public static final String GLOBAL_THIS_NAME = "globalThis";
    public static final Collection<String> GLOBAL_TYPE_QUALIFIED_NAMES = ContainerUtil.immutableList((Object[])new String[]{"Window", "NodeJS.Global"});
    public static final Collection<JSQualifiedName> GLOBAL_TYPES = ContainerUtil.map(GLOBAL_TYPE_QUALIFIED_NAMES, JSQualifiedNameImpl::fromQualifiedName);
    public static final Set<String> GLOBAL_OBJECT_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"window", "global", "GLOBAL", "globalThis"});
    public static final String EXPORTS = "exports";
    public static final String MODULE = "module";
    public static final String MODULE_EXPORTS = "module.exports";
    public static final String DEFINE_METHOD_NAME = "define";
    public static final String REQUIRE_METHOD_NAME = "require";
    public static final String DECLARE_METHOD_NAME = "declare";
    public static final String REGEXP_RESULT_GROUPS_PROPERTY_NAME = "groups";
    public static final String BIND_FUNCTION_NAME = "bind";
    public static final String WEBPACK_EXTEND_METHOD_NAME = "exportPlugins";
    private static final Key<CachedValue<Map<JSReferenceExpression, JSNamespace>>> cachedClassExtendingKey = Key.create((String)"cached.class.extending");

    public static JSExpression[] findClassesNames(JSExpression value) {
        JSExpression firstArg;
        JSExpression[] arguments;
        JSArgumentList list2;
        if (value instanceof JSReferenceExpression || value instanceof JSLiteralExpression) {
            return new JSExpression[]{value};
        }
        if (value instanceof JSArrayLiteralExpression) {
            return ((JSArrayLiteralExpression)value).getExpressions();
        }
        if (value instanceof JSCallExpression && (list2 = ((JSCallExpression)value).getArgumentList()) != null && (arguments = list2.getArguments()).length > 0 && (firstArg = arguments[0]) instanceof JSObjectLiteralExpression) {
            JSProperty[] properties2 = ((JSObjectLiteralExpression)firstArg).getProperties();
            JSExpression[] extendList = new JSExpression[properties2.length];
            for (int i2 = 0; i2 < properties2.length; ++i2) {
                extendList[i2] = properties2[i2].getValue();
            }
            return extendList;
        }
        return JSExpression.EMPTY_ARRAY;
    }

    public static boolean isDefinitelyConstructor(@Nullable PsiElement resolve) {
        if (resolve == null) {
            return false;
        }
        JSFunctionItem functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve, null, true);
        if (functionItem instanceof JSFunction) {
            return ((JSFunction)functionItem).isConstructor();
        }
        JSDocComment docComment = JSStubBasedPsiTreeUtil.findDocComment(resolve);
        if (docComment != null && docComment.isClassExplicitly()) {
            return true;
        }
        if (resolve instanceof JSInitializerOwner) {
            resolve = ((JSInitializerOwner)resolve).getInitializerOrStub();
        }
        return resolve instanceof JSClass;
    }

    public static boolean isConstructorName(String name) {
        if ("constructor".equals(name)) {
            return true;
        }
        return name != null && !name.isEmpty() && Character.isUpperCase(name.charAt(0));
    }

    public static boolean isConstructorSymbol(@NotNull JSPsiElementBase function2) {
        if (function2 == null) {
            JSSymbolUtil.$$$reportNull$$$0(0);
        }
        if (JSResolveUtil.isConstructorFunction((PsiElement)function2)) {
            return true;
        }
        if (JSClassUtils.isClassMember((PsiElement)function2)) {
            return false;
        }
        return JSSymbolUtil.isConstructorName(function2.getName());
    }

    public static void forEachIdentifierProperty(JSObjectLiteralExpression value, PropertyProcessor propertyProcessor) {
        for (JSProperty property : value.getProperties()) {
            String s = property.getName();
            if (s == null || s.length() <= 0 || !StringUtil.isJavaIdentifier((String)s)) continue;
            propertyProcessor.process(StringUtil.toTitleCase((String)s), property);
        }
    }

    @NonNls
    public static String suggestSetterName(String propertyName) {
        return "set" + StringUtil.capitalize((String)propertyName);
    }

    @NonNls
    public static String suggestGetterName(String propertyName) {
        return "get" + StringUtil.capitalize((String)propertyName);
    }

    static JSElement findNameComponent(JSElement expr) {
        if (expr instanceof JSReferenceExpression) {
            return expr;
        }
        JSElement current = expr;
        while (expr != null) {
            if (expr instanceof JSReferenceExpression) {
                return expr;
            }
            if (expr instanceof JSAssignmentExpression) {
                JSExpression lOperand;
                JSExpression _lOperand = ((JSAssignmentExpression)expr).getLOperand();
                if (!(_lOperand instanceof JSDefinitionExpression) || !((lOperand = ((JSDefinitionExpression)_lOperand).getExpression()) instanceof JSReferenceExpression)) break;
                expr = lOperand;
                continue;
            }
            if (expr instanceof JSVariable) {
                return expr;
            }
            if (expr instanceof JSCallExpression) {
                JSExpression method = ((JSCallExpression)expr).getMethodExpression();
                if (method instanceof JSReferenceExpression) {
                    return method;
                }
            } else {
                current = expr;
            }
            if (current == null) continue;
            PsiElement parent = current.getParent();
            if (!(parent instanceof JSElement) || parent instanceof JSStatement) break;
            expr = (JSElement)parent;
        }
        return null;
    }

    @NotNull
    public static List<String> buildNameIndexArray(JSElement _expr) {
        final ArrayList<String> nameComponents = new ArrayList<String>();
        JSElement nameComponent = JSSymbolUtil.findNameComponent(_expr);
        JSReferenceExpression expr = null;
        if (nameComponent instanceof JSVariable) {
            String varName = nameComponent.getName();
            if (varName != null) {
                nameComponents.add(varName);
            }
        } else if (nameComponent instanceof JSReferenceExpression) {
            expr = (JSReferenceExpression)nameComponent;
        }
        if (expr != null) {
            final JSReferenceExpression expr1 = expr;
            JSSymbolUtil.visitReferenceExpressionComponentsInRootFirstOrder(expr, new ReferenceExpressionProcessor(){

                @Override
                public void processExpression(JSReferenceExpression expr) {
                    JSNamespace predefinedType = JSSymbolUtil.getPredefinedNamespace(expr);
                    String name = predefinedType != null ? predefinedType.getTypeText(JSType.TypeTextFormat.SIMPLE) : expr.getReferencedName();
                    nameComponents.add(name);
                }

                @Override
                public void processUnresolvedThis() {
                    nameComponents.add("");
                }

                @Override
                public boolean isTopLevel(JSReferenceExpression expression) {
                    return expr1 == expression;
                }
            });
        }
        ArrayList<String> arrayList = nameComponents;
        if (arrayList == null) {
            JSSymbolUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static String handleSpecialPropertyNames(@NotNull String name, char quote) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(2);
        }
        if (name.startsWith("[Symbol.")) {
            String string = name;
            if (string == null) {
                JSSymbolUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (!JSSymbolUtil.isValidPropertyName(name)) {
            StringBuilder builder = new StringBuilder();
            builder.append(quote);
            JSStringUtil.escapeSimpleStringChars(name, quote, true, false, false, builder);
            builder.append(quote);
            String string = builder.toString();
            if (string == null) {
                JSSymbolUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            JSSymbolUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static boolean isUndefinedExpression(@Nullable JSExpression operand) {
        if (!(operand instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)operand;
        if (referenceExpression.getQualifier() != null) {
            return false;
        }
        return "undefined".equals(referenceExpression.getText());
    }

    public static boolean isNullLiteral(@Nullable JSExpression initializer) {
        return initializer instanceof JSLiteralExpression && initializer.getNode().findChildByType(JSTokenTypes.NULL_KEYWORD) != null;
    }

    public static boolean areElementsFromSameNamespace(@NotNull JSPsiElementBase element1, @NotNull JSPsiElementBase element2) {
        if (element1 == null) {
            JSSymbolUtil.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            JSSymbolUtil.$$$reportNull$$$0(7);
        }
        JSNamespace ns1 = element1.getJSNamespace();
        JSNamespace ns2 = element2.getJSNamespace();
        if (!ComparatorUtil.equalsNullable((Object)ns1.getQualifiedName(), (Object)ns2.getQualifiedName())) {
            return false;
        }
        if (!ns1.getJSContext().isCompatibleWith(ns2.getJSContext())) {
            return false;
        }
        if (ns1.isLocal()) {
            if (!ns2.isLocal()) {
                return false;
            }
            PsiElement localScope1 = ns1.getLocalScope();
            if (localScope1 == null || !localScope1.isEquivalentTo(ns2.getLocalScope())) {
                return false;
            }
        }
        return true;
    }

    private static int findParameterIndex(@NotNull JSFunction function2, @Nullable JSParameter parameter) {
        if (function2 == null) {
            JSSymbolUtil.$$$reportNull$$$0(8);
        }
        JSParameter[] parameters = function2.getParameterVariables();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (parameters[i2] != parameter) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isExportsOrGlobalNamespace(@Nullable JSQualifiedName namespace) {
        if (namespace == null) {
            return false;
        }
        String name = namespace.getQualifiedName();
        return EXPORTS.equals(name) || MODULE_EXPORTS.equals(name) || GLOBAL_OBJECT_NAMES.contains(name) || GLOBAL_TYPES.contains(namespace);
    }

    public static boolean isGlobalNamedType(@NotNull JSType type) {
        if (type == null) {
            JSSymbolUtil.$$$reportNull$$$0(9);
        }
        if (type instanceof JSReferenceType) {
            return GLOBAL_OBJECT_NAMES.contains(((JSReferenceType)type).getReferenceName());
        }
        if (type instanceof JSTypeImpl) {
            JSContext jsContext = ((JSTypeImpl)type).getJSContext();
            return jsContext == JSContext.INSTANCE && GLOBAL_TYPE_QUALIFIED_NAMES.contains(type.getTypeText(JSType.TypeTextFormat.SIMPLE)) || jsContext == JSContext.STATIC && GLOBAL_OBJECT_NAMES.contains(type.getTypeText(JSType.TypeTextFormat.SIMPLE));
        }
        return false;
    }

    static void visitReferenceExpressionComponentsInRootFirstOrder(JSReferenceExpression expr, ReferenceExpressionProcessor processor) {
        String refName;
        JSExpression qualifier = expr.getQualifier();
        if (qualifier instanceof JSCallExpression) {
            qualifier = ((JSCallExpression)qualifier).getMethodExpression();
        }
        if (qualifier instanceof JSIndexedPropertyAccessExpression) {
            qualifier = ((JSIndexedPropertyAccessExpression)qualifier).getQualifier();
        }
        if (qualifier instanceof JSReferenceExpression) {
            JSSymbolUtil.visitReferenceExpressionComponentsInRootFirstOrder((JSReferenceExpression)qualifier, processor);
        }
        if (qualifier instanceof JSThisExpression) {
            processor.processUnresolvedThis();
        }
        if ((refName = expr.getReferencedName()) != null && (!refName.equals("prototype") || processor.isTopLevel(expr))) {
            processor.processExpression(expr);
        }
    }

    public static boolean binaryOpTypeToAvoidRecursions(IElementType sign) {
        return sign == JSTokenTypes.PLUS || sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.COMMA;
    }

    public static boolean isMeaningfulLocalVariableInitializer(JSExpression initializer) {
        return initializer instanceof JSFunction || initializer instanceof JSObjectLiteralExpression;
    }

    public static boolean referencesInterface(@NotNull JSReferenceExpression ref) {
        if (ref == null) {
            JSSymbolUtil.$$$reportNull$$$0(10);
        }
        return ContainerUtil.or(JSResolveResult.toElements(ref.multiResolve(false)), e -> e instanceof JSPsiElementBase && ((JSPsiElementBase)e).isClassOrInterface() == JSElementBase.ClassOrInterface.INTERFACE);
    }

    public static boolean isInterface(@NotNull String name, PsiElement context) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(11);
        }
        return JSClassIndex.isInterface(name, context, !DialectDetector.isTypeScript(context));
    }

    @Nullable
    private static JSNamespace evaluateInitializedPrototype(JSExpression initializer, @NotNull Ref<JSReferenceExpression> outSourceReference) {
        JSNamespace ns;
        JSNamespace predefinedNamespace;
        if (outSourceReference == null) {
            JSSymbolUtil.$$$reportNull$$$0(12);
        }
        if (initializer instanceof JSParenthesizedExpression) {
            initializer = JSUtils.unparenthesize(initializer);
        }
        JSReferenceExpression initializedPrototype = null;
        JSTypeContext typeContext = JSTypeContext.UNKNOWN;
        if (initializer instanceof JSReferenceExpression && (predefinedNamespace = JSSymbolUtil.getPredefinedNamespace((JSReferenceExpression)initializer)) != null) {
            outSourceReference.set((Object)((JSReferenceExpression)initializer));
            return predefinedNamespace;
        }
        if (initializer instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)initializer).getReferenceName())) {
            JSExpression qualifier = ((JSReferenceExpression)initializer).getQualifier();
            if (qualifier instanceof JSReferenceExpression) {
                initializedPrototype = (JSReferenceExpression)qualifier;
                typeContext = JSTypeContext.PROTOTYPE;
            }
        } else if (initializer instanceof JSAssignmentExpression) {
            JSExpression initializerlOperand = ((JSAssignmentExpression)initializer).getLOperand();
            if (initializerlOperand instanceof JSDefinitionExpression) {
                JSExpression lOperand = ((JSDefinitionExpression)initializerlOperand).getExpression();
                typeContext = JSTypeContext.STATIC;
                JSSymbolUtil.evaluateInitializedPrototype(lOperand, outSourceReference);
                initializedPrototype = (JSReferenceExpression)outSourceReference.get();
                if (initializedPrototype == null && lOperand instanceof JSReferenceExpression && ((JSReferenceExpression)lOperand).getQualifier() instanceof JSReferenceExpression) {
                    initializedPrototype = (JSReferenceExpression)lOperand;
                }
            }
        } else if (initializer instanceof JSThisExpression && (ns = JSContextResolver.resolveContext((PsiElement)initializer)) != null) {
            return ns;
        }
        if (initializedPrototype == null) {
            return null;
        }
        outSourceReference.set(initializedPrototype);
        return JSSymbolUtil.createNamespaceFromReferenceExpression(initializedPrototype, typeContext.toJSContext(), true);
    }

    @Nullable
    public static JSNamespace evaluateNamespaceLocally(@NotNull JSReferenceExpression lOperand) {
        Map cachedMap;
        PsiFile containingFile;
        CachedValue value;
        if (lOperand == null) {
            JSSymbolUtil.$$$reportNull$$$0(13);
        }
        if ((value = (CachedValue)(containingFile = lOperand.getContainingFile()).getUserData(cachedClassExtendingKey)) == null) {
            value = CachedValuesManager.getManager((Project)containingFile.getManager().getProject()).createCachedValue(() -> new CachedValueProvider.Result(Collections.synchronizedMap(new THashMap(100)), new Object[]{containingFile}), false);
            containingFile.putUserData(cachedClassExtendingKey, (Object)value);
        }
        if ((cachedMap = (Map)value.getValue()).containsKey(lOperand)) {
            return (JSNamespace)cachedMap.get(lOperand);
        }
        JSNamespace type = JSSymbolUtil.evaluateNamespaceLocally(lOperand, null);
        cachedMap.put(lOperand, type);
        return type;
    }

    @Nullable
    public static JSNamespace getPredefinedNamespace(JSReferenceExpression expression) {
        if (JSSymbolUtil.isAccurateReferenceExpressionName(expression, WINDOW_OBJECT_NAME)) {
            return JSSymbolUtil.createPredefinedNamespace((PsiElement)expression, JSQualifiedNameImpl.create("Window", null));
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(expression, NODE_GLOBAL_OBJECT_NAME)) {
            return JSSymbolUtil.createPredefinedNamespace((PsiElement)expression, JSQualifiedNameImpl.fromQualifiedName("NodeJS.Global"));
        }
        return null;
    }

    @NotNull
    private static JSNamespace createPredefinedNamespace(@Nullable PsiElement source2, @NotNull JSQualifiedName name) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(14);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(name, JSTypeSourceFactory.createTypeSource(source2, true), JSTypeContext.PROTOTYPE, false);
        if (jSNamespace == null) {
            JSSymbolUtil.$$$reportNull$$$0(15);
        }
        return jSNamespace;
    }

    @Nullable
    public static JSNamespace evaluateNamespaceLocally(@Nullable JSExpression expression) {
        return JSSymbolUtil.evaluateNamespaceLocally(expression, null);
    }

    @Nullable
    public static JSNamespace evaluateNamespaceLocally(@Nullable JSExpression expression, @Nullable Set<PsiElement> visited) {
        JSExpression[] arguments;
        JSExpression methodExpression;
        if (expression instanceof JSReferenceExpression) {
            JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)expression, visited);
            if (ns != null) {
                return ns;
            }
            JSNamespace rawType = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)expression, JSContext.STATIC, true, true);
            if (rawType != null) {
                return JSSymbolUtil.replaceLocalVars(rawType, (JSReferenceExpression)expression, visited);
            }
        } else if (expression instanceof JSThisExpression) {
            Ref ref = Ref.create(null);
            JSNamespace namespace = JSSymbolUtil.evalThis((JSThisExpression)expression, (Ref<JSReferenceExpression>)ref);
            if (namespace != null) {
                return JSSymbolUtil.replaceLocalVars(namespace, (JSReferenceExpression)ref.get(), visited);
            }
        } else if (expression instanceof JSNewExpression) {
            JSNamespace innerResult = JSSymbolUtil.evaluateNamespaceLocally(((JSNewExpression)expression).getMethodExpression(), visited);
            if (innerResult != null && innerResult.getJSContext() == JSContext.STATIC) {
                return JSNamedTypeFactory.createNamespace(innerResult.getQualifiedName(), JSContext.INSTANCE, innerResult.getSource().getSourceElement(), innerResult.isSourceStrict(), false);
            }
        } else if (expression instanceof JSCallExpression && (methodExpression = ((JSCallExpression)expression).getMethodExpression()) instanceof JSReferenceExpression && (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "create") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "defineProperty") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "extend")) && (arguments = ((JSCallExpression)expression).getArguments()).length > 0) {
            return JSSymbolUtil.evaluateNamespaceLocally(arguments[0], visited);
        }
        return null;
    }

    public static boolean isLiteralOrLiteralWithSign(@Nullable JSExpression expression) {
        IElementType sign;
        if (expression instanceof JSLiteralExpression) {
            return true;
        }
        if (expression instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)expression).getOperationSign()) == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS)) {
            return ((JSPrefixExpression)expression).getExpression() instanceof JSLiteralExpression;
        }
        return false;
    }

    public static boolean typeMayBeInlined(@NotNull ASTNode expression) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(16);
        }
        return expression.getElementType() instanceof JSLiteralExpressionElementType;
    }

    @Nullable
    private static JSNamespace evaluateNamespaceLocally(JSReferenceExpression lOperand, @Nullable Set<PsiElement> visited) {
        String name;
        JSNamespace predefinedType = JSSymbolUtil.getPredefinedNamespace(lOperand);
        if (predefinedType != null) {
            return predefinedType;
        }
        boolean applyPrototype = false;
        JSExpression qualifier = lOperand.getQualifier();
        if (qualifier != null && JSSymbolUtil.isPrototype(name = lOperand.getReferenceName()) && qualifier instanceof JSReferenceExpression) {
            lOperand = (JSReferenceExpression)qualifier;
            applyPrototype = true;
        }
        JSReferenceExpression originalExpr = lOperand;
        JSElement expressionToFollow = JSSymbolUtil.calcRefExprValue(lOperand);
        if (expressionToFollow == null) {
            return null;
        }
        JSNamespace ns = null;
        JSContext jsContext = JSContext.STATIC;
        Ref ref = Ref.create(null);
        if (expressionToFollow instanceof JSExpression) {
            ns = JSSymbolUtil.evaluateInitializedPrototype((JSExpression)expressionToFollow, (Ref<JSReferenceExpression>)ref);
        }
        if (ns != null) {
            lOperand = (JSReferenceExpression)ref.get();
            jsContext = ns.getJSContext();
        } else if (expressionToFollow instanceof JSReferenceExpression) {
            lOperand = (JSReferenceExpression)expressionToFollow;
        } else if (expressionToFollow instanceof JSCallExpression) {
            JSExpression methodExpr = ((JSCallExpression)expressionToFollow).getMethodExpression();
            methodExpr = JSUtils.unparenthesize(methodExpr);
            if (expressionToFollow instanceof JSNewExpression && methodExpr instanceof JSReferenceExpression && !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpr, "Object")) {
                JSElement element = JSSymbolUtil.calcRefExprValue((JSReferenceExpression)methodExpr);
                JSReferenceExpression refExpr = (JSReferenceExpression)(element instanceof JSReferenceExpression ? element : methodExpr);
                ns = JSSymbolUtil.createNamespaceFromReferenceExpression(refExpr, JSContext.INSTANCE, false);
            }
        } else if (expressionToFollow instanceof JSThisExpression) {
            ns = JSSymbolUtil.evalThis((JSThisExpression)expressionToFollow, (Ref<JSReferenceExpression>)ref);
            if (ns != null) {
                lOperand = (JSReferenceExpression)ref.get();
            }
        } else if (expressionToFollow instanceof JSDefinitionExpression) {
            JSExpression refExpr = ((JSDefinitionExpression)expressionToFollow).getExpression();
            if (refExpr instanceof JSReferenceExpression && JSSymbolUtil.isExplicitExportReference((JSReferenceExpression)refExpr)) {
                ns = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)refExpr, JSContext.STATIC, true);
            }
        } else if (expressionToFollow instanceof JSFunctionDeclaration || expressionToFollow instanceof JSVariable) {
            ns = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)((Object)expressionToFollow), true, visited);
        }
        if (ns == null && originalExpr == lOperand && expressionToFollow instanceof JSExpression) {
            if (visited == null) {
                visited = new HashSet<PsiElement>();
            }
            if (visited.add((PsiElement)expressionToFollow)) {
                ns = JSSymbolUtil.findNamespace((JSExpression)expressionToFollow, visited);
            }
        }
        if (ns == null && lOperand != originalExpr && lOperand != null) {
            ns = JSSymbolUtil.createNamespaceFromReferenceExpression(lOperand, jsContext, true);
        }
        if (ns != null) {
            if (applyPrototype && ns instanceof JSNamedType) {
                ns = ((JSNamedType)ns).copyWithJSContext(JSContext.INSTANCE);
            }
            return JSSymbolUtil.replaceLocalVars(ns, lOperand, visited);
        }
        return null;
    }

    @Nullable
    public static JSElement calcRefExprValue(@NotNull JSReferenceExpression lOperand) {
        if (lOperand == null) {
            JSSymbolUtil.$$$reportNull$$$0(17);
        }
        HashSet<JSReferenceExpression> visited = new HashSet<JSReferenceExpression>();
        JSReferenceExpression previous = null;
        while (visited.add(lOperand)) {
            ASTNode node = lOperand.getNode();
            if (JSReferenceExpressionImpl.getQualifierNode(node) != null) {
                return previous;
            }
            String referenceName = JSReferenceExpressionImpl.getReferenceName(node);
            if (referenceName == null) {
                return previous;
            }
            JSElement value = JSSymbolUtil.calcRefExprValue(referenceName, lOperand);
            if (value == null) {
                return previous;
            }
            if (value instanceof JSBinaryExpression) {
                JSExpression operand;
                JSBinaryExpression binaryExpression = (JSBinaryExpression)value;
                IElementType sign = binaryExpression.getOperationSign();
                JSExpression jSExpression = sign == JSTokenTypes.OROR ? binaryExpression.getLOperand() : (operand = sign == JSTokenTypes.ANDAND ? binaryExpression.getROperand() : null);
                if (operand instanceof JSReferenceExpression) {
                    value = operand;
                }
            }
            if (!(value instanceof JSReferenceExpression)) {
                return value;
            }
            previous = lOperand = (JSReferenceExpression)value;
        }
        return null;
    }

    @Nullable
    private static JSElement calcRefExprValue(@NotNull String name, @NotNull JSElement context) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(18);
        }
        if (context == null) {
            JSSymbolUtil.$$$reportNull$$$0(19);
        }
        JSElement jsElement = JSSymbolUtil.resolveLocallyIncludingDefinitions(name, context);
        JSElement expressionToFollow = null;
        if (jsElement instanceof JSVariable && JSVariableBaseImpl.doGetExplicitlyDeclaredType((JSVariable)jsElement) == null) {
            if (jsElement instanceof JSParameter) {
                JSParameter parameter = (JSParameter)jsElement;
                JSExpression initialization = JSSymbolUtil.getParameterInitialization(parameter);
                if (initialization != null) {
                    expressionToFollow = initialization;
                }
            } else if (!(jsElement.getParent() instanceof JSDestructuringProperty) && !(jsElement.getParent() instanceof JSDestructuringContainer)) {
                expressionToFollow = ((JSVariable)jsElement).getInitializer();
            }
        } else if (jsElement instanceof JSFunction) {
            expressionToFollow = jsElement;
        } else if (jsElement instanceof JSDefinitionExpression) {
            expressionToFollow = JSPsiImplUtils.getRightmostOperand((JSDefinitionExpression)jsElement);
        }
        return expressionToFollow;
    }

    @Nullable
    public static JSElement resolveLocallyIncludingDefinitions(@NotNull String name, @NotNull JSElement context) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(20);
        }
        if (context == null) {
            JSSymbolUtil.$$$reportNull$$$0(21);
        }
        PsiElement parent = context.getParent();
        ASTNode node = context.getNode();
        JSTreeUtil.JSScopeDeclarationsAndAssignments up = JSTreeUtil.getDeclarationsAndAssignmentsInScopeAndUp(name, node);
        if (up == null) {
            return null;
        }
        CompositeElement definition = up.findNearestDefinition(node);
        if (definition == null) {
            return null;
        }
        PsiElement jsElement = definition.getPsi();
        if (jsElement == null && parent instanceof JSDefinitionExpression) {
            jsElement = parent;
        }
        return (JSElement)jsElement;
    }

    @Nullable
    private static JSNamespace evalThis(JSThisExpression expressionToFollow, @NotNull Ref<JSReferenceExpression> outSourceReference) {
        JSNamespace ns;
        if (outSourceReference == null) {
            JSSymbolUtil.$$$reportNull$$$0(22);
        }
        if ((ns = JSContextResolver.resolveContext((PsiElement)expressionToFollow)) != null) {
            return ns;
        }
        ns = JSSymbolUtil.evaluateInitializedPrototype(expressionToFollow, outSourceReference);
        if (ns != null) {
            return (JSNamespace)ns.copyWithStrict(true);
        }
        boolean thisIsGlobal = false;
        JSFunction function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expressionToFollow, JSFunction.class);
        if (function2 == null || function2.isAnonymousFunctionCall()) {
            thisIsGlobal = true;
        } else if (function2 instanceof JSFunctionExpression) {
            PsiElement functionParent = function2.getParent();
            if (functionParent instanceof JSParenthesizedExpression) {
                functionParent = functionParent.getParent();
            }
            if (functionParent instanceof JSReferenceExpression && "call".equals(((JSReferenceExpression)functionParent).getReferencedName())) {
                PsiElement prevParent = functionParent;
                if ((functionParent = functionParent.getParent()) instanceof JSCallExpression && ((JSCallExpression)functionParent).getMethodExpression() == prevParent) {
                    JSExpression[] arguments = ((JSCallExpression)functionParent).getArguments();
                    if (arguments.length > 0) {
                        ns = JSSymbolUtil.evaluateInitializedPrototype(arguments[0], outSourceReference);
                        if (outSourceReference.isNull() && arguments[0] instanceof JSThisExpression && PsiTreeUtil.getParentOfType((PsiElement)arguments[0], (Class[])new Class[]{JSFunction.class, JSObjectLiteralExpression.class}) == null) {
                            thisIsGlobal = true;
                        }
                    } else {
                        thisIsGlobal = true;
                    }
                }
            }
        }
        if (thisIsGlobal) {
            return JSNamedTypeFactory.createNamespace(null, JSContext.STATIC, (PsiElement)expressionToFollow, true, true);
        }
        return ns;
    }

    @Nullable
    public static JSNamespace replaceLocalVars(JSReferenceExpression expression) {
        JSNamespace ns = JSSymbolUtil.createNamespaceFromReferenceExpression(expression, JSContext.UNKNOWN, true);
        if (ns != null) {
            return JSSymbolUtil.replaceLocalVars(ns, expression, null);
        }
        return null;
    }

    @Nullable
    private static JSNamespace replaceLocalVars(@NotNull JSNamespace ns, @Nullable JSReferenceExpression expression, @Nullable Set<PsiElement> visited) {
        if (ns == null) {
            JSSymbolUtil.$$$reportNull$$$0(23);
        }
        if (expression == null) {
            return ns;
        }
        JSQualifiedName qualifiedName = ns.getQualifiedName();
        if (qualifiedName == null) {
            return ns;
        }
        JSReferenceExpression innerMostExpr = expression;
        while (innerMostExpr.getQualifier() != null) {
            JSExpression innerMostExprQualifier = innerMostExpr.getQualifier();
            if (!(innerMostExprQualifier instanceof JSReferenceExpression)) {
                return ns;
            }
            innerMostExpr = (JSReferenceExpression)innerMostExprQualifier;
        }
        PsiElement ref = JSStubBasedPsiTreeUtil.resolveLocally(JSQualifiedNameImpl.getTopmostParent(qualifiedName), (PsiElement)expression, false);
        if (ref instanceof JSParameter) {
            JSFunction declaringFunction = ((JSParameter)ref).getDeclaringFunction();
            if (declaringFunction instanceof JSFunctionExpression && (declaringFunction.getParent() instanceof JSArgumentList || declaringFunction.getParent() instanceof JSParenthesizedExpression)) {
                return null;
            }
            return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedNamedElement((JSVariable)ref), ns.getJSContext(), ref, true, ns.isDeclaration(), true);
        }
        if (ref instanceof JSVariable) {
            JSExpression initializer = ((JSVariable)ref).getInitializer();
            boolean isDeclaration = ns.isDeclaration();
            if (JSVariableBaseImpl.doGetExplicitlyDeclaredType((JSVariable)ref) != null) {
                isDeclaration = false;
            }
            if (initializer instanceof JSReferenceExpression) {
                JSNamespace initializerType = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)initializer, ns.getJSContext(), isDeclaration);
                return JSSymbolUtil.replaceTopmostQualifier(ns, initializerType);
            }
            if (visited == null) {
                visited = new HashSet<PsiElement>();
            }
            boolean added = visited.add((PsiElement)innerMostExpr);
            if (innerMostExpr != expression && added) {
                JSNamespace innerMostType = JSSymbolUtil.evaluateNamespaceLocally(innerMostExpr, visited);
                if (innerMostType == null) {
                    String name = innerMostExpr.getReferenceName();
                    if (JSSymbolUtil.isImportantName(name)) {
                        return JSSymbolUtil.createNamespaceFromReferenceExpression(expression, ns.getJSContext(), isDeclaration);
                    }
                    return null;
                }
                return JSSymbolUtil.replaceTopmostQualifier(ns, innerMostType);
            }
            if (added) {
                JSNamespace innerResult = JSSymbolUtil.evaluateNamespaceLocally(innerMostExpr, visited);
                if (innerResult == null) {
                    return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedNamedElement((JSVariable)ref), ns.getJSContext(), ref, true, isDeclaration, ns.isLocal());
                }
                JSContext jsContext = JSTypeUtils.combineJSContexts(innerResult.getJSContext(), ns.getJSContext());
                return JSNamedTypeFactory.createNamespace(innerResult.getQualifiedName(), jsContext, innerResult.getSource().getSourceElement(), innerResult.isSourceStrict(), innerResult.isDeclaration(), innerResult.isLocal());
            }
        } else if (innerMostExpr == expression && ref instanceof JSNamedElement && !(ref instanceof JSElementBase) && !ns.isLocal()) {
            return JSNamedTypeFactory.createNamespace(ns.getQualifiedName(), ns.getJSContext(), ns.getSource().getSourceElement(), ns.isSourceStrict(), ns.isDeclaration(), true);
        }
        return ns;
    }

    @Contract(value="null -> false")
    public static boolean isAccurateReferenceExpression(@Nullable JSExpression initializer) {
        return initializer instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)initializer);
    }

    public static boolean isAccurateReferenceExpression(@NotNull JSReferenceExpression initializer) {
        if (initializer == null) {
            JSSymbolUtil.$$$reportNull$$$0(24);
        }
        JSExpression initializerQualifier = initializer.getQualifier();
        while (initializerQualifier instanceof JSReferenceExpression) {
            initializerQualifier = ((JSReferenceExpression)initializerQualifier).getQualifier();
        }
        return initializerQualifier == null;
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSExpression expression, String ... components) {
        return expression instanceof JSReferenceItem && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceItem)((Object)expression), components);
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSExpression expression, String name) {
        return expression instanceof JSReferenceItem && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceItem)((Object)expression), name);
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSReferenceExpression expression, String ... components) {
        return expression != null && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceItem)expression, components);
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSReferenceExpression expression, String name) {
        return expression != null && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceItem)expression, name);
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSReferenceItem referenceExpression, String name) {
        return referenceExpression != null && !referenceExpression.hasQualifier() && StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)name);
    }

    public static boolean isAccurateReferenceExpressionName(@Nullable JSReferenceItem referenceExpression, String ... components) {
        JSReferenceItem ref = referenceExpression;
        int i2 = components.length - 1;
        while (ref != null) {
            if (i2 < 0) {
                return false;
            }
            if (!StringUtil.equals((CharSequence)ref.getReferenceName(), (CharSequence)components[i2])) {
                return false;
            }
            ref = ref.getReferenceItemQualifier();
            --i2;
        }
        return i2 == -1;
    }

    public static List<String> getReferenceParts(@NotNull JSExpression referenceOrIndexedAccessExpression) {
        if (referenceOrIndexedAccessExpression == null) {
            JSSymbolUtil.$$$reportNull$$$0(25);
        }
        SmartList nameParts = new SmartList();
        JSExpression ref = referenceOrIndexedAccessExpression;
        while (ref != null) {
            if (ref instanceof JSReferenceExpression) {
                JSReferenceExpression reference = (JSReferenceExpression)ref;
                String name = reference.getReferenceName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return null;
                }
                nameParts.add(name);
                ref = reference.getQualifier();
                continue;
            }
            if (ref instanceof JSIndexedPropertyAccessExpression) {
                JSIndexedPropertyAccessExpression indexedAccessExpression = (JSIndexedPropertyAccessExpression)ref;
                JSExpression indexExpression = indexedAccessExpression.getIndexExpression();
                if (indexExpression == null) {
                    return null;
                }
                String indexText = indexExpression.getText();
                if (StringUtil.isEmptyOrSpaces((String)indexText)) {
                    return null;
                }
                nameParts.add("[" + indexText + "]");
                ref = indexedAccessExpression.getQualifier();
                continue;
            }
            return null;
        }
        assert (!nameParts.isEmpty());
        Collections.reverse(nameParts);
        return nameParts;
    }

    @Nullable
    public static JSQualifiedName getAccurateReferenceName(@NotNull PsiQualifiedReference reference) {
        String referenceName;
        if (reference == null) {
            JSSymbolUtil.$$$reportNull$$$0(26);
        }
        if ((referenceName = reference.getReferenceName()) == null) {
            return null;
        }
        PsiElement qualifier = reference.getQualifier();
        if (qualifier == null) {
            return JSQualifiedNameImpl.create(referenceName, null);
        }
        if (qualifier instanceof PsiQualifiedReference) {
            JSQualifiedName qualifierName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)qualifier);
            return qualifierName != null ? JSQualifiedNameImpl.create(referenceName, qualifierName) : null;
        }
        return null;
    }

    @Nullable
    public static JSNamespace createNamespaceFromReferenceExpression(@NotNull JSReferenceExpression expression, JSContext jsContext, boolean isDeclaration) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(27);
        }
        return JSSymbolUtil.createNamespaceFromReferenceExpression(expression, jsContext, isDeclaration, false);
    }

    @Nullable
    public static JSNamespace createNamespaceFromReferenceExpression(@NotNull JSReferenceExpression expression, @NotNull JSContext jsContext, boolean isDeclaration, boolean explicitlyDeclared) {
        JSNamespace predefinedNs;
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(28);
        }
        if (jsContext == null) {
            JSSymbolUtil.$$$reportNull$$$0(29);
        }
        if ((predefinedNs = JSSymbolUtil.getPredefinedNamespace(expression)) != null) {
            return predefinedNs;
        }
        String name = expression.getReferenceName();
        if (JSSymbolUtil.isPrototype(name)) {
            JSExpression qualifier = expression.getQualifier();
            if (!(qualifier instanceof JSReferenceExpression)) {
                return null;
            }
            expression = (JSReferenceExpression)qualifier;
            jsContext = JSContext.INSTANCE;
            isDeclaration = true;
        }
        if (JSSymbolUtil.isExplicitExportReference(expression)) {
            return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(EXPORTS, null), jsContext, (PsiElement)expression, explicitlyDeclared, isDeclaration, true);
        }
        JSQualifiedName qualifiedName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)expression);
        if (qualifiedName == null) {
            return null;
        }
        if (qualifiedName.getParent() != null && WINDOW_OBJECT_NAME.equals(JSQualifiedNameImpl.getTopmostParent(qualifiedName))) {
            List<String> components = qualifiedName.toComponents();
            components.set(0, "Window");
            qualifiedName = JSQualifiedNameImpl.fromComponents(components);
        }
        return JSNamedTypeFactory.createNamespace(qualifiedName, jsContext, (PsiElement)expression, explicitlyDeclared, isDeclaration, false);
    }

    private static boolean isPrototype(String name) {
        return "prototype".equals(name) || FN_FUN_NAME.equals(name);
    }

    @Nullable
    public static JSQualifiedName evaluateReferencedNamespace(JSExpression expression) {
        JSNamespace namespace = JSSymbolUtil.evaluateReferencedNamespace(expression, false);
        return namespace == null ? null : namespace.getQualifiedName();
    }

    @Nullable
    public static JSNamespace evaluateReferencedNamespace(JSExpression expression, boolean evaluateThis) {
        SmartList components = new SmartList();
        boolean canBeEvaluated = true;
        JSContext context = JSContext.STATIC;
        while (canBeEvaluated) {
            JSNamespace result2;
            if (expression instanceof JSReferenceExpression) {
                JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)expression);
                if (ns != null && ns.getQualifiedName() != null) {
                    JSSymbolUtil.addNamespaceComponents((List<String>)components, ns);
                    break;
                }
                String name = ((JSReferenceExpression)expression).getReferencedName();
                if (!"prototype".equals(name) && name != null) {
                    components.add(0, name);
                } else {
                    context = JSContext.INSTANCE;
                }
                expression = ((JSReferenceExpression)expression).getQualifier();
                continue;
            }
            if (expression instanceof JSIndexedPropertyAccessExpression) {
                String propertyName;
                JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression();
                if (indexExpression instanceof JSLiteralExpression && (propertyName = ((JSLiteralExpression)indexExpression).getValueAsPropertyName()) != null) {
                    components.add(0, propertyName);
                }
                expression = ((JSIndexedPropertyAccessExpression)expression).getQualifier();
                continue;
            }
            if (evaluateThis && expression instanceof JSThisExpression && (result2 = JSSymbolUtil.evaluateNamespaceLocally(expression)) != null) {
                JSSymbolUtil.addNamespaceComponents((List<String>)components, result2);
                JSContext jSContext = context = components.isEmpty() ? JSContext.INSTANCE : JSContext.STATIC;
            }
            if (expression == null || expression instanceof JSThisExpression) break;
            canBeEvaluated = false;
        }
        return canBeEvaluated ? JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromComponents((List<String>)components), context, (PsiElement)expression, true) : null;
    }

    private static void addNamespaceComponents(@NotNull List<String> components, @NotNull JSNamespace ns) {
        JSQualifiedName name;
        if (components == null) {
            JSSymbolUtil.$$$reportNull$$$0(30);
        }
        if (ns == null) {
            JSSymbolUtil.$$$reportNull$$$0(31);
        }
        if ((name = ns.getQualifiedName()) == null) {
            return;
        }
        components.addAll(0, QualifiedName.fromDottedString((String)name.getQualifiedName()).getComponents());
    }

    @Nullable
    public static JSQualifiedName getReferencedNamespace(@NotNull JSExpression expression) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(32);
        }
        JSExpression qualifier = null;
        String name = null;
        if (expression instanceof JSReferenceExpression) {
            name = ((JSReferenceExpression)expression).getReferencedName();
            qualifier = ((JSReferenceExpression)expression).getQualifier();
        } else if (expression instanceof JSIndexedPropertyAccessExpression) {
            JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)expression).getIndexExpression();
            if (indexExpression instanceof JSLiteralExpression) {
                name = ((JSLiteralExpression)indexExpression).getValueAsPropertyName();
            }
            qualifier = ((JSIndexedPropertyAccessExpression)expression).getQualifier();
        }
        if (name == null) {
            return null;
        }
        if (qualifier == null) {
            return JSQualifiedNameImpl.create(name, null);
        }
        JSQualifiedName namespace = JSSymbolUtil.getReferencedNamespace(qualifier);
        return namespace != null && !"prototype".equals(name) ? JSQualifiedNameImpl.create(name, namespace) : namespace;
    }

    @Nullable
    public static JSQualifiedName getLiteralValueAsQualifiedName(@NotNull JSLiteralExpression literal) {
        if (literal == null) {
            JSSymbolUtil.$$$reportNull$$$0(33);
        }
        if (!literal.isQuotedLiteral() || literal.getTextLength() > 200) {
            return null;
        }
        String value = literal.getStringValue();
        if (value == null || StringUtil.containsWhitespaces((CharSequence)value)) {
            return null;
        }
        return JSQualifiedNameImpl.fromQualifiedName(value);
    }

    public static boolean isImportantName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        char ch = name.charAt(0);
        return Character.isUpperCase(ch) || ch == '$';
    }

    @Nullable
    private static JSNamespace replaceTopmostQualifier(@NotNull JSNamespace ns, @Nullable JSNamespace by) {
        JSQualifiedNameImpl initialQName;
        if (ns == null) {
            JSSymbolUtil.$$$reportNull$$$0(34);
        }
        if ((initialQName = (JSQualifiedNameImpl)ns.getQualifiedName()) == null) {
            throw new IllegalArgumentException("Nothing to replace");
        }
        if (by == null) {
            return null;
        }
        JSQualifiedName tail = initialQName.withoutInnermostComponent(null);
        JSQualifiedName replaced = JSQualifiedNameImpl.concat(by.getQualifiedName(), tail);
        return JSNamedTypeFactory.createNamespace(replaced, ns.getJSContext(), ns.getSource().getSourceElement(), false, ns.isDeclaration(), by.isLocal());
    }

    @Nullable
    public static JSExpression getFirstLiteralOrExprArg(JSArgumentList parent) {
        JSExpression[] jsExpressions = parent.getArguments();
        for (int i2 = 0; i2 < jsExpressions.length; ++i2) {
            JSExpression expr = jsExpressions[i2];
            if (expr instanceof JSReferenceExpression || expr instanceof JSLiteralExpression && !expr.textContains(' ') && expr.getTextLength() < 100) {
                return expr;
            }
            if (expr instanceof JSCallExpression) {
                JSArgumentList argumentList = ((JSCallExpression)expr).getArgumentList();
                if (argumentList == null) continue;
                jsExpressions = argumentList.getArguments();
                i2 = -1;
                continue;
            }
            if (expr instanceof JSArrayLiteralExpression) {
                jsExpressions = ((JSArrayLiteralExpression)expr).getExpressions();
                i2 = -1;
                continue;
            }
            if (expr instanceof JSObjectLiteralExpression) break;
        }
        return null;
    }

    public static JSCallExpression getAnonymousFunCall(JSFunction function2) {
        PsiElement functionParent = function2.getParent();
        if (functionParent instanceof JSParenthesizedExpression) {
            functionParent = functionParent.getParent();
        }
        if (!(functionParent instanceof JSCallExpression)) {
            return null;
        }
        return (JSCallExpression)functionParent;
    }

    @Nullable
    public static JSLiteralExpression getParameterInitializationIfRequireArgument(@NotNull JSParameter jsParameter) {
        JSFunction function2;
        if (jsParameter == null) {
            JSSymbolUtil.$$$reportNull$$$0(35);
        }
        if ((function2 = jsParameter.getDeclaringFunction()) == null) {
            return null;
        }
        Pair<JSLiteralExpression, JSArrayLiteralExpression> requireArguments = JSAmdPsiUtil.getRequireArguments(function2);
        if (requireArguments != null) {
            int parameterIndex = JSSymbolUtil.findParameterIndex(function2, jsParameter);
            if (requireArguments.second != null) {
                JSExpression id = null;
                JSExpression[] expressions = ((JSArrayLiteralExpression)requireArguments.second).getExpressions();
                if (parameterIndex < expressions.length && parameterIndex >= 0) {
                    id = expressions[parameterIndex];
                }
                if (id instanceof JSLiteralExpression) {
                    return (JSLiteralExpression)id;
                }
            }
        }
        return null;
    }

    @Nullable
    public static JSExpression getParameterInitialization(@NotNull JSParameter jsParameter) {
        JSExpression expression;
        JSExpression actualParameter;
        JSFunction function2;
        if (jsParameter == null) {
            JSSymbolUtil.$$$reportNull$$$0(36);
        }
        if ((function2 = jsParameter.getDeclaringFunction()) == null) {
            return null;
        }
        JSExpression factoryArgument = JSSymbolUtil.getMatchedFactoryArgument(jsParameter);
        if (factoryArgument != null) {
            return factoryArgument;
        }
        JSCallExpression anonymousCallExpr = JSSymbolUtil.getAnonymousFunCall(function2);
        if (anonymousCallExpr == null) {
            return null;
        }
        int parameterIndex = JSSymbolUtil.findParameterIndex(function2, jsParameter);
        JSExpression[] expressions = anonymousCallExpr.getArguments();
        if (0 <= parameterIndex && parameterIndex < expressions.length) {
            actualParameter = expressions[parameterIndex];
        } else {
            if (parameterIndex == -1 && !TypeScriptPsiUtil.isThisParameter(jsParameter)) {
                Logger.getInstance(JSSymbolUtil.class).error("name = " + jsParameter.getName(), new Attachment[]{new Attachment("function.txt", function2.getText())});
            }
            actualParameter = null;
        }
        if (actualParameter instanceof JSThisExpression) {
            Ref ref = Ref.create();
            JSSymbolUtil.evalThis((JSThisExpression)actualParameter, (Ref<JSReferenceExpression>)ref);
            if (!ref.isNull()) {
                actualParameter = (JSExpression)ref.get();
            }
        }
        if (actualParameter instanceof JSCallExpression && 0 == ((JSCallExpression)actualParameter).getArguments().length && (expression = ((JSCallExpression)actualParameter).getMethodExpression()) instanceof JSReferenceExpression && "call".equals(((JSReferenceExpression)expression).getReferencedName())) {
            JSBlockStatement block;
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            if (qualifier instanceof JSParenthesizedExpression) {
                qualifier = ((JSParenthesizedExpression)qualifier).getInnerExpression();
            }
            if (qualifier instanceof JSFunctionExpression && (block = ((JSFunctionExpression)qualifier).getBlock()) != null) {
                JSExpression returned;
                JSStatement secondStatement;
                JSStatement firstStatement = (JSStatement)PsiTreeUtil.getChildOfType((PsiElement)block, JSStatement.class);
                JSStatement jSStatement = secondStatement = firstStatement != null ? (JSStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)firstStatement, JSStatement.class) : null;
                if (secondStatement == null && firstStatement instanceof JSReturnStatement && (returned = ((JSReturnStatement)firstStatement).getExpression()) instanceof JSThisExpression) {
                    actualParameter = returned;
                }
            }
        }
        return actualParameter;
    }

    private static JSExpression getMatchedFactoryArgument(@NotNull JSParameter parameter) {
        JSFunction factoryFunction;
        if (parameter == null) {
            JSSymbolUtil.$$$reportNull$$$0(37);
        }
        if (!((factoryFunction = parameter.getDeclaringFunction()) instanceof JSExpression)) {
            return null;
        }
        PsiElement argumentList = factoryFunction.getParent();
        if (!(argumentList instanceof JSArgumentList)) {
            return null;
        }
        PsiElement anonymousFunctionCall = argumentList.getParent();
        if (!(anonymousFunctionCall instanceof JSCallExpression)) {
            return null;
        }
        JSExpression methodExpression = ((JSCallExpression)anonymousFunctionCall).getMethodExpression();
        if (!((methodExpression = JSUtils.unparenthesize(methodExpression)) instanceof JSFunctionExpression)) {
            return null;
        }
        JSParameterListElement[] callingFunctionParameters = ((JSFunctionExpression)methodExpression).getParameters();
        int factoryParameterIndex = ArrayUtil.indexOf((Object[])((JSArgumentList)argumentList).getArguments(), (Object)factoryFunction);
        if (factoryParameterIndex < 0 || factoryParameterIndex >= callingFunctionParameters.length) {
            return null;
        }
        JSParameterListElement factoryParameter = callingFunctionParameters[factoryParameterIndex];
        if (!(factoryParameter instanceof JSParameter)) {
            return null;
        }
        final String factoryParameterName = factoryParameter.getName();
        SmartList factoryCalls = new SmartList();
        methodExpression.acceptChildren(new JSRecursiveWalkingElementVisitor((List)factoryCalls){
            final /* synthetic */ List val$factoryCalls;
            {
                this.val$factoryCalls = list2;
            }

            @Override
            public void visitJSCallExpression(JSCallExpression node) {
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceItem)((Object)methodExpression), factoryParameterName)) {
                    this.val$factoryCalls.add(node);
                }
            }

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/index/JSSymbolUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        int namespaceParameterIndex = JSSymbolUtil.findParameterIndex(factoryFunction, parameter);
        if (namespaceParameterIndex == -1 || factoryCalls.isEmpty()) {
            return null;
        }
        for (JSCallExpression factoryCall : factoryCalls) {
            JSExpression argumentMatchingNs;
            JSExpression[] arguments = factoryCall.getArguments();
            if (arguments.length <= namespaceParameterIndex || !((argumentMatchingNs = arguments[namespaceParameterIndex]) instanceof JSReferenceExpression)) continue;
            return argumentMatchingNs;
        }
        return null;
    }

    public static boolean isExportReference(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            JSSymbolUtil.$$$reportNull$$$0(38);
        }
        if (!EXPORTS.equals(referenceExpression.getReferenceName())) {
            return false;
        }
        JSExpression qualifier = referenceExpression.getQualifier();
        if (qualifier == null) {
            return true;
        }
        if (!(qualifier instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression qualifierRef = (JSReferenceExpression)qualifier;
        if (qualifierRef.getQualifier() != null) {
            return false;
        }
        String qualifierName = qualifierRef.getReferenceName();
        if (qualifierName == null) {
            return false;
        }
        if (MODULE.equals(qualifierName)) {
            return true;
        }
        JSElement element = JSSymbolUtil.resolveLocallyIncludingDefinitions(qualifierName, qualifier);
        if (element instanceof JSInitializerOwner) {
            JSExpression initializer = ((JSInitializerOwner)element).getInitializer();
            for (PsiElement expr : ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)initializer).filter(Conditions.or((Condition)Conditions.instanceOf(JSBinaryExpression.class), (Condition)Conditions.instanceOf(JSReferenceExpression.class)))).traverse()) {
                if (!(expr instanceof JSReferenceExpression) || !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)expr, MODULE)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExplicitExportReference(@Nullable JSReferenceExpression referenceExpression) {
        if (referenceExpression != null) {
            JSExpression qualifier = referenceExpression.getQualifier();
            String referencedName = referenceExpression.getReferenceName();
            return EXPORTS.equals(referencedName) && (qualifier == null || qualifier instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)qualifier, MODULE));
        }
        return false;
    }

    public static JSContext getContext(@NotNull JSElement element, boolean useJSDoc) {
        JSExpression qualifier;
        JSExpression expression;
        JSQualifiedNamedElement assignedTo;
        if (element == null) {
            JSSymbolUtil.$$$reportNull$$$0(39);
        }
        if (element instanceof JSAttributeListOwner) {
            if (element instanceof JSParameter) {
                return TypeScriptPsiUtil.isFieldParameter((JSParameter)element) ? JSContext.INSTANCE : JSContext.UNKNOWN;
            }
            JSAttributeList attributes = ((JSAttributeListOwner)element).getAttributeList();
            if (attributes != null && attributes.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                return JSContext.STATIC;
            }
            PsiElement parent = JSResolveUtil.findParent((PsiElement)element);
            if (parent instanceof TypeScriptEnum || parent instanceof TypeScriptModule) {
                return JSContext.STATIC;
            }
            if (parent instanceof JSClass) {
                return JSContext.INSTANCE;
            }
        }
        if (element instanceof JSFunctionExpression && (assignedTo = ((JSFunctionExpression)element).getElementAssignedTo()) != null) {
            return assignedTo.getJSContext();
        }
        if (element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() != null && "prototype".equals(((JSReferenceExpression)qualifier).getReferenceName())) {
            return JSContext.INSTANCE;
        }
        if (element instanceof TypeScriptTypeMember) {
            if (JSUtils.getMemberContainingClass((PsiElement)element) instanceof TypeScriptInterface) {
                return JSContext.INSTANCE;
            }
            return JSContext.UNKNOWN;
        }
        if (!useJSDoc) {
            return JSContext.UNKNOWN;
        }
        JSContext context = JSDocumentationUtils.findJSContext((PsiElement)element);
        if (element instanceof JSProperty && context == JSContext.UNKNOWN) {
            return JSDocumentationUtils.findJSContext(element.getParent());
        }
        return context;
    }

    @Nullable
    public static String getIndexedPropertyName(@NotNull JSIndexedPropertyAccessExpression expr) {
        PsiElement resolve;
        String name;
        JSExpression indexExpression;
        if (expr == null) {
            JSSymbolUtil.$$$reportNull$$$0(40);
        }
        if ((indexExpression = expr.getIndexExpression()) instanceof JSReferenceExpression && (name = ((JSReferenceExpression)indexExpression).getReferenceName()) != null && (resolve = JSStubBasedPsiTreeUtil.resolveLocally(name, (PsiElement)indexExpression, true)) instanceof JSInitializerOwner) {
            indexExpression = ((JSInitializerOwner)resolve).getInitializer();
        }
        if (indexExpression instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isQuotedLiteral()) {
            return ((JSLiteralExpression)indexExpression).getStringValue();
        }
        return null;
    }

    @Nullable
    public static JSNamespace findNamespace(@NotNull JSExpression expression) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(41);
        }
        return JSSymbolUtil.findNamespace(expression, null);
    }

    @Nullable
    public static JSNamespace findNamespace(@NotNull JSExpression expression, @Nullable Set<PsiElement> visited) {
        if (expression == null) {
            JSSymbolUtil.$$$reportNull$$$0(42);
        }
        for (FrameworkIndexingHandler indexingHandler : FrameworkIndexingHandler.getIndexingHandlers()) {
            JSNamespace ns = indexingHandler.findNamespace(expression, visited);
            if (ns == null) continue;
            return ns;
        }
        PsiElement parent = expression.getParent();
        JSExpression returnedExpression = JSDialectSpecificHandlersFactory.forElement((PsiElement)expression).getPsiHelper().isReturnedFromFunction(expression) ? expression : null;
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider((PsiElement)expression);
        if (docComment instanceof JSDocComment) {
            String lendsTagValue;
            JSDocComment comment = (JSDocComment)docComment;
            JSQualifiedName namespace = comment.getNamespace();
            String name = comment.getExplicitName();
            if (name != null) {
                JSContext context = comment.getJSContext();
                return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(name, namespace), context, (PsiElement)docComment, true, true);
            }
            if (expression instanceof JSObjectLiteralExpression && (lendsTagValue = comment.getLendsTagValue()) != null) {
                return JSNamedTypeFactory.fromNamepath(lendsTagValue, true);
            }
        }
        if (parent instanceof JSVariable) {
            return JSNamedTypeFactory.buildProvidedNamespace((JSVariable)parent, true, visited);
        }
        if (parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getROperand() == expression) {
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand instanceof JSDefinitionExpression) {
                return JSNamedTypeFactory.buildProvidedNamespace((JSDefinitionExpression)lOperand, true, visited);
            }
        } else {
            PsiElement grandParent;
            if (parent instanceof JSProperty) {
                JSNamespace ns = JSNamedTypeFactory.buildProvidedNamespace((JSProperty)parent, true, visited);
                if (ns != null && ns.getQualifiedName() != null && parent.getParent() instanceof JSObjectLiteralExpression && parent.getParent().getParent() instanceof JSArgumentList) {
                    String name = ((JSProperty)parent).getName();
                    if ("members".equals(name) || "proto".equals(name)) {
                        return JSNamedTypeFactory.createNamespace(ns.getQualifiedName().getParent(), JSContext.INSTANCE, parent, ns.isSourceStrict(), ns.isDeclaration(), ns.isLocal());
                    }
                    if ("statics".equals(name) || "own".equals(name)) {
                        return JSNamedTypeFactory.createNamespace(ns.getQualifiedName().getParent(), JSContext.STATIC, parent, ns.isSourceStrict(), ns.isDeclaration(), ns.isLocal());
                    }
                }
                return ns;
            }
            if (parent instanceof JSArgumentList && (grandParent = parent.getParent()) instanceof JSCallExpression) {
                JSNamespace nsResult;
                JSExpression[] arguments;
                JSExpression methodExpression = ((JSCallExpression)grandParent).getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression && (JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "freeze") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "Object", "seal"))) {
                    return JSSymbolUtil.findNamespace((JSExpression)grandParent, visited);
                }
                if ((JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "Object", "assign") || JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "Object", "defineProperties") || JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, WEBPACK_EXTEND_METHOD_NAME)) && (arguments = ((JSArgumentList)parent).getArguments()).length >= 2 && arguments[1] == expression && (nsResult = JSSymbolUtil.evaluateNamespaceLocally(arguments[0], visited)) != null) {
                    return nsResult;
                }
                JSInheritanceCallEvaluator.JSInheritanceCallResult inheritance = JSInheritanceCallEvaluator.findInheritance((JSCallExpression)grandParent);
                if (inheritance != null && inheritance.mixed == expression) {
                    JSNamespace destinationNs = inheritance.evaluateOrFindDestinationNamespace((JSCallExpression)grandParent);
                    if (destinationNs != null) {
                        return destinationNs;
                    }
                } else if (grandParent.getParent() instanceof JSReturnStatement) {
                    returnedExpression = (JSExpression)grandParent;
                } else {
                    String name;
                    PsiComment callExpressionDocComment = JSDocumentationUtils.findDocComment(grandParent);
                    if (callExpressionDocComment instanceof JSDocComment && (name = ((JSDocComment)callExpressionDocComment).getExplicitName()) != null && ((JSDocComment)callExpressionDocComment).isClassExplicitly()) {
                        JSQualifiedNameImpl qName = JSQualifiedNameImpl.create(name, ((JSDocComment)callExpressionDocComment).getNamespace());
                        return JSNamedTypeFactory.createNamespace(qName, JSContext.UNKNOWN, (PsiElement)callExpressionDocComment, false, true);
                    }
                }
            } else {
                if (parent instanceof JSParenthesizedExpression) {
                    return JSSymbolUtil.findNamespace((JSParenthesizedExpression)parent, visited);
                }
                if (parent instanceof JSBinaryExpression) {
                    IElementType sign = ((JSBinaryExpression)parent).getOperationSign();
                    if (sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND) {
                        return JSSymbolUtil.findNamespace((JSBinaryExpression)parent, visited);
                    }
                } else {
                    if (parent instanceof JSConditionalExpression) {
                        return JSSymbolUtil.findNamespace((JSConditionalExpression)parent, visited);
                    }
                    if (parent instanceof ES6ExportDefaultAssignment) {
                        return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create("default", null), JSContext.STATIC, (PsiElement)expression, true, true, true);
                    }
                }
            }
        }
        JSFunction function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class);
        if (returnedExpression != null && function2 != null) {
            JSQualifiedName amdNamespace = JSAmdPsiUtil.getNamespaceForAmdModuleElements(function2);
            if (amdNamespace != null) {
                return JSNamedTypeFactory.createNamespace(amdNamespace, JSContext.UNKNOWN, (PsiElement)function2, false, true);
            }
            PsiElement call = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)function2);
            if (call instanceof JSCallExpression) {
                return JSSymbolUtil.findNamespace((JSExpression)call, visited);
            }
        }
        return null;
    }

    @Nullable
    public static String getQualifierOfExprAsString(@NotNull JSElement expr) {
        JSExpression method;
        PsiElement jsExpressionParent;
        if (expr == null) {
            JSSymbolUtil.$$$reportNull$$$0(43);
        }
        if (expr instanceof JSNamedElement) {
            return expr.getName();
        }
        if (expr instanceof JSNewExpression && (jsExpressionParent = expr.getParent()) instanceof JSVariable && JSSymbolUtil.isAccurateReferenceExpressionName(method = ((JSNewExpression)expr).getMethodExpression(), "Class")) {
            return ((JSVariable)jsExpressionParent).getName();
        }
        if (expr instanceof JSReferenceExpression) {
            JSQualifiedName name;
            JSNamespace result2 = JSSymbolUtil.createNamespaceFromReferenceExpression((JSReferenceExpression)expr, JSContext.UNKNOWN, true);
            JSQualifiedName jSQualifiedName = name = result2 != null ? result2.getQualifiedName() : null;
            if (name != null) {
                return name.getQualifiedName();
            }
        }
        if (expr instanceof JSLiteralExpression) {
            return JSStringUtil.unquoteAndUnescapeStringLiteralValue(expr.getText());
        }
        return null;
    }

    public static boolean isValidPropertyName(@NotNull String name) {
        if (name == null) {
            JSSymbolUtil.$$$reportNull$$$0(44);
        }
        if (name.length() == 0) {
            return false;
        }
        char firstChar = (name = JSStringUtil.replaceUnicodeEscapeSequences(name)).charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar)) {
            return false;
        }
        for (int i2 = 1; i2 < name.length(); ++i2) {
            if (Character.isJavaIdentifierPart(name.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSSymbolUtil";
                break;
            }
            case 2: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outSourceReference";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOperand";
                break;
            }
            case 16: 
            case 27: 
            case 28: 
            case 32: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOrIndexedAccessExpression";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsParameter";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSSymbolUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNameIndexArray";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "handleSpecialPropertyNames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createPredefinedNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isConstructorSymbol";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleSpecialPropertyNames";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "areElementsFromSameNamespace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findParameterIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalNamedType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "referencesInterface";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInterface";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "evaluateInitializedPrototype";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNamespaceLocally";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPredefinedNamespace";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "typeMayBeInlined";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calcRefExprValue";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocallyIncludingDefinitions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "evalThis";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "replaceLocalVars";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAccurateReferenceExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceParts";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAccurateReferenceName";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createNamespaceFromReferenceExpression";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addNamespaceComponents";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedNamespace";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralValueAsQualifiedName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "replaceTopmostQualifier";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getParameterInitializationIfRequireArgument";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getParameterInitialization";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedFactoryArgument";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isExportReference";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyName";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findNamespace";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierOfExprAsString";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PropertyProcessor {
        public void process(String var1, JSProperty var2);
    }

    static interface ReferenceExpressionProcessor {
        public void processExpression(JSReferenceExpression var1);

        public void processUnresolvedThis();

        public boolean isTopLevel(JSReferenceExpression var1);
    }
}

