/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.types.JSEmbeddedContentElementType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public class ES6TopLevelAwaitExpressionInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6TopLevelAwaitExpressionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6TopLevelAwaitExpressionInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            private boolean isTopLevelAwaitContext(PsiElement node) {
                PsiElement parent;
                JSFunction parentFunction = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class});
                if (parentFunction != null) {
                    return false;
                }
                JSStatement statement = (JSStatement)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSStatement.class});
                while (statement != null) {
                    parent = statement.getParent();
                    if (parent instanceof JSCaseClause) {
                        parent = parent.getParent();
                    }
                    if (!(parent instanceof JSStatement)) break;
                    statement = (JSStatement)parent;
                }
                if (statement != null) {
                    parent = statement.getParent();
                    if (parent instanceof JSFile && DialectDetector.isTypeScript(parent) && ((JSFile)parent).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.ES6) {
                        return false;
                    }
                    if (parent instanceof JSEmbeddedContent && PsiUtilCore.getElementType((PsiElement)parent) instanceof JSEmbeddedContentElementType) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void visitJSPrefixExpression(JSPrefixExpression node) {
                if (node.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD && this.isTopLevelAwaitContext((PsiElement)node)) {
                    holder.registerProblem(node.getFirstChild(), JavaScriptBundle.message("js.top.level.await.expression.inspection.description", new Object[0]), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitJSForInStatement(JSForInStatement node) {
                if (node.isForAwait() && this.isTopLevelAwaitContext((PsiElement)node)) {
                    String message = JavaScriptBundle.message("javascript.validation.message.for.await.top.level", new Object[0]);
                    ASTNode awaitNode = node.getNode().findChildByType(JSTokenTypes.AWAIT_KEYWORD);
                    if (awaitNode != null) {
                        TextRange range = new TextRange(0, awaitNode.getTextRange().getEndOffset() - node.getTextRange().getStartOffset());
                        holder.registerProblem((PsiElement)node, range, message, new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/ES6TopLevelAwaitExpressionInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

